/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.rss;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.portals.applications.rss.AbstractRssPortlet;
import org.apache.portals.applications.transform.TransformCacheEntry;
import org.apache.portals.applications.util.Streams;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class RSSPortlet
extends AbstractRssPortlet
implements EntityResolver {
    private Document document = null;
    private Map stylesheets = null;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.stylesheets = new HashMap();
        Enumeration e = this.getPortletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String base = "text/html";
            if (!name.startsWith("stylesheet")) continue;
            int idx = -1;
            idx = name.indexOf(".");
            if (idx > -1) {
                base = name.substring(idx + 1, name.length());
            }
            this.stylesheets.put(base, this.getPortletConfig().getInitParameter(name));
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            Reader rdr = this.openURL(publicId);
            InputSource is = new InputSource(rdr);
            is.setPublicId(publicId);
            is.setSystemId(systemId);
            return is;
        }
        catch (IOException x) {
            System.err.println("Entity Resolution error: ( " + publicId + " Taking " + systemId + " from cache throwed Exception: " + x);
            return null;
        }
    }

    private Reader openURL(String urlPath) throws IOException {
        int off;
        URL url = new URL(urlPath);
        URLConnection conn = url.openConnection();
        String enc = conn.getContentEncoding();
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
        is.mark(20480);
        BufferedReader asciiReader = new BufferedReader(new InputStreamReader((InputStream)is, "ASCII"));
        String decl = asciiReader.readLine();
        String key = "encoding=\"";
        if (decl != null && (off = decl.indexOf(key)) > 0) {
            enc = decl.substring(off + key.length(), decl.indexOf(34, off + key.length()));
        }
        is.reset();
        InputStreamReader rdr = new InputStreamReader((InputStream)is, enc);
        return rdr;
    }

    public Document getDocument(String url) throws Exception {
        DocumentBuilder parser = null;
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        docfactory.setValidating(false);
        parser = docfactory.newDocumentBuilder();
        parser.setEntityResolver(this);
        Reader rdr = this.openURL(url);
        InputSource isrc = new InputSource(rdr);
        isrc.setSystemId(url);
        this.document = parser.parse(isrc);
        return this.document;
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletPreferences prefs = request.getPreferences();
        String stylesheet = this.getPortletConfig().getInitParameter("stylesheet");
        String realStylesheet = this.getPortletConfig().getPortletContext().getRealPath(stylesheet);
        String url = prefs.getValue("url", "http://news.bbc.co.uk/rss/sportonline_uk_edition/football/internationals/england/squad_profiles/rss091.xml");
        String key = this.cache.constructKey(url, stylesheet);
        TransformCacheEntry entry = this.cache.get(key);
        if (entry != null) {
            byte[] bytes = (byte[])entry.getDocument();
            Streams.drain((Reader)new StringReader(new String(bytes, "UTF-8")), (Writer)response.getWriter());
        } else {
            try {
                Document document = this.getDocument(url);
                InputSource source = new InputSource(url);
                source.setSystemId(url);
                source.setEncoding("UTF-8");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("itemdisplayed", prefs.getValue("itemdisplayed", "15"));
                parameters.put("openinpopup", prefs.getValue("openinpopup", "true"));
                parameters.put("showdescription", prefs.getValue("showdescription", "true"));
                parameters.put("showtitle", prefs.getValue("showtitle", "true"));
                parameters.put("showtextinput", prefs.getValue("showtextinput", "true"));
                StringWriter sw = new StringWriter();
                this.transform.transform(realStylesheet, source, sw, parameters);
                Streams.drain((Reader)new StringReader(sw.toString()), (Writer)response.getWriter());
                try {
                    Node title;
                    Node node;
                    NodeList nodes = document.getDocumentElement().getElementsByTagName("title");
                    if (nodes != null && (node = nodes.item(0)) != null && (title = node.getFirstChild()) != null) {
                        response.setTitle(title.getNodeValue());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.cache.put(key, sw.toString().getBytes("UTF-8"), 15L);
            }
            catch (Exception ex) {
                response.getPortletOutputStream().write(new String("Failed to process RSS Feed: " + url + ", " + ex).getBytes());
            }
        }
    }
}

