/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.headerresource.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.headerresource.HeaderResourceLib;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderResourceImpl
implements HeaderResource {
    protected static final Logger log = LoggerFactory.getLogger(HeaderResourceImpl.class);
    protected static final String EOL = "\r\n";
    protected static final String UNNAMED_CONTENT_HEADER_NAME = "org.apache.jetspeed.headerresource.unnamed";
    private RequestContext requestContext;
    private BasePortalURL baseUrlAccess = null;
    private boolean isDesktop;
    private Map<String, Object> headerConfiguration;
    private HashMap namedResourcesAlreadyOutput;
    private Map headerDynamicConfiguration;
    private Map headerNamedResources;
    private Map headerNamedResourcesAddedFragments;
    private Map headerResourceRegistry;
    private String portalBaseUrl;
    private String portalUrl;

    public HeaderResourceImpl(RequestContext context) {
        this.requestContext = context;
    }

    public HeaderResourceImpl(RequestContext context, BasePortalURL baseUrlAccess, boolean isDesktop, Map<String, Object> headerConfiguration) {
        this.requestContext = context;
        this.baseUrlAccess = baseUrlAccess;
        this.isDesktop = isDesktop;
        this.headerConfiguration = headerConfiguration;
    }

    public String getContent() {
        StringBuffer header = new StringBuffer();
        this.getNamedResourceContent(null, false, header);
        this.getUnnamedContent(header);
        return header.toString();
    }

    public String toString() {
        return this.getContent();
    }

    public String getUnnamedContent() {
        StringBuffer header = new StringBuffer();
        this.getUnnamedContent(header);
        return header.toString();
    }

    public String getNamedContent() {
        StringBuffer header = new StringBuffer();
        this.getNamedResourceContent(null, false, header);
        return header.toString();
    }

    public String getNamedContent(String headerName) {
        StringBuffer header = new StringBuffer();
        this.getNamedResourceContent(headerName, false, header);
        return header.toString();
    }

    public String getNamedContentForPrefix(String headerNamePrefix) {
        if (headerNamePrefix == null) {
            headerNamePrefix = "";
        }
        if (!headerNamePrefix.endsWith(".")) {
            headerNamePrefix = headerNamePrefix + ".";
        }
        StringBuffer header = new StringBuffer();
        this.getNamedResourceContent(headerNamePrefix, true, header);
        return header.toString();
    }

    protected void getUnnamedContent(StringBuffer header) {
        HashMap<String, Boolean> namedResourcesInOutput = this.getNamedResourcesAlreadyOutput();
        if (namedResourcesInOutput == null) {
            namedResourcesInOutput = new HashMap<String, Boolean>();
            this.setNamedResourcesAlreadyOutput(namedResourcesInOutput);
        }
        if (!namedResourcesInOutput.containsKey(UNNAMED_CONTENT_HEADER_NAME)) {
            namedResourcesInOutput.put(UNNAMED_CONTENT_HEADER_NAME, Boolean.TRUE);
            Set headerInfoSet = this.getHeaderInfoSet();
            Iterator ite = headerInfoSet.iterator();
            while (ite.hasNext()) {
                header.append(((HeaderInfo)ite.next()).toString());
                header.append(EOL);
            }
        }
    }

    protected void getNamedResourceContent(String headerNameMatch, boolean headerNameMatchPrefixOnly, StringBuffer header) {
        List headerOrderList = this.getHeaderSectionOrderList(false);
        if (headerOrderList != null && headerOrderList.size() > 0) {
            HashMap<String, Boolean> namedResourcesInOutput = this.getNamedResourcesAlreadyOutput();
            if (namedResourcesInOutput == null) {
                namedResourcesInOutput = new HashMap<String, Boolean>();
                this.setNamedResourcesAlreadyOutput(namedResourcesInOutput);
            }
            Map namedResources = this.getHeaderSections();
            Map<String, Object> dynamicConfig = this.getHeaderDynamicConfiguration();
            Map headerTypes = this.getHeaderSectionTypes(false);
            Map headerRsrcRegistry = this.getHeaderResourceRegistry();
            HashMap<String, Boolean> headerReqFlagResults = new HashMap<String, Boolean>();
            boolean inScriptBlock = false;
            boolean inStyleBlock = false;
            for (String headerName : headerOrderList) {
                String headerText;
                String headerReqFlag;
                if (namedResourcesInOutput.containsKey(headerName) || headerNameMatch != null && (headerNameMatchPrefixOnly ? !headerName.startsWith(headerNameMatch) : !headerName.equals(headerNameMatch))) continue;
                boolean includeHeader = true;
                Object[] headerTypePair = headerTypes != null ? (Object[])headerTypes.get(headerName) : (Object[])null;
                String string = headerReqFlag = headerTypePair != null ? (String)headerTypePair[1] : (String)null;
                if (headerReqFlag != null && headerReqFlag.length() > 0) {
                    Boolean headerReqFlagResult = (Boolean)headerReqFlagResults.get(headerReqFlag);
                    if (headerReqFlagResult == null) {
                        headerReqFlagResult = Boolean.FALSE;
                        Object headerReqFlagValObj = dynamicConfig.get(headerReqFlag);
                        if (headerReqFlagValObj != null) {
                            headerReqFlagResult = new Boolean(headerReqFlagValObj.toString());
                        }
                        headerReqFlagResults.put(headerReqFlag, headerReqFlagResult);
                    }
                    includeHeader = headerReqFlagResult;
                }
                if (!includeHeader) continue;
                namedResourcesInOutput.put(headerName, Boolean.TRUE);
                Integer headerTypeIdObj = headerTypePair != null ? (Integer)headerTypePair[0] : (Integer)null;
                int headerTypeId = headerTypeIdObj != null ? headerTypeIdObj : 2;
                boolean requiresScriptBlock = false;
                boolean requiresStyleBlock = false;
                boolean preCloseBlock = false;
                boolean postCloseBlock = false;
                switch (headerTypeId) {
                    case 2: {
                        requiresScriptBlock = true;
                        break;
                    }
                    case 1: {
                        preCloseBlock = true;
                        requiresScriptBlock = true;
                        break;
                    }
                    case 4: {
                        preCloseBlock = true;
                        break;
                    }
                    case 3: {
                        postCloseBlock = true;
                        requiresScriptBlock = true;
                        break;
                    }
                    case 5: {
                        requiresStyleBlock = true;
                        break;
                    }
                    case 6: {
                        preCloseBlock = true;
                        break;
                    }
                    case 7: {
                        preCloseBlock = true;
                        break;
                    }
                    default: {
                        log.error("HeaderResource.getNamedResourceContent() cannot include header section with unknown type; header-section-name=" + headerName + " header-section-type-id=" + headerTypeId);
                        includeHeader = false;
                    }
                }
                if (!includeHeader) continue;
                if (requiresScriptBlock && inStyleBlock) {
                    preCloseBlock = true;
                } else if (requiresStyleBlock && inScriptBlock) {
                    preCloseBlock = true;
                }
                if (preCloseBlock) {
                    if (inScriptBlock) {
                        header.append("</script>").append(EOL);
                        inScriptBlock = false;
                    } else if (inStyleBlock) {
                        header.append("</style>").append(EOL);
                        inStyleBlock = false;
                    }
                }
                if ((headerText = (String)namedResources.get(headerName)) == null && (headerText = this.generateHeaderSection(headerName)) == null && headerRsrcRegistry != null) {
                    headerText = (String)headerRsrcRegistry.get(headerName);
                    log.debug("header resource registry text for header section=" + headerName + " headerText=" + headerText);
                }
                if (headerText != null && headerText.length() > 0) {
                    if (requiresScriptBlock && !inScriptBlock) {
                        header.append("<script language=\"JavaScript\" type=\"text/javascript\" ").append("org.apache.portals.portal.page.head.element.contribution.merge.hint").append("=\"").append(headerName).append("\">").append(EOL);
                        inScriptBlock = true;
                    } else if (requiresStyleBlock && !inStyleBlock) {
                        header.append("<style>").append(EOL);
                        inStyleBlock = true;
                    }
                    header.append(headerText).append(EOL);
                }
                if (!postCloseBlock) continue;
                if (inScriptBlock) {
                    header.append("</script>").append(EOL);
                    inScriptBlock = false;
                    continue;
                }
                if (!inStyleBlock) continue;
                header.append("</style>").append(EOL);
                inStyleBlock = false;
            }
            if (inScriptBlock) {
                header.append("</script>").append(EOL);
                inScriptBlock = false;
            } else if (inStyleBlock) {
                header.append("</style>").append(EOL);
                inStyleBlock = false;
            }
        }
    }

    protected String generateHeaderSection(String headerName) {
        if (headerName != null) {
            if (headerName.equals("header.basetag")) {
                return this.jetspeedGenerateBasetag();
            }
            if (headerName.startsWith("header.dojo.")) {
                if (headerName.equals("header.dojo.preinit")) {
                    return this.dojoGeneratePreinit();
                }
                if (headerName.equals("header.dojo.init")) {
                    return this.dojoGenerateInit();
                }
                if (headerName.equals("header.dojo.writeincludes")) {
                    return this.dojoGenerateWriteincludes();
                }
                if (headerName.equals("header.dojo.style.bodyexpand")) {
                    return this.dojoGenerateBodyExpandStyle();
                }
                if (headerName.equals("header.dojo.style.bodyexpand.noscroll")) {
                    return this.dojoGenerateBodyExpandNoScrollStyle();
                }
            }
        }
        return null;
    }

    public void addHeaderSectionFragment(String addToHeaderName, String text) {
        this.addHeaderSectionFragment(null, addToHeaderName, text, false);
    }

    public void addHeaderSectionFragment(String headerFragmentName, String addToHeaderName, String text) {
        this.addHeaderSectionFragment(headerFragmentName, addToHeaderName, text, false);
    }

    protected void addHeaderSectionFragment(String headerFragmentName, String addToHeaderName, String text, boolean alreadyCheckedFragName) {
        if (addToHeaderName != null && text != null) {
            boolean addText = true;
            if (!alreadyCheckedFragName && headerFragmentName != null && this.hasHeaderSectionFragment(headerFragmentName, true)) {
                addText = false;
            }
            if (addText) {
                Map namedResources;
                String nText;
                String overrideText;
                Map headerRsrcRegistry = this.getHeaderResourceRegistry();
                if (headerRsrcRegistry != null && (overrideText = (String)headerRsrcRegistry.get(headerFragmentName)) != null) {
                    text = overrideText;
                }
                if ((nText = (String)(namedResources = this.getHeaderSections()).get(addToHeaderName)) == null) {
                    nText = text + EOL;
                    this.orderHeaderSection(addToHeaderName);
                } else {
                    nText = nText + text + EOL;
                }
                namedResources.put(addToHeaderName, nText);
            }
        }
    }

    public boolean hasHeaderSectionFragment(String headerFragmentName) {
        return this.hasHeaderSectionFragment(headerFragmentName, false);
    }

    protected boolean hasHeaderSectionFragment(String headerFragmentName, boolean setToTrue) {
        if (headerFragmentName != null) {
            Map namedResourcesAddedFragments = this.getHeaderSectionsAddedFragments();
            if (namedResourcesAddedFragments.containsKey(headerFragmentName)) {
                return true;
            }
            if (setToTrue) {
                namedResourcesAddedFragments.put(headerFragmentName, Boolean.TRUE);
            }
        }
        return false;
    }

    protected void orderHeaderSection(String headerName) {
        Map headerNames;
        if (headerName != null && !(headerNames = this.getHeaderSectionNames(true)).containsKey(headerName)) {
            List headerOrderList = this.getHeaderSectionOrderList(true);
            headerOrderList.add(headerName);
            headerNames.put(headerName, Boolean.TRUE);
        }
    }

    public boolean isHeaderSectionIncluded(String headerName) {
        Map headerNames;
        return headerName != null && (headerNames = this.getHeaderSectionNames(false)) != null && headerNames.get(headerName) != null;
    }

    public String getHeaderSectionType(String headerName) {
        Object[] headerTypePair;
        Map headerTypes;
        if (headerName != null && (headerTypes = this.getHeaderSectionTypes(false)) != null && (headerTypePair = (Object[])headerTypes.get(headerName)) != null) {
            Integer headerTypeId = (Integer)headerTypePair[0];
            return HeaderResourceLib.getHeaderType((Integer)headerTypeId);
        }
        return null;
    }

    public void setHeaderSectionType(String headerName, String headerType) {
        if (headerName != null) {
            int headerTypeId = HeaderResourceLib.getHeaderTypeId((String)headerType);
            if (headerTypeId < 0) {
                log.error("HeaderResourceImpl.setHeaderSectionType() ignoring specification of unknown header section type; header-section-name=" + headerName + " header-section-type=" + headerType);
            } else {
                Map headerTypes = this.getHeaderSectionTypes(true);
                Object[] headerTypePair = (Object[])headerTypes.get(headerName);
                if (headerTypePair == null) {
                    if (headerType != null) {
                        headerTypePair = new Object[]{new Integer(headerTypeId), null};
                        headerTypes.put(headerName, headerTypePair);
                    }
                } else {
                    headerTypePair[0] = new Integer(headerTypeId);
                }
            }
        }
    }

    public String getHeaderSectionRequiredFlag(String headerName) {
        Object[] headerTypePair;
        Map headerTypes;
        if (headerName != null && (headerTypes = this.getHeaderSectionTypes(false)) != null && (headerTypePair = (Object[])headerTypes.get(headerName)) != null) {
            return (String)headerTypePair[1];
        }
        return null;
    }

    public void setHeaderSectionRequiredFlag(String headerName, String headerReqFlag) {
        if (headerName != null) {
            Map headerTypes;
            Object[] headerTypePair;
            if (headerReqFlag != null && headerReqFlag.length() == 0) {
                headerReqFlag = null;
            }
            if ((headerTypePair = (Object[])(headerTypes = this.getHeaderSectionTypes(true)).get(headerName)) == null) {
                if (headerReqFlag != null) {
                    headerTypePair = new Object[]{null, headerReqFlag};
                    headerTypes.put(headerName, headerTypePair);
                }
            } else {
                headerTypePair[1] = headerReqFlag;
            }
        }
    }

    protected Map getHeaderSectionTypes(boolean create) {
        Map<String, Object> dynamicConfig = this.getHeaderDynamicConfiguration();
        HashMap headerTypes = (HashMap)dynamicConfig.get("header.types");
        if (headerTypes == null && create) {
            headerTypes = new HashMap();
            dynamicConfig.put("header.types", headerTypes);
        }
        return headerTypes;
    }

    protected Map getHeaderSectionNames(boolean create) {
        Map<String, Object> dynamicConfig = this.getHeaderDynamicConfiguration();
        HashMap headerNames = (HashMap)dynamicConfig.get("header.internal.names");
        if (headerNames == null && create) {
            headerNames = new HashMap();
            dynamicConfig.put("header.internal.names", headerNames);
        }
        return headerNames;
    }

    protected List getHeaderSectionOrderList(boolean create) {
        Map<String, Object> dynamicConfig = this.getHeaderDynamicConfiguration();
        ArrayList headerOrderList = (ArrayList)dynamicConfig.get("header.order");
        if (headerOrderList == null) {
            headerOrderList = new ArrayList();
            dynamicConfig.put("header.order", headerOrderList);
        }
        return headerOrderList;
    }

    public Map<String, Object> getHeaderDynamicConfiguration() {
        if (this.headerDynamicConfiguration == null) {
            this.headerDynamicConfiguration = (Map)this.requestContext.getAttribute("org.apache.jetspeed.headerconfiguration");
            if (this.headerDynamicConfiguration == null) {
                this.headerDynamicConfiguration = new HashMap();
                this.requestContext.setAttribute("org.apache.jetspeed.headerconfiguration", (Object)this.headerDynamicConfiguration);
            }
        }
        return this.headerDynamicConfiguration;
    }

    protected Map getHeaderSections() {
        if (this.headerNamedResources == null) {
            this.headerNamedResources = (Map)this.requestContext.getAttribute("org.apache.jetspeed.headernamedresource");
            if (this.headerNamedResources == null) {
                this.headerNamedResources = new HashMap();
                this.requestContext.setAttribute("org.apache.jetspeed.headernamedresource", (Object)this.headerNamedResources);
            }
        }
        return this.headerNamedResources;
    }

    protected Map getHeaderSectionsAddedFragments() {
        if (this.headerNamedResourcesAddedFragments == null) {
            this.headerNamedResourcesAddedFragments = (Map)this.requestContext.getAttribute("org.apache.jetspeed.headernamedresourceaddedfragments");
            if (this.headerNamedResourcesAddedFragments == null) {
                this.headerNamedResourcesAddedFragments = new HashMap();
                this.requestContext.setAttribute("org.apache.jetspeed.headernamedresourceaddedfragments", (Object)this.headerNamedResourcesAddedFragments);
            }
        }
        return this.headerNamedResourcesAddedFragments;
    }

    protected Map getHeaderResourceRegistry() {
        if (this.headerResourceRegistry == null) {
            this.headerResourceRegistry = (Map)this.requestContext.getAttribute("org.apache.jetspeed.headernamedresourceregistry");
            if (this.headerResourceRegistry == null) {
                this.headerResourceRegistry = new HashMap();
            }
        }
        return this.headerResourceRegistry;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected BasePortalURL getBaseUrlAccess() {
        return this.baseUrlAccess;
    }

    public boolean isDesktop() {
        return this.isDesktop;
    }

    public Map<String, Object> getHeaderConfiguration() {
        return this.headerConfiguration;
    }

    protected HashMap getNamedResourcesAlreadyOutput() {
        return this.namedResourcesAlreadyOutput;
    }

    protected void setNamedResourcesAlreadyOutput(HashMap newOne) {
        this.namedResourcesAlreadyOutput = newOne;
    }

    public String getPortalBaseUrl() {
        if (this.portalBaseUrl == null) {
            this.portalBaseUrl = HeaderResourceLib.getPortalBaseUrl((RequestContext)this.requestContext, (BasePortalURL)this.baseUrlAccess);
        }
        return this.portalBaseUrl;
    }

    public String getPortalBaseUrl(boolean encode) {
        String baseurl = this.getPortalBaseUrl();
        if (!encode) {
            return baseurl;
        }
        return this.requestContext.getResponse().encodeURL(baseurl);
    }

    public String getPortalResourceUrl(String relativePath) {
        return this.getPortalResourceUrl(relativePath, false);
    }

    public String getPortalResourceUrl(String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalBaseUrl(), (boolean)encode, (RequestContext)this.requestContext);
    }

    public String getPortalUrl() {
        if (this.portalUrl == null) {
            this.portalUrl = HeaderResourceLib.getPortalUrl((String)this.getPortalBaseUrl(), (RequestContext)this.requestContext);
        }
        return this.portalUrl;
    }

    public String getPortalUrl(boolean encode) {
        return this.getPortalUrl(null, encode);
    }

    public String getPortalUrl(String relativePath) {
        return this.getPortalUrl(relativePath, false);
    }

    public String getPortalUrl(String relativePath, boolean encode) {
        return HeaderResourceLib.getPortalResourceUrl((String)relativePath, (String)this.getPortalUrl(), (boolean)encode, (RequestContext)this.requestContext);
    }

    protected String jetspeedGenerateBasetag() {
        StringBuffer basetagOut = new StringBuffer();
        String fullPortalBaseUrl = HeaderResourceLib.getPortalBaseUrl((RequestContext)this.requestContext, (BasePortalURL)this.baseUrlAccess, (boolean)true);
        String href = HeaderResourceLib.getPortalResourceUrl((String)"/", (String)fullPortalBaseUrl, (boolean)false, (RequestContext)this.requestContext);
        basetagOut.append("<base href=\"").append(href).append("\">");
        return basetagOut.toString();
    }

    public void dojoAddCoreLibraryRequire(String dojoRequire) {
        this.dojoAddRequire(dojoRequire, "header.dojo.requires.core");
    }

    public void dojoAddCoreLibraryRequires(String dojoRequires) {
        this.dojoAddRequires(dojoRequires, "header.dojo.requires.core");
    }

    public void dojoAddModuleLibraryRequire(String dojoRequire) {
        this.dojoAddRequire(dojoRequire, "header.dojo.requires.modules");
    }

    public void dojoAddModuleLibraryRequires(String dojoRequires) {
        this.dojoAddRequires(dojoRequires, "header.dojo.requires.modules");
    }

    public void dojoAddBodyExpandStyle(boolean omitWindowScrollbars) {
        if (!this.isHeaderSectionIncluded("header.dojo.style.bodyexpand") && !this.isHeaderSectionIncluded("header.dojo.style.bodyexpand.noscroll")) {
            if (!omitWindowScrollbars) {
                this.orderHeaderSection("header.dojo.style.bodyexpand");
            } else {
                this.orderHeaderSection("header.dojo.style.bodyexpand.noscroll");
            }
        }
    }

    public void dojoEnable() {
        this.getHeaderDynamicConfiguration().put("dojo.enable", "true");
    }

    protected void dojoDisable() {
        this.getHeaderDynamicConfiguration().put("dojo.enable", "false");
    }

    protected String dojoGetPath() {
        return (String)this.getHeaderDynamicConfiguration().get("dojo.path");
    }

    protected void dojoAddRequire(String dojoRequire, String addToHeaderName) {
        if (dojoRequire != null && addToHeaderName != null && !this.hasHeaderSectionFragment(dojoRequire, true)) {
            String requireStatement = "    dojo.require(\"" + dojoRequire + "\");";
            this.addHeaderSectionFragment(dojoRequire, addToHeaderName, requireStatement, true);
        }
    }

    protected void dojoAddRequires(String dojoRequires, String addToHeaderName) {
        int reqStatementsLen;
        String[] reqStatements = StringUtils.split((String)dojoRequires, (char)';');
        int n = reqStatementsLen = reqStatements == null ? 0 : reqStatements.length;
        if (reqStatementsLen > 0) {
            for (int i = 0; i < reqStatementsLen; ++i) {
                this.dojoAddRequire(reqStatements[i], addToHeaderName);
            }
        }
    }

    protected String dojoGeneratePreinit() {
        StringBuffer preinitOut = new StringBuffer();
        preinitOut.append("    ").append("djConfig.baseScriptUri = \"").append(this.getPortalResourceUrl(this.dojoGetPath(), false)).append("\";").append(EOL);
        if (this.requestContext.getRequest().getContextPath().length() == 0) {
            preinitOut.append("    ").append("djConfig.jetspeed.rootContext = \"true\";").append(EOL);
        }
        preinitOut.append("    ").append("djConfig.jetspeed.servletPath = \"").append(this.requestContext.getRequest().getServletPath()).append("\";");
        return preinitOut.toString();
    }

    protected String dojoGenerateInit() {
        StringBuffer initOut = new StringBuffer();
        initOut.append("<script type=\"text/javascript\" src=\"").append(this.getPortalResourceUrl(this.dojoGetPath(), false)).append("dojo.js").append("\" id=\"").append("header.dojo.library.include").append("\"></script>");
        return initOut.toString();
    }

    protected String dojoGenerateWriteincludes() {
        return "    dojo.hostenv.writeIncludes();";
    }

    protected String dojoGenerateBodyExpandStyle() {
        Map headerRsrcRegistry = this.getHeaderResourceRegistry();
        String headerText = (String)headerRsrcRegistry.get("header.dojo.style.bodyexpand");
        if (headerText == null) {
            headerText = "html, body { width: 100%; height: 100%; padding: 0 0 0 0; margin: 0 0 0 0; }";
        }
        return headerText;
    }

    protected String dojoGenerateBodyExpandNoScrollStyle() {
        Map headerRsrcRegistry = this.getHeaderResourceRegistry();
        String headerText = (String)headerRsrcRegistry.get("header.dojo.style.bodyexpand.noscroll");
        if (headerText == null) {
            headerText = "html, body { width: 100%; height: 100%; overflow: hidden; padding: 0 0 0 0; margin: 0 0 0 0; }";
        }
        return headerText;
    }

    private Set getHeaderInfoSet() {
        LinkedHashSet headerInfoSet = (LinkedHashSet)this.requestContext.getAttribute("org.apache.jetspeed.headerresource");
        if (headerInfoSet == null) {
            headerInfoSet = new LinkedHashSet();
            this.requestContext.setAttribute("org.apache.jetspeed.headerresource", headerInfoSet);
        }
        return headerInfoSet;
    }

    public void addHeaderInfo(String text) {
        HeaderInfo headerInfo = new HeaderInfo(null, null, text);
        if (!this.containsHeaderInfo(headerInfo)) {
            Set headerInfoSet = this.getHeaderInfoSet();
            headerInfoSet.add(headerInfo);
        }
    }

    public void addHeaderInfo(String elementName, Map<String, String> attributes, String text) {
        HeaderInfo headerInfo = new HeaderInfo(elementName, attributes, text);
        if (!this.containsHeaderInfo(headerInfo)) {
            Set headerInfoSet = this.getHeaderInfoSet();
            headerInfoSet.add(headerInfo);
        }
    }

    private boolean containsHeaderInfo(HeaderInfo headerInfo) {
        Set headerInfoSet = this.getHeaderInfoSet();
        for (HeaderInfo hInfo : headerInfoSet) {
            if (!headerInfo.equals(hInfo)) continue;
            return true;
        }
        return false;
    }

    public void addJavaScript(String path, boolean defer) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("src", this.requestContext.getResponse().encodeURL(path));
        attrs.put("type", "text/javascript");
        if (defer) {
            attrs.put("defer", "true");
        }
        this.addHeaderInfo("script", attrs, "");
    }

    public void addJavaScript(String path) {
        this.addJavaScript(path, false);
    }

    public void addStyleSheet(String path) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("rel", "stylesheet");
        attrs.put("href", this.requestContext.getResponse().encodeURL(path));
        attrs.put("type", "text/css");
        this.addHeaderInfo("link", attrs, null);
    }

    private class HeaderInfo {
        private String elementName;
        private Map attributes;
        private String text;

        public HeaderInfo(String elementName) {
            this(elementName, new HashMap());
        }

        public HeaderInfo(String elementName, Map attr) {
            this(elementName, attr, null);
        }

        public HeaderInfo(String elementName, Map attr, String text) {
            this.setElementName(elementName);
            this.setAttributes(attr);
            this.setText(text);
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            String elmtName = this.getElementName();
            if (elmtName != null && elmtName.length() > 0) {
                buf.append("<");
                buf.append(this.getElementName());
                buf.append(" ");
                Map attrMap = this.getAttributes();
                if (attrMap != null) {
                    Set keySet = attrMap.keySet();
                    for (String key : keySet) {
                        buf.append(key);
                        buf.append("=\"");
                        buf.append((String)attrMap.get(key));
                        buf.append("\" ");
                    }
                }
                if (this.getText() != null) {
                    buf.append(">" + this.getText() + "</" + this.getElementName() + ">");
                } else {
                    buf.append("/>");
                }
            } else if (this.getText() != null) {
                buf.append(this.getText());
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            HeaderInfo headerInfo;
            return o instanceof HeaderInfo && this.compareString((headerInfo = (HeaderInfo)o).getElementName(), this.getElementName()) && this.compareString(headerInfo.getText(), this.getText()) && this.compareAttributes(headerInfo.getAttributes(), this.getAttributes());
        }

        private boolean compareString(String str0, String str1) {
            return str0 == null ? str1 == null : str1 != null && str0.equals(str1);
        }

        private boolean compareAttributes(Map attr0, Map attr1) {
            return attr0 == null ? attr1 == null : attr1 != null && attr0.equals(attr1);
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

