/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class JetspeedWebApplicationRewriter2_3
extends JetspeedWebApplicationRewriter {
    public static final String JETSPEED_SERVLET_XPATH = "/js:web-app/js:servlet/js:servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String JETSPEED_SERVLET_MAPPING_XPATH = "/js:web-app/js:servlet-mapping/js:servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String PORTLET_TAGLIB_XPATH = "/js:web-app/js:taglib/js:taglib-uri[contains(child::text(), \"http://java.sun.com/portlet\")]";
    public static final String PORTLET20_TAGLIB_XPATH = "/js:web-app/js:taglib/js:taglib-uri[contains(child::text(), \"http://java.sun.com/portlet_2_0\")]";
    protected static final String[] ELEMENTS_BEFORE_SERVLET = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    protected static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    protected static final String[] ELEMENTS_BEFORE_TAGLIB_MAPPING = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib"};

    public JetspeedWebApplicationRewriter2_3(Document doc, String portletApplication) {
        super(doc, portletApplication);
    }

    public JetspeedWebApplicationRewriter2_3(Document doc) {
        super(doc);
    }

    protected String getJetspeedServletXPath() {
        return JETSPEED_SERVLET_XPATH.replace("js:", this.getNamespacePrefix());
    }

    protected String getJetspeedServletMappingXPath() {
        return JETSPEED_SERVLET_MAPPING_XPATH.replace("js:", this.getNamespacePrefix());
    }

    protected String getPortletTagLibXPath() {
        return PORTLET_TAGLIB_XPATH.replace("js:", this.getNamespacePrefix());
    }

    protected String getPortlet20TagLibXPath() {
        return PORTLET20_TAGLIB_XPATH.replace("js:", this.getNamespacePrefix());
    }

    protected void insertJetspeedServlet(Element root) throws Exception {
        String namespace = root.getNamespaceURI();
        Element jetspeedServletElement = root.getOwnerDocument().createElementNS(namespace, "servlet");
        Element servletName = root.getOwnerDocument().createElementNS(namespace, "servlet-name");
        servletName.setTextContent("JetspeedContainer");
        Element servletDspName = root.getOwnerDocument().createElementNS(namespace, "display-name");
        servletDspName.setTextContent("Jetspeed Container");
        Element servletDesc = root.getOwnerDocument().createElementNS(namespace, "description");
        servletDesc.setTextContent("MVC Servlet for Jetspeed Portlet Applications");
        Element servletClass = root.getOwnerDocument().createElementNS(namespace, "servlet-class");
        servletClass.setTextContent("org.apache.jetspeed.container.JetspeedContainerServlet");
        jetspeedServletElement.appendChild(servletName);
        jetspeedServletElement.appendChild(servletDspName);
        jetspeedServletElement.appendChild(servletDesc);
        jetspeedServletElement.appendChild(servletClass);
        this.insertContextNameParam(jetspeedServletElement);
        this.insertLoadOnStartup(jetspeedServletElement);
        this.insertElementCorrectly(root, jetspeedServletElement, ELEMENTS_BEFORE_SERVLET);
    }

    protected void insertJetspeedServletMapping(Element root) throws Exception {
        String namespace = root.getNamespaceURI();
        Element jetspeedServletMappingElement = root.getOwnerDocument().createElementNS(namespace, "servlet-mapping");
        Element servletMapName = root.getOwnerDocument().createElementNS(namespace, "servlet-name");
        servletMapName.setTextContent("JetspeedContainer");
        Element servletUrlPattern = root.getOwnerDocument().createElementNS(namespace, "url-pattern");
        servletUrlPattern.setTextContent("/container/*");
        jetspeedServletMappingElement.appendChild(servletMapName);
        jetspeedServletMappingElement.appendChild(servletUrlPattern);
        this.insertElementCorrectly(root, jetspeedServletMappingElement, ELEMENTS_BEFORE_SERVLET_MAPPING);
    }

    protected void insertPortletTagLib(Element root) throws Exception {
        String namespace = root.getNamespaceURI();
        Element taglib = root.getOwnerDocument().createElementNS(namespace, "taglib");
        Element taguri = root.getOwnerDocument().createElementNS(namespace, "taglib-uri");
        taguri.setTextContent("http://java.sun.com/portlet");
        Element taglocation = root.getOwnerDocument().createElementNS(namespace, "taglib-location");
        taglocation.setTextContent("/WEB-INF/tld/portlet.tld");
        taglib.appendChild(taguri);
        taglib.appendChild(taglocation);
        this.insertElementCorrectly(root, taglib, ELEMENTS_BEFORE_TAGLIB_MAPPING);
    }

    protected void insertPortlet20TagLib(Element root) throws Exception {
        String namespace = root.getNamespaceURI();
        Element taglib = root.getOwnerDocument().createElementNS(namespace, "taglib");
        Element taguri = root.getOwnerDocument().createElementNS(namespace, "taglib-uri");
        taguri.setTextContent("http://java.sun.com/portlet_2_0");
        Element taglocation = root.getOwnerDocument().createElementNS(namespace, "taglib-location");
        taglocation.setTextContent("/WEB-INF/tld/portlet_2_0.tld");
        taglib.appendChild(taguri);
        taglib.appendChild(taglocation);
        this.insertElementCorrectly(root, taglib, ELEMENTS_BEFORE_TAGLIB_MAPPING);
    }
}

