/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.jetspeed.logger.JetspeedLogger;
import org.apache.jetspeed.logger.JetspeedLoggerFactory;
import org.apache.jetspeed.services.JetspeedPortletServices;
import org.apache.jetspeed.services.PortletServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedLoggerUtil {
    public static final String DEFAULT_LOGGER_FACTORY = "org.slf4j.LoggerFactory";
    public static final String DEFAULT_LOGGER_FACTORY_METHOD = "getLogger";
    public static final String LOCATION_AWARE_LOGGER_FQN = "org.slf4j.spi.LocationAwareLogger";
    public static final String MESSAGE_FORMATTER_FQN = "org.slf4j.helpers.MessageFormatter";
    private static JetspeedLogger noopLogger = new NOOPJetspeedLogger();

    private JetspeedLoggerUtil() {
    }

    public static JetspeedLogger getLocalLogger(Class<?> clazz) {
        try {
            Class<?> factoryClazz = Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_LOGGER_FACTORY);
            Object logger = JetspeedLoggerUtil.invokeDeclaredMethod(factoryClazz, DEFAULT_LOGGER_FACTORY_METHOD, new Class[]{Class.class}, clazz);
            if (logger != null) {
                Class<?> locationAwareLoggerClazz = Thread.currentThread().getContextClassLoader().loadClass(LOCATION_AWARE_LOGGER_FQN);
                Class<?> messageFormatterClazz = Thread.currentThread().getContextClassLoader().loadClass(MESSAGE_FORMATTER_FQN);
                return new DelegatingByReflectionJetspeedLogger(logger, locationAwareLoggerClazz.isAssignableFrom(logger.getClass()), locationAwareLoggerClazz, messageFormatterClazz);
            }
        }
        catch (Exception e) {
            JetspeedLoggerUtil.getSharedLogger(clazz).warn("Failed to create PA logger: " + e);
        }
        return null;
    }

    public static JetspeedLogger getLocalLogger(String name) {
        try {
            Class<?> factoryClazz = Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_LOGGER_FACTORY);
            Object logger = JetspeedLoggerUtil.invokeDeclaredMethod(factoryClazz, DEFAULT_LOGGER_FACTORY_METHOD, new Class[]{String.class}, name);
            if (logger != null) {
                Class<?> locationAwareLoggerClazz = Thread.currentThread().getContextClassLoader().loadClass(LOCATION_AWARE_LOGGER_FQN);
                Class<?> messageFormatterClazz = Thread.currentThread().getContextClassLoader().loadClass(MESSAGE_FORMATTER_FQN);
                return new DelegatingByReflectionJetspeedLogger(logger, locationAwareLoggerClazz.isAssignableFrom(logger.getClass()), locationAwareLoggerClazz, messageFormatterClazz);
            }
        }
        catch (Exception e) {
            JetspeedLoggerUtil.getSharedLogger(name).warn("Failed to create PA logger: " + e);
        }
        return null;
    }

    public static JetspeedLogger getSharedLogger(Class<?> clazz) {
        JetspeedLoggerFactory jsLoggerFactory;
        PortletServices ps = JetspeedPortletServices.getSingleton();
        if (ps != null && (jsLoggerFactory = (JetspeedLoggerFactory)ps.getService(JetspeedLoggerFactory.class.getName())) != null) {
            return jsLoggerFactory.getLogger(clazz);
        }
        return noopLogger;
    }

    public static JetspeedLogger getSharedLogger(String name) {
        JetspeedLoggerFactory jsLoggerFactory;
        PortletServices ps = JetspeedPortletServices.getSingleton();
        if (ps != null && (jsLoggerFactory = (JetspeedLoggerFactory)ps.getService(JetspeedLoggerFactory.class.getName())) != null) {
            return jsLoggerFactory.getLogger(name);
        }
        return noopLogger;
    }

    private static Object invokeDeclaredMethod(Class<?> targetClazz, String methodName, Class<?>[] argTypes, Object ... args) {
        try {
            Method method = targetClazz.getDeclaredMethod(methodName, argTypes);
            return method.invoke(targetClazz, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke logging method. " + e);
        }
    }

    private static class NOOPJetspeedLogger
    implements JetspeedLogger,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NOOPJetspeedLogger() {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public void debug(String msg) {
        }

        public void debug(String format, Object arg) {
        }

        public void debug(String format, Object arg1, Object arg2) {
        }

        public void debug(String format, Object[] argArray) {
        }

        public void debug(String msg, Throwable t) {
        }

        public void info(String msg) {
        }

        public void info(String format, Object arg) {
        }

        public void info(String format, Object arg1, Object arg2) {
        }

        public void info(String format, Object[] argArray) {
        }

        public void info(String msg, Throwable t) {
        }

        public void warn(String msg) {
        }

        public void warn(String format, Object arg) {
        }

        public void warn(String format, Object[] argArray) {
        }

        public void warn(String format, Object arg1, Object arg2) {
        }

        public void warn(String msg, Throwable t) {
        }

        public void error(String msg) {
        }

        public void error(String format, Object arg) {
        }

        public void error(String format, Object arg1, Object arg2) {
        }

        public void error(String format, Object[] argArray) {
        }

        public void error(String msg, Throwable t) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingByReflectionJetspeedLogger
    implements JetspeedLogger,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FQCN = DelegatingByReflectionJetspeedLogger.class.getName();
        private static final int DEBUG_INT = 10;
        private static final int INFO_INT = 20;
        private static final int WARN_INT = 30;
        private static final int ERROR_INT = 40;
        private Class<?> targetClazz;
        private Object targetLogger;
        private boolean locationAware;
        private Method locationAwareLoggerLogMethod;
        private int locationAwareLoggerLogMethodArgsCount;
        private Class<?> formatterClazz;
        private Method arrayFormatMethod;
        private Method formattingTupleGetMessageMethod;

        public DelegatingByReflectionJetspeedLogger(Object targetLogger, boolean locationAware, Class<?> locationAwareLoggerClazz, Class<?> formatterClazz) {
            this.targetLogger = targetLogger;
            this.targetClazz = targetLogger.getClass();
            this.locationAware = locationAware;
            if (locationAware) {
                for (Method method : locationAwareLoggerClazz.getMethods()) {
                    int argsCount;
                    if (!"log".equals(method.getName()) || (argsCount = method.getParameterTypes().length) != 6 && argsCount != 5) continue;
                    this.locationAwareLoggerLogMethod = method;
                    this.locationAwareLoggerLogMethodArgsCount = argsCount;
                    break;
                }
            }
            this.formatterClazz = formatterClazz;
        }

        @Override
        public boolean isDebugEnabled() {
            return (Boolean)this.invokeLoggerMethod("isDebugEnabled", null, new Object[0]);
        }

        @Override
        public boolean isInfoEnabled() {
            return (Boolean)this.invokeLoggerMethod("isInfoEnabled", null, new Object[0]);
        }

        @Override
        public boolean isWarnEnabled() {
            return (Boolean)this.invokeLoggerMethod("isWarnEnabled", null, new Object[0]);
        }

        @Override
        public boolean isErrorEnabled() {
            return (Boolean)this.invokeLoggerMethod("isErrorEnabled", null, new Object[0]);
        }

        @Override
        public void debug(String msg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(10, msg, null, null);
            } else {
                this.invokeLoggerMethod("debug", new Class[]{String.class}, msg);
            }
        }

        @Override
        public void debug(String format, Object arg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(10, format, new Object[]{arg}, null);
            } else {
                this.invokeLoggerMethod("debug", new Class[]{String.class, Object.class}, format, arg);
            }
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(10, format, new Object[]{arg1, arg2}, null);
            } else {
                this.invokeLoggerMethod("debug", new Class[]{String.class, Object.class, Object.class}, format, arg1, arg2);
            }
        }

        @Override
        public void debug(String format, Object[] argArray) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(10, format, argArray, null);
            } else {
                this.invokeLoggerMethod("debug", new Class[]{String.class, Object[].class}, format, argArray);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(10, msg, null, t);
            } else {
                this.invokeLoggerMethod("debug", new Class[]{String.class, Throwable.class}, msg, t);
            }
        }

        @Override
        public void info(String msg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(20, msg, null, null);
            } else {
                this.invokeLoggerMethod("info", new Class[]{String.class}, msg);
            }
        }

        @Override
        public void info(String format, Object arg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(20, format, new Object[]{arg}, null);
            } else {
                this.invokeLoggerMethod("info", new Class[]{String.class, Object.class}, format, arg);
            }
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(20, format, new Object[]{arg1, arg2}, null);
            } else {
                this.invokeLoggerMethod("info", new Class[]{String.class, Object.class, Object.class}, format, arg1, arg2);
            }
        }

        @Override
        public void info(String format, Object[] argArray) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(20, format, argArray, null);
            } else {
                this.invokeLoggerMethod("info", new Class[]{String.class, Object[].class}, format, argArray);
            }
        }

        @Override
        public void info(String msg, Throwable t) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(20, msg, null, t);
            } else {
                this.invokeLoggerMethod("info", new Class[]{String.class, Throwable.class}, msg, t);
            }
        }

        @Override
        public void warn(String msg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(30, msg, null, null);
            } else {
                this.invokeLoggerMethod("warn", new Class[]{String.class}, msg);
            }
        }

        @Override
        public void warn(String format, Object arg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(30, format, new Object[]{arg}, null);
            } else {
                this.invokeLoggerMethod("warn", new Class[]{String.class, Object.class}, format, arg);
            }
        }

        @Override
        public void warn(String format, Object arg1, Object arg2) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(30, format, new Object[]{arg1, arg2}, null);
            } else {
                this.invokeLoggerMethod("warn", new Class[]{String.class, Object.class, Object.class}, format, arg1, arg2);
            }
        }

        @Override
        public void warn(String format, Object[] argArray) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(30, format, argArray, null);
            } else {
                this.invokeLoggerMethod("warn", new Class[]{String.class, Object[].class}, format, argArray);
            }
        }

        @Override
        public void warn(String msg, Throwable t) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(30, msg, null, t);
            } else {
                this.invokeLoggerMethod("warn", new Class[]{String.class, Throwable.class}, msg, t);
            }
        }

        @Override
        public void error(String msg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(40, msg, null, null);
            } else {
                this.invokeLoggerMethod("error", new Class[]{String.class}, msg);
            }
        }

        @Override
        public void error(String format, Object arg) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(40, format, new Object[]{arg}, null);
            } else {
                this.invokeLoggerMethod("error", new Class[]{String.class, Object.class}, format, arg);
            }
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(40, format, new Object[]{arg1, arg2}, null);
            } else {
                this.invokeLoggerMethod("error", new Class[]{String.class, Object.class, Object.class}, format, arg1, arg2);
            }
        }

        @Override
        public void error(String format, Object[] argArray) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(40, format, argArray, null);
            } else {
                this.invokeLoggerMethod("error", new Class[]{String.class, Object[].class}, format, argArray);
            }
        }

        @Override
        public void error(String msg, Throwable t) {
            if (this.locationAware) {
                this.invokeLocationAwareLoggerMethod(40, msg, null, t);
            } else {
                this.invokeLoggerMethod("error", new Class[]{String.class, Throwable.class}, msg, t);
            }
        }

        private Object invokeLoggerMethod(String methodName, Class<?>[] argTypes, Object ... args) {
            try {
                Method method = this.targetClazz.getMethod(methodName, argTypes);
                return method.invoke(this.targetLogger, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke logger method, " + methodName + ", on " + this.targetLogger + ". " + e);
            }
        }

        private Object invokeLocationAwareLoggerMethod(int level, String format, Object[] argArray, Throwable t) {
            try {
                String msg = null;
                msg = argArray == null || argArray.length == 0 ? format : this.arrayFormat(format, argArray);
                if (this.locationAwareLoggerLogMethodArgsCount == 6) {
                    return this.locationAwareLoggerLogMethod.invoke(this.targetLogger, null, FQCN, level, msg, null, t);
                }
                return this.locationAwareLoggerLogMethod.invoke(this.targetLogger, null, FQCN, level, msg, t);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke location aware logger's log method on " + this.targetLogger + ". " + e);
            }
        }

        private String arrayFormat(String format, Object[] objectArray) {
            try {
                Object ret;
                if (this.arrayFormatMethod == null) {
                    this.arrayFormatMethod = this.formatterClazz.getMethod("arrayFormat", String.class, Object[].class);
                }
                if ((ret = this.arrayFormatMethod.invoke(this.formatterClazz, format, objectArray)) == null) {
                    return null;
                }
                if (ret instanceof String) {
                    return (String)ret;
                }
                if (this.formattingTupleGetMessageMethod == null) {
                    this.formattingTupleGetMessageMethod = ret.getClass().getMethod("getMessage", null);
                }
                return (String)this.formattingTupleGetMessageMethod.invoke(ret, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke arrayFormat method on " + this.formatterClazz + ". " + e);
            }
        }
    }
}

