/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.capabilities.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import org.apache.jetspeed.capabilities.Capabilities;
import org.apache.jetspeed.capabilities.CapabilitiesException;
import org.apache.jetspeed.capabilities.Capability;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.capabilities.Client;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.capabilities.MimeType;
import org.apache.jetspeed.capabilities.UnableToBuildCapabilityMapException;
import org.apache.jetspeed.capabilities.impl.CapabilityMapImpl;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class JetspeedCapabilities
extends InitablePersistenceBrokerDaoSupport
implements Capabilities,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(JetspeedCapabilities.class);
    public static final String DEFAULT_AGENT = "Mozilla/4.0";
    public static final String AGENT_XML = "agentxml/1.0";
    public static final int MAX_CACHE_SIZE = 500;
    private Hashtable capabilityMapCache = new Hashtable();
    private LinkedList capabilityMapCacheKeyList = new LinkedList();
    private Collection clients = null;
    private BeanFactory beanFactory;
    private String clientBeanName;
    private String capabilityBeanName;
    private String mimeTypeBeanName;
    private String mediaTypeBeanName;
    private Class clientClass;
    private Class capabilityClass;
    private Class mimeTypeClass;
    private Class mediaTypeClass;

    public JetspeedCapabilities(String repositoryPath, String clientBeanName, String mediaTypeBeanName, String mimeTypeBeanName, String capabilityBeanName) {
        super(repositoryPath);
        this.clientBeanName = clientBeanName;
        this.capabilityBeanName = capabilityBeanName;
        this.mimeTypeBeanName = mimeTypeBeanName;
        this.mediaTypeBeanName = mediaTypeBeanName;
    }

    public JetspeedCapabilities(String repositoryPath, Properties properties) {
        super(repositoryPath);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private Class getClientClass() throws ClassNotFoundException {
        if (this.clientClass == null) {
            this.clientClass = this.createClient(null).getClass();
        }
        return this.clientClass;
    }

    private Class getMimeTypeClass() throws ClassNotFoundException {
        if (this.mimeTypeClass == null) {
            this.mimeTypeClass = this.createMimeType(null).getClass();
        }
        return this.mimeTypeClass;
    }

    private Class getCapabilityClass() throws ClassNotFoundException {
        if (this.capabilityClass == null) {
            this.capabilityClass = this.createCapability(null).getClass();
        }
        return this.capabilityClass;
    }

    private Class getMediaTypeClass() throws ClassNotFoundException {
        if (this.mediaTypeClass == null) {
            this.mediaTypeClass = this.createMediaType(null).getClass();
        }
        return this.mediaTypeClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CapabilityMap getCapabilityMap(String userAgent) throws UnableToBuildCapabilityMapException {
        CapabilityMap map = null;
        boolean bClientFound = false;
        String defaultAgent = null;
        if (userAgent == null) {
            userAgent = DEFAULT_AGENT;
        }
        Hashtable hashtable = this.capabilityMapCache;
        synchronized (hashtable) {
            map = (CapabilityMap)this.capabilityMapCache.get(userAgent);
            if (map != null) {
                this.capabilityMapCacheKeyList.remove(userAgent);
                this.capabilityMapCacheKeyList.addFirst(userAgent);
            }
        }
        if (map != null) {
            return map;
        }
        while (!bClientFound) {
            Client entry = this.findClient(userAgent);
            if (entry == null) {
                if (userAgent.equals(DEFAULT_AGENT)) {
                    log.error("CapabilityMap: Default agent not found in Client Registry !");
                    bClientFound = true;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("CapabilityMap: useragent " + userAgent + "unknown, falling back to default");
                }
                defaultAgent = userAgent;
                userAgent = DEFAULT_AGENT;
                continue;
            }
            map = new CapabilityMapImpl();
            map.setClient(entry);
            Iterator capabilities = entry.getCapabilities().iterator();
            while (capabilities.hasNext()) {
                map.addCapability((Capability)capabilities.next());
            }
            Collection mediatypes = this.getMediaTypesForMimeTypes(entry.getMimetypes().iterator());
            Iterator mimetypes = entry.getMimetypes().iterator();
            while (mimetypes.hasNext()) {
                map.addMimetype((MimeType)mimetypes.next());
            }
            Iterator media = mediatypes.iterator();
            while (media.hasNext()) {
                map.addMediaType((MediaType)media.next());
            }
            MediaType mtEntry = this.getMediaTypeForMimeType(map.getPreferredType().getName());
            map.setPreferredMediaType(mtEntry);
            Hashtable hashtable2 = this.capabilityMapCache;
            synchronized (hashtable2) {
                if (this.capabilityMapCache.put(userAgent, map) != null) {
                    this.capabilityMapCacheKeyList.remove(userAgent);
                }
                this.capabilityMapCacheKeyList.addFirst(userAgent);
                if (defaultAgent != null) {
                    if (this.capabilityMapCache.put(defaultAgent, map) != null) {
                        this.capabilityMapCacheKeyList.remove(defaultAgent);
                    }
                    this.capabilityMapCacheKeyList.addFirst(defaultAgent);
                }
                while (this.capabilityMapCache.size() > 500) {
                    String reapAgent = (String)this.capabilityMapCacheKeyList.removeLast();
                    this.capabilityMapCache.remove(reapAgent);
                }
            }
            return map;
        }
        if (map != null) {
            return map;
        }
        throw new UnableToBuildCapabilityMapException("We were unable to build a capability map for the agent, " + userAgent + ".  This might be an indiciation that the capability database has not been correctly initialized.");
    }

    public Client findClient(String userAgent) {
        Client clientEntry = null;
        Iterator clients = this.getClients();
        if (log.isDebugEnabled()) {
            log.debug("ClientRegistry: Looking for client with useragent :" + userAgent);
        }
        while (clients.hasNext()) {
            Client client = (Client)clients.next();
            if (client.getUserAgentPattern() == null) continue;
            try {
                String exp = client.getUserAgentPattern();
                if (userAgent.matches(exp)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Client: " + userAgent + " matches " + client.getUserAgentPattern());
                    }
                    return client;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Client: " + userAgent + " does not match " + client.getUserAgentPattern());
            }
            catch (PatternSyntaxException e) {
                String message = "CapabilityServiceImpl: UserAgentPattern not valid : " + client.getUserAgentPattern() + " : " + e.getMessage();
                log.error(message, (Throwable)e);
            }
        }
        return clientEntry;
    }

    public Iterator getClients() {
        if (null == this.clients) {
            try {
                QueryByCriteria query = QueryFactory.newQuery((Class)this.getClientClass(), (Criteria)new Criteria());
                query.addOrderByAscending("evalOrder");
                this.clients = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            }
            catch (Exception e) {
                String message = "CapabilityServiceImpl: getClients query used invalid class ";
                log.error(message, (Throwable)e);
                return null;
            }
        }
        return this.clients.iterator();
    }

    public Collection getMediaTypesForMimeTypes(Iterator mimetypes) {
        Criteria filter = new Criteria();
        Vector<String> temp = new Vector<String>();
        while (mimetypes.hasNext()) {
            MimeType mt = (MimeType)mimetypes.next();
            temp.add(mt.getName());
        }
        Collection co = null;
        if (temp.size() > 0) {
            try {
                filter.addIn("mimetypes.name", temp);
                QueryByCriteria query = QueryFactory.newQuery((Class)this.getMediaTypeClass(), (Criteria)filter);
                co = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            }
            catch (Exception e) {
                String message = "CapabilityServiceImpl: getMediaTypesForMimeTypes -> getMediaTypeClass query used invalid class ";
                log.error(message, (Throwable)e);
            }
        }
        if (co == null || co.isEmpty()) {
            MediaType mt = this.getMediaType("html");
            Vector<MediaType> v = new Vector<MediaType>();
            v.add(mt);
            return v;
        }
        return co;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCapabilityMapCache() {
        Hashtable hashtable = this.capabilityMapCache;
        synchronized (hashtable) {
            this.capabilityMapCache.clear();
            this.capabilityMapCacheKeyList.clear();
        }
        this.clients = null;
    }

    public MediaType getMediaType(String mediaType) {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("name", (Object)mediaType);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getMediaTypeClass(), (Criteria)filter);
            return (MediaType)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        catch (Exception e) {
            String message = "CapabilityServiceImpl: getMediaType query used invalid class ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MediaType getMediaTypeForMimeType(String mimeTypeName) {
        Collection mediaTypeCollection = null;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("mimetypes.name", (Object)mimeTypeName);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getMediaTypeClass(), (Criteria)filter);
            mediaTypeCollection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        }
        catch (Exception e) {
            String message = "CapabilityServiceImpl: getMediaTypeForMimeType query used invalid class ";
            log.error(message, (Throwable)e);
            return null;
        }
        Iterator mtIterator = mediaTypeCollection.iterator();
        if (mtIterator.hasNext()) {
            return (MediaType)mtIterator.next();
        }
        return null;
    }

    public Iterator getCapabilities() {
        QueryByCriteria query = null;
        try {
            query = QueryFactory.newQuery((Class)this.getCapabilityClass(), (Criteria)new Criteria());
        }
        catch (Exception e) {
            String message = "CapabilityServiceImpl: getCapabilities query used invalid class ";
            log.error(message, (Throwable)e);
            return null;
        }
        query.addOrderByAscending("name");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).iterator();
    }

    public Iterator getMimeTypes() {
        try {
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getMimeTypeClass(), (Criteria)new Criteria());
            query.addOrderByAscending("name");
            return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).iterator();
        }
        catch (Exception e) {
            String message = "CapabilityServiceImpl: getMimeTypes query used invalid class ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Iterator getMediaTypes() {
        try {
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getMediaTypeClass(), (Criteria)new Criteria());
            query.addOrderByAscending("name");
            return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).iterator();
        }
        catch (Exception e) {
            String message = "CapabilityServiceImpl: getMediaTypes query used invalid class ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public String getMimeTypeBeanName() {
        return this.mimeTypeBeanName;
    }

    public void setMimeTypeBeanName(String mimeTypeBeanName) {
        this.mimeTypeBeanName = mimeTypeBeanName;
    }

    public String getClientBeanName() {
        return this.clientBeanName;
    }

    public void setClientBeanName(String clientBeanName) {
        this.clientBeanName = clientBeanName;
    }

    public String getMediaTypeBeanName() {
        return this.mediaTypeBeanName;
    }

    public void setMediaTypeBeanName(String mediaTypeBeanName) {
        this.mediaTypeBeanName = mediaTypeBeanName;
    }

    public String getCapabilityBeanName() {
        return this.capabilityBeanName;
    }

    public void setCapabilityBeanName(String capabilityBeanName) {
        this.capabilityBeanName = capabilityBeanName;
    }

    public MimeType createMimeType(String mimeType) throws ClassNotFoundException {
        MimeType mimeTypeobj = null;
        if (mimeType != null && (mimeTypeobj = this.getMimeType(mimeType)) != null) {
            return mimeTypeobj;
        }
        try {
            mimeTypeobj = (MimeType)this.beanFactory.getBean(this.mimeTypeBeanName, MimeType.class);
            mimeTypeobj.setName(mimeType);
            return mimeTypeobj;
        }
        catch (Exception e) {
            log.error("Failed to create capability instance for " + this.mimeTypeBeanName + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the " + this.mimeTypeBeanName + " mimeType bean.", e);
        }
    }

    public Capability createCapability(String capabilityName) throws ClassNotFoundException {
        Capability capability = null;
        if (capabilityName != null && (capability = this.getCapability(capabilityName)) != null) {
            return capability;
        }
        try {
            capability = (Capability)this.beanFactory.getBean(this.capabilityBeanName, Capability.class);
            capability.setName(capabilityName);
            return capability;
        }
        catch (Exception e) {
            log.error("Failed to create capability instance for " + this.capabilityBeanName + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  capability bean.", e);
        }
    }

    public MediaType createMediaType(String mediaTypeName) throws ClassNotFoundException {
        MediaType mediaType = null;
        if (mediaTypeName != null && (mediaType = this.getMediaType(mediaTypeName)) != null) {
            return mediaType;
        }
        try {
            mediaType = (MediaType)this.beanFactory.getBean(this.mediaTypeBeanName, MediaType.class);
            mediaType.setName(mediaTypeName);
            return mediaType;
        }
        catch (Exception e) {
            log.error("Failed to create mediaType instance for " + this.mediaTypeBeanName + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  mediaType bean.", e);
        }
    }

    public Client createClient(String clientName) throws ClassNotFoundException {
        Client client = null;
        if (clientName != null && (client = this.getClient(clientName)) != null) {
            return client;
        }
        try {
            client = (Client)this.beanFactory.getBean(this.clientBeanName, Client.class);
            client.setName(clientName);
            return client;
        }
        catch (Exception e) {
            log.error("Failed to create client instance for " + this.clientBeanName + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  client bean.", e);
        }
    }

    public MimeType getMimeType(String mimeType) {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("name", (Object)mimeType);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getMimeTypeClass(), (Criteria)filter);
            return (MimeType)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        catch (Exception e) {
            String message = "MimeTypeserviceImpl: getCapability - query for getCapabilityClass failed ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Client getClient(String clientName) {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("name", (Object)clientName);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getClientClass(), (Criteria)filter);
            return (Client)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        catch (Exception e) {
            String message = "MimeTypeserviceImpl: getClient - query for getClientClass failed ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Capability getCapability(String capability) {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("name", (Object)capability);
            QueryByCriteria query = QueryFactory.newQuery((Class)this.getCapabilityClass(), (Criteria)filter);
            return (Capability)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        catch (Exception e) {
            String message = "MimeTypeserviceImpl: getCapability - query for getCapabilityClass failed ";
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public void storeMediaType(MediaType mediaType) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().store((Object)mediaType);
    }

    public void deleteMediaType(MediaType mediaType) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().delete((Object)mediaType);
    }

    public void storeCapability(Capability capability) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().store((Object)capability);
    }

    public void deleteCapability(Capability capability) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().delete((Object)capability);
    }

    public void storeMimeType(MimeType mimeType) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().store((Object)mimeType);
    }

    public void deleteMimeType(MimeType mimeType) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().delete((Object)mimeType);
    }

    public void storeClient(Client client) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().store((Object)client);
    }

    public void deleteClient(Client client) throws CapabilitiesException {
        this.getPersistenceBrokerTemplate().delete((Object)client);
    }
}

