/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.Link;
import com.google.step2.discovery.LinkPattern;
import com.google.step2.discovery.LinkSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class HostMeta {
    private static final Logger log = Logger.getLogger(HostMeta.class.getName());
    private final ArrayList<Link> links = new ArrayList();
    private final ArrayList<LinkPattern> linkPatterns = new ArrayList();

    public static HostMeta parseFromStream(InputStream content) throws IOException {
        String line;
        HostMeta result = new HostMeta();
        BufferedReader reader = new BufferedReader(new InputStreamReader(content, "UTF-8"));
        int i = 0;
        while ((line = reader.readLine()) != null) {
            ++i;
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            try {
                if (line.toLowerCase().startsWith("link:")) {
                    result.addLink(Link.fromString(line));
                    continue;
                }
                if (line.toLowerCase().startsWith("link-pattern:")) {
                    result.addLinkPattern(LinkPattern.fromString(line));
                    continue;
                }
                log.info("ignoring line in host-meta: " + line);
            }
            catch (LinkSyntaxException e) {
                log.warning("could not parse line " + i + " in host-meta: " + line);
            }
        }
        return result;
    }

    public static HostMeta parseFromBytes(byte[] bytes) {
        try {
            return HostMeta.parseFromStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public Collection<LinkPattern> getLinkPatterns() {
        return this.linkPatterns;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addLinkPattern(LinkPattern linkPattern) {
        this.linkPatterns.add(linkPattern);
    }
}

