/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.samples.opc;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.StreamHelper;
import org.openxml4j.samples.DemoCore;

public class ModifyXMLContentWordprocessingMLDocument {
    public static void main(String[] args) throws Exception {
        DemoCore demoCore = new DemoCore();
        Package pkg = Package.open(demoCore.getTestRootPath() + "sample.docx", PackageAccess.READ_WRITE);
        PackageRelationship coreDocumentRelationship = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        PackagePart coreDocumentPart = pkg.getPart(coreDocumentRelationship);
        InputStream inStream = coreDocumentPart.getInputStream();
        SAXReader docReader = new SAXReader();
        Document doc = docReader.read(inStream);
        Namespace namespaceWordProcessingML = new Namespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        Element bodyElement = doc.getRootElement().element(new QName("body", namespaceWordProcessingML));
        List paragraphs = bodyElement.content();
        Element paragraph = DocumentHelper.createElement((QName)new QName("p", namespaceWordProcessingML));
        Element run = paragraph.addElement(new QName("r", namespaceWordProcessingML));
        Element text = run.addElement(new QName("t", namespaceWordProcessingML));
        text.setText("New paragraph added with OpenXML4J !");
        paragraphs.add(paragraphs.size() - 1, paragraph);
        StreamHelper.saveXmlInStream(doc, coreDocumentPart.getOutputStream());
        pkg.save(new File(demoCore.getTestRootPath() + "sample_output.docx"));
    }
}

