/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.SupportedModesService;
import org.apache.pluto.spi.optional.PortletRegistryService;

public class SupportedModesServiceImpl
implements SupportedModesService {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$services$impl$resource$SupportedModesServiceImpl == null ? (class$org$apache$pluto$driver$services$impl$resource$SupportedModesServiceImpl = SupportedModesServiceImpl.class$("org.apache.pluto.driver.services.impl.resource.SupportedModesServiceImpl")) : class$org$apache$pluto$driver$services$impl$resource$SupportedModesServiceImpl));
    private Set supportedPortletModesByPortal = new HashSet();
    private PortletRegistryService portletRegistry;
    private PropertyConfigService propertyService;
    private ServletContext servletContext;
    static /* synthetic */ Class class$org$apache$pluto$driver$services$impl$resource$SupportedModesServiceImpl;

    public SupportedModesServiceImpl(PropertyConfigService propertyService) {
        this.propertyService = propertyService;
    }

    public boolean isPortletModeSupported(String portletId, String mode) {
        return this.isPortletModeSupportedByPortal(mode) && this.isPortletModeSupportedByPortlet(portletId, mode);
    }

    public boolean isPortletModeSupportedByPortal(String mode) {
        return this.supportedPortletModesByPortal.contains(new PortletMode(mode));
    }

    public boolean isPortletModeSupportedByPortlet(String portletId, String mode) {
        String applicationId = PortletWindowConfig.parseContextPath((String)portletId);
        String portletName = PortletWindowConfig.parsePortletName((String)portletId);
        if (this.portletRegistry == null) {
            this.portletRegistry = ((PortletContainer)this.servletContext.getAttribute("portletContainer")).getOptionalContainerServices().getPortletRegistryService();
        }
        try {
            if (this.portletRegistry == null) {
                LOG.error((Object)"Optional Portlet Registry Service not found.");
                throw new PortletContainerException("Optional Portlet Registry Service not found.");
            }
            PortletAppDD ctx = this.portletRegistry.getPortletApplicationDescriptor(applicationId);
            Iterator i = ctx.getPortlets().iterator();
            while (i.hasNext()) {
                PortletDD dd = (PortletDD)i.next();
                if (!portletName.equals(dd.getPortletName())) continue;
                Iterator i2 = dd.getSupports().iterator();
                while (i2.hasNext()) {
                    SupportsDD sd = (SupportsDD)i2.next();
                    Iterator pd = sd.getPortletModes().iterator();
                    while (pd.hasNext()) {
                        if (!mode.equalsIgnoreCase((String)pd.next())) continue;
                        return true;
                    }
                }
            }
        }
        catch (PortletContainerException e) {
            LOG.error((Object)"Error determining mode support.", (Throwable)e);
        }
        LOG.info((Object)("Portlet mode '" + mode + "' not found for portletId: '" + portletId + "'"));
        return false;
    }

    public void destroy() throws DriverConfigurationException {
        LOG.debug((Object)"Destroying Supported Modes Service...");
        this.supportedPortletModesByPortal = null;
        this.portletRegistry = null;
        this.propertyService = null;
        LOG.debug((Object)"Supported Modes Service destroyed.");
    }

    public void init(ServletContext ctx) throws DriverConfigurationException {
        this.servletContext = ctx;
        this.loadPortalModes();
    }

    private void loadPortalModes() {
        LOG.debug((Object)"Loading supported portal modes...");
        Iterator modes = this.propertyService.getSupportedPortletModes().iterator();
        while (modes.hasNext()) {
            String mode = (String)modes.next();
            LOG.debug((Object)("Loading mode [" + mode + "]"));
            this.supportedPortletModesByPortal.add(new PortletMode(mode));
        }
        LOG.debug((Object)("Loaded [" + this.supportedPortletModesByPortal.size() + "] supported portal modes"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

