/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.spi.optional.P3PAttributes;
import org.apache.pluto.spi.optional.UserInfoAttributesService;

public class UserInfoAttributesServiceImpl
implements UserInfoAttributesService {
    private static UserInfoAttributesServiceImpl instance = new UserInfoAttributesServiceImpl();
    private static final String USER_INFO_ATTR_FILE = "/user-info-attributes.properties";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl == null ? (class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl = UserInfoAttributesServiceImpl.class$("org.apache.pluto.driver.services.impl.UserInfoAttributesServiceImpl")) : class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl));
    private static Properties props = new Properties();
    private static Map cache = new HashMap();
    static /* synthetic */ Class class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl;

    private UserInfoAttributesServiceImpl() {
    }

    public static UserInfoAttributesServiceImpl getInstance() throws IOException {
        UserInfoAttributesServiceImpl.loadProperties();
        return instance;
    }

    public static UserInfoAttributesServiceImpl getInstance(Properties inprops) throws IOException {
        props = inprops;
        return instance;
    }

    public Map getUserInfo(PortletRequest request) throws PortletContainerException {
        HashMap<String, String> map = null;
        String user = request.getRemoteUser();
        if (user == null) {
            return null;
        }
        map = (HashMap<String, String>)cache.get(user);
        if (map == null) {
            map = new HashMap<String, String>();
            int len = P3PAttributes.ATTRIBUTE_ARRAY.length;
            StringBuffer prefix = new StringBuffer();
            prefix.append(user);
            prefix.append('.');
            StringBuffer name = null;
            for (int i = 0; i < len; ++i) {
                name = new StringBuffer();
                name.append(prefix);
                String attr = P3PAttributes.ATTRIBUTE_ARRAY[i];
                name.append(attr);
                String prop = props.getProperty(name.toString());
                if (prop == null) continue;
                map.put(attr, prop);
            }
            cache.put(user, map);
        }
        return map;
    }

    public Map getUserInfo(PortletRequest request, PortletWindow window) throws PortletContainerException {
        return this.getUserInfo(request);
    }

    private static void loadProperties() throws IOException {
        if (((Hashtable)props).isEmpty()) {
            InputStream stream = (class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl == null ? (class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl = UserInfoAttributesServiceImpl.class$("org.apache.pluto.driver.services.impl.UserInfoAttributesServiceImpl")) : class$org$apache$pluto$driver$services$impl$UserInfoAttributesServiceImpl).getResourceAsStream(USER_INFO_ATTR_FILE);
            if (stream == null) {
                String msg = "The properties file '/user-info-attributes.properties' cannot be found. Please make sure this file exists and is in the classpath (i.e. WEB-INF/classes).";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            props.load(stream);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

