/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.config.impl;

import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.apache.pluto.driver.services.portal.SupportedModesService;
import org.apache.pluto.driver.services.portal.SupportedWindowStateService;
import org.apache.pluto.driver.url.PortalURLParser;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.spi.optional.PortletPreferencesService;

public class DriverConfigurationImpl
implements DriverConfiguration {
    private PortalURLParser portalUrlParser;
    private PropertyConfigService propertyService;
    private RenderConfigService renderService;
    private SupportedModesService supportedModesService;
    private SupportedWindowStateService supportedWindowStateService;
    private PortalCallbackService portalCallbackService;
    private PortletPreferencesService portletPreferencesService;

    public DriverConfigurationImpl(PortalURLParser portalUrlParser, PropertyConfigService propertyService, RenderConfigService renderService, SupportedModesService supportedModesService, SupportedWindowStateService supportedWindowStateService, PortalCallbackService portalCallback) {
        this.portalUrlParser = portalUrlParser;
        this.propertyService = propertyService;
        this.renderService = renderService;
        this.portalCallbackService = portalCallback;
        this.supportedModesService = supportedModesService;
        this.supportedWindowStateService = supportedWindowStateService;
    }

    public String getPortalName() {
        return this.propertyService.getPortalName();
    }

    public String getPortalVersion() {
        return this.propertyService.getPortalVersion();
    }

    public String getContainerName() {
        return this.propertyService.getContainerName();
    }

    public Collection getSupportedPortletModes() {
        return this.propertyService.getSupportedPortletModes();
    }

    public Collection getSupportedWindowStates() {
        return this.propertyService.getSupportedWindowStates();
    }

    public Collection getPages() {
        return this.renderService.getPages();
    }

    public PageConfig getPageConfig(String pageId) {
        return this.renderService.getPage(pageId);
    }

    public boolean isPortletModeSupportedByPortal(String mode) {
        return this.supportedModesService.isPortletModeSupportedByPortal(mode);
    }

    public boolean isPortletModeSupportedByPortlet(String portletId, String mode) {
        return this.supportedModesService.isPortletModeSupportedByPortlet(portletId, mode);
    }

    public boolean isPortletModeSupported(String portletId, String mode) {
        return this.supportedModesService.isPortletModeSupported(portletId, mode);
    }

    public void init(ServletContext context) {
        this.propertyService.init(context);
        this.renderService.init(context);
        this.supportedModesService.init(context);
        this.supportedWindowStateService.init(context);
    }

    public void destroy() {
        if (this.propertyService != null) {
            this.propertyService.destroy();
        }
        if (this.renderService != null) {
            this.renderService.destroy();
        }
        if (this.supportedModesService != null) {
            this.supportedModesService.destroy();
        }
        if (this.supportedWindowStateService != null) {
            this.supportedWindowStateService.destroy();
        }
    }

    public PortalURLParser getPortalUrlParser() {
        return this.portalUrlParser;
    }

    public void setPortalUrlParser(PortalURLParser portalUrlParser) {
        this.portalUrlParser = portalUrlParser;
    }

    public PortalCallbackService getPortalCallbackService() {
        return this.portalCallbackService;
    }

    public void setPortalCallbackService(PortalCallbackService portalCallbackService) {
        this.portalCallbackService = portalCallbackService;
    }

    public PortletPreferencesService getPortletPreferencesService() {
        return this.portletPreferencesService;
    }

    public void setPortletPreferencesService(PortletPreferencesService portletPreferencesService) {
        this.portletPreferencesService = portletPreferencesService;
    }

    public boolean isWindowStateSupported(String portletId, String windowState) {
        return this.supportedWindowStateService.isWindowStateSupported(portletId, windowState);
    }

    public boolean isWindowStateSupportedByPortal(String windowState) {
        return this.supportedWindowStateService.isWindowStateSupportedByPortal(windowState);
    }

    public boolean isWindowStateSupportedByPortlet(String portletId, String windowState) {
        return this.supportedWindowStateService.isWindowStateSupportedByPortlet(portletId, windowState);
    }

    public RenderConfigService getRenderConfigService() {
        return this.renderService;
    }
}

