/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.PortletWindowID;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.apache.pluto.spi.optional.PortletRegistryService;
import org.apache.pluto.spi.optional.RequestAttributeService;
import org.apache.pluto.spi.optional.UserInfoService;
import org.apache.pluto.util.NamespaceMapper;
import org.apache.pluto.util.impl.NamespaceMapperImpl;

public class DefaultRequestAttributeService
implements RequestAttributeService {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$core$DefaultRequestAttributeService == null ? (class$org$apache$pluto$core$DefaultRequestAttributeService = DefaultRequestAttributeService.class$("org.apache.pluto.core.DefaultRequestAttributeService")) : class$org$apache$pluto$core$DefaultRequestAttributeService));
    private final NamespaceMapper mapper = new NamespaceMapperImpl();
    private OptionalContainerServices optionalContainerServices;
    static /* synthetic */ Class class$org$apache$pluto$core$DefaultRequestAttributeService;

    public DefaultRequestAttributeService() {
    }

    public DefaultRequestAttributeService(OptionalContainerServices optionalContainerServices) {
        this.optionalContainerServices = optionalContainerServices;
    }

    public OptionalContainerServices getOptionalContainerServices() {
        return this.optionalContainerServices;
    }

    public void setOptionalContainerServices(OptionalContainerServices optionalContainerServices) {
        this.optionalContainerServices = optionalContainerServices;
    }

    public Object getAttribute(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow portletWindow, String name) {
        if ("javax.portlet.userinfo".equals(name)) {
            Map userInfo = (Map)httpServletRequest.getAttribute("javax.portlet.userinfo");
            if (userInfo == null) {
                userInfo = this.createUserInfoMap(portletRequest, portletWindow);
                httpServletRequest.setAttribute("javax.portlet.userinfo", (Object)userInfo);
            }
            return userInfo;
        }
        String encodedName = this.encodeAttributeName(portletWindow, name);
        Object attribute = httpServletRequest.getAttribute(encodedName);
        if (attribute != null) {
            return attribute;
        }
        return httpServletRequest.getAttribute(name);
    }

    public Enumeration getAttributeNames(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow portletWindow) {
        Enumeration attributes = httpServletRequest.getAttributeNames();
        Vector<String> portletAttributes = new Vector<String>();
        while (attributes.hasMoreElements()) {
            String portletAttribute;
            String attribute = (String)attributes.nextElement();
            if (this.isNameReserved(attribute)) {
                portletAttribute = attribute;
            } else {
                PortletWindowID portletWindowId = portletWindow.getId();
                portletAttribute = this.mapper.decode(portletWindowId, attribute);
            }
            if (portletAttribute == null) continue;
            portletAttributes.add(portletAttribute);
        }
        return portletAttributes.elements();
    }

    public void removeAttribute(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow portletWindow, String name) {
        String encodedName = this.encodeAttributeName(portletWindow, name);
        httpServletRequest.removeAttribute(encodedName);
    }

    public void setAttribute(PortletRequest portletRequest, HttpServletRequest httpServletRequest, PortletWindow portletWindow, String name, Object value) {
        String encodedName = this.encodeAttributeName(portletWindow, name);
        if (value == null) {
            httpServletRequest.removeAttribute(name);
        } else {
            httpServletRequest.setAttribute(encodedName, value);
        }
    }

    protected boolean isNameReserved(String name) {
        return name.startsWith("java.") || name.startsWith("javax.");
    }

    protected String encodeAttributeName(PortletWindow portletWindow, String name) {
        String encodedName;
        if (this.isNameReserved(name)) {
            encodedName = name;
        } else {
            PortletWindowID portletWindowId = portletWindow.getId();
            encodedName = this.mapper.encode(portletWindowId, name);
        }
        return encodedName;
    }

    protected Map createUserInfoMap(PortletRequest portletRequest, PortletWindow portletWindow) {
        HashMap userInfoMap = new HashMap();
        try {
            UserInfoService userInfoService = this.optionalContainerServices.getUserInfoService();
            Map allMap = userInfoService.getUserInfo(portletRequest, portletWindow);
            if (null == allMap) {
                return null;
            }
            PortletRegistryService portletRegistryService = this.optionalContainerServices.getPortletRegistryService();
            PortletAppDD dd = portletRegistryService.getPortletApplicationDescriptor(portletWindow.getContextPath());
            List mappedUserAttributes = dd.getUserAttributes();
            Iterator mappedAttrItr = mappedUserAttributes.iterator();
            while (mappedAttrItr.hasNext()) {
                UserAttributeDD userAttrDD = (UserAttributeDD)mappedAttrItr.next();
                String mappedName = userAttrDD.getName();
                Object value = allMap.get(mappedName);
                if (value == null) continue;
                userInfoMap.put(mappedName, value);
            }
        }
        catch (PortletContainerException e) {
            LOG.warn((Object)("Unable to retrieve user attribute map for user " + portletRequest.getRemoteUser() + ".  Returning null."));
            return null;
        }
        return Collections.unmodifiableMap(userInfoMap);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

