/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.util;

import java.util.List;
import org.apache.plc4x.java.s7.netty.model.params.CpuServicesRequestParameter;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.S7AnyVarParameterItem;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.CpuServicesPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.S7Payload;
import org.apache.plc4x.java.s7.netty.model.payloads.VarPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.payloads.ssls.SslDataRecord;
import org.apache.plc4x.java.s7.netty.model.types.VariableAddressingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7SizeHelper {
    private static final Logger logger = LoggerFactory.getLogger(S7SizeHelper.class);

    private S7SizeHelper() {
    }

    public static short getParametersLength(List<S7Parameter> parameters) {
        short l = 0;
        if (parameters != null) {
            for (S7Parameter parameter : parameters) {
                l = (short)(l + S7SizeHelper.getParameterLength(parameter));
            }
        }
        return l;
    }

    public static short getPayloadsLength(List<S7Payload> payloads) {
        short l = 0;
        if (payloads == null) {
            return 0;
        }
        for (S7Payload payload : payloads) {
            if (payload instanceof VarPayload) {
                VarPayload varPayload = (VarPayload)payload;
                for (VarPayloadItem payloadItem : varPayload.getItems()) {
                    l = (short)(l + S7SizeHelper.getPayloadLength(payloadItem));
                }
                continue;
            }
            if (!(payload instanceof CpuServicesPayload)) continue;
            CpuServicesPayload cpuServicesPayload = (CpuServicesPayload)payload;
            if (cpuServicesPayload.getSslDataRecords().isEmpty()) {
                return 8;
            }
            short length = 0;
            for (SslDataRecord sslDataRecord : cpuServicesPayload.getSslDataRecords()) {
                length = (short)(length + sslDataRecord.getLengthInWords() * 2);
            }
            return length;
        }
        return l;
    }

    public static short getParameterLength(S7Parameter parameter) {
        if (parameter == null) {
            return 0;
        }
        switch (parameter.getType()) {
            case READ_VAR: 
            case WRITE_VAR: {
                return S7SizeHelper.getReadWriteVarParameterLength((VarParameter)parameter);
            }
            case SETUP_COMMUNICATION: {
                return 8;
            }
            case CPU_SERVICES: {
                if (parameter instanceof CpuServicesRequestParameter) {
                    return 8;
                }
                return 12;
            }
        }
        logger.error("Not implemented");
        return 0;
    }

    public static short getReadWriteVarParameterLength(VarParameter parameter) {
        short length = 2;
        for (VarParameterItem varParameterItem : parameter.getItems()) {
            VariableAddressingMode addressMode = varParameterItem.getAddressingMode();
            if (addressMode == VariableAddressingMode.S7ANY) {
                length = (short)(length + 12);
                continue;
            }
            logger.error("Not implemented");
        }
        return length;
    }

    public static short getPayloadLength(VarParameterItem parameterItem) {
        if (parameterItem == null) {
            return 0;
        }
        if (parameterItem instanceof S7AnyVarParameterItem) {
            S7AnyVarParameterItem anyVarParameterItem = (S7AnyVarParameterItem)parameterItem;
            return (short)(4 + anyVarParameterItem.getNumElements() * anyVarParameterItem.getDataType().getSizeInBytes());
        }
        logger.error("Not implemented");
        return 0;
    }

    public static short getPayloadLength(VarPayloadItem payloadItem) {
        if (payloadItem == null) {
            return 0;
        }
        return (short)(4 + payloadItem.getData().length);
    }
}

