/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.util;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.s7.netty.model.messages.S7RequestMessage;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.S7AnyVarParameterItem;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.types.TransportSize;

public class S7ResponseSizeEstimator {
    private S7ResponseSizeEstimator() {
    }

    public static short getEstimatedResponseMessageSize(S7RequestMessage requestMessage) {
        short size = 12;
        size = (short)(size + S7ResponseSizeEstimator.getEstimatedResponseParametersSize(requestMessage.getParameters()));
        size = (short)(size + S7ResponseSizeEstimator.getEstimatedResponsePayloadsSize(requestMessage.getParameters()));
        return size;
    }

    public static short getEstimatedResponseReadItemTotalSize(VarParameterItem varParameterItem, VarPayloadItem varPayloadItem) {
        if (varPayloadItem != null) {
            return S7ResponseSizeEstimator.getEstimatedResponseWriteVarPayloadItemSize(varParameterItem);
        }
        return S7ResponseSizeEstimator.getEstimatedResponseReadVarPayloadItemSize(varParameterItem);
    }

    private static short getEstimatedResponseParametersSize(List<S7Parameter> parameters) {
        short l = 0;
        if (parameters != null) {
            for (S7Parameter parameter : parameters) {
                l = (short)(l + S7ResponseSizeEstimator.getEstimatedResponseParameterSize(parameter));
            }
        }
        return l;
    }

    private static short getEstimatedResponseParameterSize(S7Parameter parameter) {
        switch (parameter.getType()) {
            case READ_VAR: 
            case WRITE_VAR: {
                return S7ResponseSizeEstimator.getEstimatedResponseReadWriteVarParameterSize((VarParameter)parameter);
            }
            case SETUP_COMMUNICATION: {
                return 8;
            }
        }
        throw new NotImplementedException("Not implemented");
    }

    private static short getEstimatedResponseReadWriteVarParameterSize(VarParameter varParameter) {
        return 2;
    }

    private static short getEstimatedResponsePayloadsSize(List<S7Parameter> parameters) {
        short l = 0;
        if (parameters != null) {
            for (S7Parameter parameter : parameters) {
                l = (short)(l + S7ResponseSizeEstimator.getEstimatedResponsePayloadSize(parameter));
            }
        }
        return l;
    }

    private static short getEstimatedResponsePayloadSize(S7Parameter parameter) {
        switch (parameter.getType()) {
            case READ_VAR: {
                return S7ResponseSizeEstimator.getEstimatedResponseReadVarPayloadSize((VarParameter)parameter);
            }
            case WRITE_VAR: {
                return S7ResponseSizeEstimator.getEstimatedResponseWriteVarPayloadSize((VarParameter)parameter);
            }
        }
        return 0;
    }

    private static short getEstimatedResponseReadVarPayloadSize(VarParameter varParameter) {
        short length = 0;
        for (VarParameterItem varParameterItem : varParameter.getItems()) {
            length = (short)(length + S7ResponseSizeEstimator.getEstimatedResponseReadVarPayloadItemSize(varParameterItem));
        }
        return length;
    }

    private static short getEstimatedResponseReadVarPayloadItemSize(VarParameterItem varParameterItem) {
        short length = 4;
        S7AnyVarParameterItem s7AnyVarParameterItem = (S7AnyVarParameterItem)varParameterItem;
        length = (short)(length + s7AnyVarParameterItem.getNumElements() * s7AnyVarParameterItem.getDataType().getSizeInBytes());
        if (s7AnyVarParameterItem.getDataType() == TransportSize.BOOL) {
            length = (short)(length + 1);
        }
        return length;
    }

    private static short getEstimatedResponseWriteVarPayloadSize(VarParameter varParameter) {
        short length = 0;
        for (VarParameterItem varParameterItem : varParameter.getItems()) {
            length = (short)(length + S7ResponseSizeEstimator.getEstimatedResponseWriteVarPayloadItemSize(varParameterItem));
        }
        return length;
    }

    private static short getEstimatedResponseWriteVarPayloadItemSize(VarParameterItem varParameterItem) {
        return 1;
    }
}

