/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.strategies;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.base.messages.PlcProtocolMessage;
import org.apache.plc4x.java.s7.netty.model.messages.S7RequestMessage;
import org.apache.plc4x.java.s7.netty.model.messages.S7ResponseMessage;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.S7AnyVarParameterItem;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.S7Payload;
import org.apache.plc4x.java.s7.netty.model.payloads.VarPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportErrorCode;
import org.apache.plc4x.java.s7.netty.model.types.MessageType;
import org.apache.plc4x.java.s7.netty.model.types.ParameterType;
import org.apache.plc4x.java.s7.netty.model.types.TransportSize;
import org.apache.plc4x.java.s7.netty.strategies.S7MessageProcessor;
import org.apache.plc4x.java.s7.netty.util.S7RequestSizeCalculator;
import org.apache.plc4x.java.s7.netty.util.S7ResponseSizeEstimator;

public class DefaultS7MessageProcessor
implements S7MessageProcessor {
    private AtomicInteger tpduRefGen = new AtomicInteger(1);

    @Override
    public Collection<S7RequestMessage> processRequest(S7RequestMessage request, int pduSize) throws PlcException {
        Optional<VarParameter> varParameterOptional = request.getParameter(VarParameter.class);
        if (varParameterOptional.isPresent()) {
            VarParameter varParameter = varParameterOptional.get();
            if (varParameter.getType() == ParameterType.READ_VAR) {
                return this.processReadVarParameter(request, varParameter, pduSize).getRequestMessages();
            }
            if (varParameter.getType() == ParameterType.WRITE_VAR) {
                return this.processWriteVarParameter(request, varParameter).getRequestMessages();
            }
        }
        return Collections.singletonList(request);
    }

    private S7CompositeRequestMessage processReadVarParameter(S7RequestMessage request, VarParameter varParameter, int pduSize) {
        short itemResponseSize;
        short itemRequestSize;
        int initialResponseSize;
        int initialRequestSize;
        S7CompositeRequestMessage compositeRequestMessage = new S7CompositeRequestMessage(request);
        VarParameter subVarParameter = new VarParameter(varParameter.getType(), new LinkedList<VarParameterItem>());
        S7RequestMessage subMessage = new S7RequestMessage(request.getMessageType(), (short)this.tpduRefGen.getAndIncrement(), Collections.singletonList(subVarParameter), Collections.emptyList(), compositeRequestMessage);
        compositeRequestMessage.addRequestMessage(subMessage);
        int curRequestSize = initialRequestSize = S7RequestSizeCalculator.getRequestMessageSize(subMessage);
        int curResponseSize = initialResponseSize = S7ResponseSizeEstimator.getEstimatedResponseMessageSize(subMessage);
        VarParameter preProcessedVarParameter = new VarParameter(varParameter.getType(), new LinkedList<VarParameterItem>());
        for (VarParameterItem varParameterItem : varParameter.getItems()) {
            itemRequestSize = S7RequestSizeCalculator.getRequestItemTotalSize(varParameterItem, null);
            itemResponseSize = S7ResponseSizeEstimator.getEstimatedResponseReadItemTotalSize(varParameterItem, null);
            if (initialRequestSize + itemRequestSize > pduSize || initialResponseSize + itemResponseSize > pduSize) {
                int maxResponseSize = pduSize - (initialResponseSize + 2 + 4);
                S7AnyVarParameterItem s7AnyVarParameterItem = (S7AnyVarParameterItem)varParameterItem;
                int maxNumElements = (int)Math.floor((double)maxResponseSize / (double)s7AnyVarParameterItem.getDataType().getSizeInBytes());
                int sizeMaxNumElementInBytes = maxNumElements * s7AnyVarParameterItem.getDataType().getSizeInBytes();
                int remainingNumElements = s7AnyVarParameterItem.getNumElements();
                int curByteOffset = s7AnyVarParameterItem.getByteOffset();
                while (remainingNumElements > 0) {
                    int numCurElements = Math.min(remainingNumElements, maxNumElements);
                    S7AnyVarParameterItem subVarParameterItem = new S7AnyVarParameterItem(s7AnyVarParameterItem.getSpecificationType(), s7AnyVarParameterItem.getMemoryArea(), s7AnyVarParameterItem.getDataType(), numCurElements, s7AnyVarParameterItem.getDataBlockNumber(), curByteOffset, 0);
                    preProcessedVarParameter.getItems().add(subVarParameterItem);
                    remainingNumElements -= maxNumElements;
                    curByteOffset += sizeMaxNumElementInBytes;
                }
                continue;
            }
            preProcessedVarParameter.getItems().add(varParameterItem);
        }
        for (VarParameterItem varParameterItem : preProcessedVarParameter.getItems()) {
            itemRequestSize = S7RequestSizeCalculator.getRequestItemTotalSize(varParameterItem, null);
            itemResponseSize = S7ResponseSizeEstimator.getEstimatedResponseReadItemTotalSize(varParameterItem, null);
            if (curRequestSize + itemRequestSize > pduSize || curResponseSize + itemResponseSize > pduSize) {
                subVarParameter = new VarParameter(varParameter.getType(), new LinkedList<VarParameterItem>());
                subMessage = new S7RequestMessage(request.getMessageType(), (short)this.tpduRefGen.getAndIncrement(), Collections.singletonList(subVarParameter), Collections.emptyList(), compositeRequestMessage);
                curRequestSize = S7RequestSizeCalculator.getRequestMessageSize(subMessage) + itemRequestSize;
                curResponseSize = S7ResponseSizeEstimator.getEstimatedResponseMessageSize(subMessage) + itemResponseSize;
                compositeRequestMessage.addRequestMessage(subMessage);
            } else {
                curRequestSize += itemRequestSize;
                curResponseSize += itemResponseSize;
            }
            subVarParameter.getItems().add(varParameterItem);
        }
        return compositeRequestMessage;
    }

    private S7CompositeRequestMessage processWriteVarParameter(S7RequestMessage request, VarParameter varParameter) throws PlcProtocolException {
        S7CompositeRequestMessage compositeRequestMessage = new S7CompositeRequestMessage(request);
        VarPayload varPayload = request.getPayload(VarPayload.class).orElseThrow(() -> new PlcProtocolException("Expecting payloads for a write request"));
        if (varParameter.getItems().size() != varPayload.getItems().size()) {
            throw new PlcProtocolException("Number of items in parameter and payload don't match");
        }
        List<VarParameterItem> parameterItems = varParameter.getItems();
        List<VarPayloadItem> payloadItems = varPayload.getItems();
        for (int i = 0; i < parameterItems.size(); ++i) {
            VarParameterItem varParameterItem = parameterItems.get(i);
            VarPayloadItem varPayloadItem = payloadItems.get(i);
            if (varParameterItem instanceof S7AnyVarParameterItem) {
                S7AnyVarParameterItem s7AnyVarParameterItem = (S7AnyVarParameterItem)varParameterItem;
                int byteOffset = s7AnyVarParameterItem.getByteOffset();
                if (s7AnyVarParameterItem.getDataType() == TransportSize.BOOL) {
                    this.processBooleanWriteVarParameter(request, varParameter, varPayload, s7AnyVarParameterItem, varPayloadItem, byteOffset, compositeRequestMessage);
                    continue;
                }
                this.processNonBooleanWriteVarParameter(request, varParameter, varPayload, s7AnyVarParameterItem, varPayloadItem, byteOffset, compositeRequestMessage);
                continue;
            }
            throw new NotImplementedException("Handling of other element types not implemented.");
        }
        return compositeRequestMessage;
    }

    private void processBooleanWriteVarParameter(S7RequestMessage request, VarParameter varParameter, VarPayload varPayload, S7AnyVarParameterItem s7AnyVarParameterItem, VarPayloadItem varPayloadItem, int byteOffset, S7CompositeRequestMessage compositeRequestMessage) {
        int curParameterByteOffset = byteOffset;
        byte curParameterBitOffset = s7AnyVarParameterItem.getBitOffset();
        int curPayloadBitOffset = 0;
        for (int i = 0; i < s7AnyVarParameterItem.getNumElements(); ++i) {
            S7AnyVarParameterItem item = new S7AnyVarParameterItem(s7AnyVarParameterItem.getSpecificationType(), s7AnyVarParameterItem.getMemoryArea(), s7AnyVarParameterItem.getDataType(), 1, s7AnyVarParameterItem.getDataBlockNumber(), curParameterByteOffset, curParameterBitOffset);
            VarParameter subVarParameter = new VarParameter(varParameter.getType(), Collections.singletonList(item));
            byte[] elementData = new byte[1];
            short curPayloadByteOffset = (short)((short)i / 8);
            elementData[0] = (byte)(varPayloadItem.getData()[curPayloadByteOffset] >> curPayloadBitOffset & 1);
            VarPayloadItem itemPayload = new VarPayloadItem(varPayloadItem.getReturnCode(), varPayloadItem.getDataTransportSize(), elementData);
            VarPayload subVarPayload = new VarPayload(varPayload.getType(), Collections.singletonList(itemPayload));
            S7RequestMessage subMessage = new S7RequestMessage(request.getMessageType(), (short)this.tpduRefGen.getAndIncrement(), Collections.singletonList(subVarParameter), Collections.singletonList(subVarPayload), compositeRequestMessage);
            compositeRequestMessage.addRequestMessage(subMessage);
            curParameterBitOffset = (byte)(curParameterBitOffset + 1);
            if (i > 0 && curParameterBitOffset % 8 == 0) {
                ++curParameterByteOffset;
                curParameterBitOffset = 0;
            }
            curPayloadBitOffset = (byte)(curPayloadBitOffset + 1);
            if (i <= 0 || curPayloadBitOffset % 8 != 0) continue;
            curPayloadBitOffset = 0;
        }
    }

    private void processNonBooleanWriteVarParameter(S7RequestMessage request, VarParameter varParameter, VarPayload varPayload, S7AnyVarParameterItem s7AnyVarParameterItem, VarPayloadItem varPayloadItem, int byteOffset, S7CompositeRequestMessage compositeRequestMessage) {
        int curByteOffset = byteOffset;
        int payloadPosition = 0;
        for (int i = 0; i < s7AnyVarParameterItem.getNumElements(); ++i) {
            int elementSize = s7AnyVarParameterItem.getDataType().getSizeInBytes();
            S7AnyVarParameterItem itemParameter = new S7AnyVarParameterItem(s7AnyVarParameterItem.getSpecificationType(), s7AnyVarParameterItem.getMemoryArea(), s7AnyVarParameterItem.getDataType(), 1, s7AnyVarParameterItem.getDataBlockNumber(), curByteOffset, 0);
            VarParameter subVarParameter = new VarParameter(varParameter.getType(), Collections.singletonList(itemParameter));
            byte[] elementData = new byte[elementSize];
            System.arraycopy(varPayloadItem.getData(), payloadPosition, elementData, 0, elementSize);
            payloadPosition += elementSize;
            VarPayloadItem itemPayload = new VarPayloadItem(varPayloadItem.getReturnCode(), varPayloadItem.getDataTransportSize(), elementData);
            VarPayload subVarPayload = new VarPayload(varPayload.getType(), Collections.singletonList(itemPayload));
            S7RequestMessage subMessage = new S7RequestMessage(request.getMessageType(), (short)this.tpduRefGen.getAndIncrement(), Collections.singletonList(subVarParameter), Collections.singletonList(subVarPayload), compositeRequestMessage);
            compositeRequestMessage.addRequestMessage(subMessage);
            curByteOffset += elementSize;
        }
    }

    @Override
    public S7ResponseMessage processResponse(S7RequestMessage request, S7ResponseMessage response) {
        if (request.getParent() instanceof S7CompositeRequestMessage) {
            S7CompositeRequestMessage parent = (S7CompositeRequestMessage)request.getParent();
            parent.addResponseMessage(response);
            if (parent.isAcknowledged()) {
                return this.getMergedResponseMessage(parent.originalRequest, parent.getResponseMessages());
            }
            return null;
        }
        return response;
    }

    private S7ResponseMessage getMergedResponseMessage(S7RequestMessage requestMessage, Collection<? extends S7ResponseMessage> responses) {
        MessageType messageType = null;
        short tpduReference = requestMessage.getTpduReference();
        LinkedList<S7Parameter> s7Parameters = new LinkedList<S7Parameter>();
        LinkedList<S7Payload> s7Payloads = new LinkedList<S7Payload>();
        Optional<VarParameter> varParameterOptional = requestMessage.getParameter(VarParameter.class);
        if (!varParameterOptional.isPresent()) {
            for (S7ResponseMessage s7ResponseMessage : responses) {
                messageType = s7ResponseMessage.getMessageType();
                s7Parameters.addAll(s7ResponseMessage.getParameters());
                s7Payloads.addAll(s7ResponseMessage.getPayloads());
            }
        } else {
            LinkedList<VarParameterItem> parameterItems = new LinkedList<VarParameterItem>();
            LinkedList linkedList = new LinkedList();
            for (S7ResponseMessage s7ResponseMessage : responses) {
                messageType = s7ResponseMessage.getMessageType();
                parameterItems.addAll(s7ResponseMessage.getParameter(VarParameter.class).orElseThrow(() -> new PlcRuntimeException("Every response of a Read message should have a VarParameter instance")).getItems());
                Optional<VarPayload> payload = s7ResponseMessage.getPayload(VarPayload.class);
                payload.ifPresent(varPayload -> payloadItems.addAll(varPayload.getItems()));
            }
            LinkedList<VarParameterItem> mergedParameterItems = new LinkedList<VarParameterItem>();
            LinkedList<VarPayloadItem> linkedList2 = new LinkedList<VarPayloadItem>();
            VarParameter varParameter = varParameterOptional.get();
            int responseOffset = 0;
            for (int i = 0; i < varParameter.getItems().size(); ++i) {
                S7AnyVarParameterItem requestItem = (S7AnyVarParameterItem)varParameter.getItems().get(i);
                S7AnyVarParameterItem responseParameterItem = (S7AnyVarParameterItem)parameterItems.get(0);
                VarPayloadItem responsePayloadItem = (VarPayloadItem)linkedList.get(i + responseOffset);
                int dataOffset = responsePayloadItem.getData() != null ? responsePayloadItem.getData().length : 0;
                mergedParameterItems.add(requestItem);
                if (requestItem.getNumElements() != responseParameterItem.getNumElements()) {
                    int itemSizeInBytes = requestItem.getDataType().getSizeInBytes();
                    int totalSizeInBytes = requestItem.getNumElements() * itemSizeInBytes;
                    if (varParameter.getType() != ParameterType.READ_VAR) continue;
                    byte[] data = new byte[totalSizeInBytes];
                    System.arraycopy(responsePayloadItem.getData(), 0, data, 0, responsePayloadItem.getData().length);
                    while (dataOffset < totalSizeInBytes) {
                        responsePayloadItem = (VarPayloadItem)linkedList.get(i + ++responseOffset);
                        if (varParameter.getType() != ParameterType.READ_VAR) continue;
                        System.arraycopy(responsePayloadItem.getData(), 0, data, dataOffset, responsePayloadItem.getData().length);
                        dataOffset += responsePayloadItem.getData().length;
                    }
                    linkedList2.add(new VarPayloadItem(DataTransportErrorCode.OK, responsePayloadItem.getDataTransportSize(), data));
                    continue;
                }
                linkedList2.add(responsePayloadItem);
            }
            s7Parameters.add(new VarParameter(varParameter.getType(), mergedParameterItems));
            s7Payloads.add(new VarPayload(varParameter.getType(), linkedList2));
        }
        return new S7ResponseMessage(messageType, tpduReference, s7Parameters, s7Payloads, -1, -1);
    }

    static class S7CompositeRequestMessage
    implements PlcProtocolMessage {
        private S7RequestMessage originalRequest;
        private List<S7RequestMessage> requestMessages;
        private List<S7ResponseMessage> responseMessages;

        S7CompositeRequestMessage(S7RequestMessage originalRequest) {
            this.originalRequest = originalRequest;
            this.requestMessages = new LinkedList<S7RequestMessage>();
            this.responseMessages = new LinkedList<S7ResponseMessage>();
        }

        public PlcProtocolMessage getParent() {
            return this.originalRequest;
        }

        private boolean isAcknowledged() {
            for (S7RequestMessage requestMessage : this.requestMessages) {
                if (requestMessage.isAcknowledged()) continue;
                return false;
            }
            return true;
        }

        void addRequestMessage(S7RequestMessage requestMessage) {
            this.requestMessages.add(requestMessage);
        }

        public List<S7RequestMessage> getRequestMessages() {
            return this.requestMessages;
        }

        private void addResponseMessage(S7ResponseMessage responseMessage) {
            this.responseMessages.add(responseMessage);
        }

        public List<S7ResponseMessage> getResponseMessages() {
            return this.responseMessages;
        }
    }
}

