/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.types;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SslId {
    MODULE_IDENTIFICATION(17),
    CPU_CHARACTERISTICS(18),
    USER_MEMORY_AREAS(19),
    SYSTEM_AREAS(20),
    BLOCK_TYPES(21),
    INTERRUPT_STATUS(34),
    ASSIGNMENT_BETWEEN_PROCESS_IMAGE_PARTITIONS_AND_OBS(37),
    COMPUTATION_STATUS_DATA(50),
    H_CPU_GROUP_INFORMATION(113),
    STATUS_OF_THE_MODULE_LEDS(116),
    SWITCHED_DP_SLAVES_IN_THE_H_SYSTEM(117),
    MODULE_STATUS_INFORMATION(145),
    RACK_STATION_STATUS_INFORMATION_1(146),
    RACK_STATION_STATUS_INFORMATION_2(148),
    EXTENDED_DP_MASTER_SYSTEM_PROFINET_IO_SYSTEM_INFORMATION(149),
    MODULE_STATUS_INFORMATION_PROFINET_IO_AND_PROFINET_DP(150),
    MODULE_STATUS_INFORMATION_PROFINET_IO(156),
    DIAGNOSTIC_BUFFER_OF_THE_CPU(160),
    MODULE_DIAGNOSTIC_INFORMATION_DATA_RECORD_0(177),
    MODULE_DIAGNOSTIC_INFORMATION_DATA_RECORD_1_GEOGRAPHICAL_ADDRESS(178),
    MODULE_DIAGNOSTIC_INFORMATION_DATA_RECORD_1_LOGICAL_ADDRESS(179),
    DIAGNOSTIC_DATA_OF_A_DP_SLAVE(180),
    IDENTIFICATION_OF_ALL_COMPONENTS(28),
    INFORMATION_ABOUT_COMMUNICATION_UNIT(305),
    CURRENT_MODE_TRANSITION(1060);

    private static final Logger logger;
    private static final Map<Short, SslId> map;
    private final short code;

    private SslId(short code) {
        this.code = code;
    }

    public short getCode() {
        return this.code;
    }

    public static SslId valueOf(short code) {
        if (!map.containsKey(code)) {
            logger.error("SslId for code {} not found", (Object)code);
        }
        return map.get(code);
    }

    static {
        logger = LoggerFactory.getLogger(SslId.class);
        map = new HashMap<Short, SslId>();
        for (SslId sslId : SslId.values()) {
            map.put(sslId.code, sslId);
        }
    }
}

