/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.PendingWriteQueue;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolPayloadTooBigException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.base.messages.PlcProtocolMessage;
import org.apache.plc4x.java.isotp.protocol.IsoTPProtocol;
import org.apache.plc4x.java.isotp.protocol.events.IsoTPConnectedEvent;
import org.apache.plc4x.java.isotp.protocol.model.IsoTPMessage;
import org.apache.plc4x.java.isotp.protocol.model.tpdus.DataTpdu;
import org.apache.plc4x.java.s7.netty.events.S7ConnectedEvent;
import org.apache.plc4x.java.s7.netty.model.messages.S7Message;
import org.apache.plc4x.java.s7.netty.model.messages.S7RequestMessage;
import org.apache.plc4x.java.s7.netty.model.messages.S7ResponseMessage;
import org.apache.plc4x.java.s7.netty.model.messages.SetupCommunicationRequestMessage;
import org.apache.plc4x.java.s7.netty.model.params.CpuServicesParameter;
import org.apache.plc4x.java.s7.netty.model.params.CpuServicesRequestParameter;
import org.apache.plc4x.java.s7.netty.model.params.CpuServicesResponseParameter;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.params.SetupCommunicationParameter;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.S7AnyVarParameterItem;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.CpuServicesPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.S7Payload;
import org.apache.plc4x.java.s7.netty.model.payloads.VarPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.payloads.ssls.SslDataRecord;
import org.apache.plc4x.java.s7.netty.model.payloads.ssls.SslModuleIdentificationDataRecord;
import org.apache.plc4x.java.s7.netty.model.types.CpuServicesParameterFunctionGroup;
import org.apache.plc4x.java.s7.netty.model.types.CpuServicesParameterSubFunctionGroup;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportErrorCode;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportSize;
import org.apache.plc4x.java.s7.netty.model.types.MemoryArea;
import org.apache.plc4x.java.s7.netty.model.types.MessageType;
import org.apache.plc4x.java.s7.netty.model.types.ParameterError;
import org.apache.plc4x.java.s7.netty.model.types.ParameterType;
import org.apache.plc4x.java.s7.netty.model.types.SpecificationType;
import org.apache.plc4x.java.s7.netty.model.types.SslId;
import org.apache.plc4x.java.s7.netty.model.types.TransportSize;
import org.apache.plc4x.java.s7.netty.model.types.VariableAddressingMode;
import org.apache.plc4x.java.s7.netty.strategies.S7MessageProcessor;
import org.apache.plc4x.java.s7.netty.util.S7SizeHelper;
import org.apache.plc4x.java.s7.types.S7ControllerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7Protocol
extends ChannelDuplexHandler {
    private static final byte S7_PROTOCOL_MAGIC_NUMBER = 50;
    private static final Logger logger = LoggerFactory.getLogger(S7Protocol.class);
    private final MessageToMessageDecoder<Object> decoder = new MessageToMessageDecoder<Object>(){

        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof IsoTPMessage;
        }

        protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
            S7Protocol.this.decode(ctx, (IsoTPMessage)msg, out);
        }
    };
    private short maxAmqCaller;
    private short maxAmqCallee;
    private short pduSize;
    private S7ControllerType controllerType;
    private ChannelHandler prevChannelHandler;
    private S7MessageProcessor messageProcessor;
    private PendingWriteQueue queue;
    private Map<Short, DataTpdu> sentButUnacknowledgedTpdus;

    public S7Protocol(short requestedMaxAmqCaller, short requestedMaxAmqCallee, short requestedPduSize, S7ControllerType controllerType, S7MessageProcessor messageProcessor) {
        this.maxAmqCaller = requestedMaxAmqCaller;
        this.maxAmqCallee = requestedMaxAmqCallee;
        this.pduSize = requestedPduSize;
        this.controllerType = controllerType;
        this.messageProcessor = messageProcessor;
        this.sentButUnacknowledgedTpdus = new HashMap<Short, DataTpdu>();
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.queue = new PendingWriteQueue(ctx);
        try {
            Field prevField = FieldUtils.getField(ctx.getClass(), (String)"prev", (boolean)true);
            if (prevField != null) {
                ChannelHandlerContext prevContext = (ChannelHandlerContext)prevField.get(ctx);
                this.prevChannelHandler = prevContext.handler();
            }
        }
        catch (Exception e) {
            logger.error("Error accessing field 'prev'", (Throwable)e);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.queue.removeAndWriteAll();
        super.channelUnregistered(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.queue.removeAndWriteAll();
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (this.prevChannelHandler instanceof IsoTPProtocol && evt instanceof IsoTPConnectedEvent) {
            SetupCommunicationRequestMessage setupCommunicationRequest = new SetupCommunicationRequestMessage(0, this.maxAmqCaller, this.maxAmqCallee, this.pduSize, null);
            ctx.channel().writeAndFlush((Object)setupCommunicationRequest);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof S7Message) {
                S7Message in = (S7Message)((Object)msg);
                Collection<S7Message> messages = this.messageProcessor != null && in instanceof S7RequestMessage ? this.messageProcessor.processRequest((S7RequestMessage)in, this.pduSize) : Collections.singleton(in);
                PromiseCombiner promiseCombiner = new PromiseCombiner();
                for (S7Message message : messages) {
                    ByteBuf buf = Unpooled.buffer();
                    this.writeS7Message(promise.channel(), promiseCombiner, message, buf);
                }
                promiseCombiner.finish((Promise)promise);
                this.trySendingMessages(ctx);
            } else {
                ctx.write(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
    }

    private void writeS7Message(Channel channel, PromiseCombiner promiseCombiner, S7Message message, ByteBuf buf) throws PlcProtocolException {
        this.encodeHeader(message, buf);
        this.encodeParameters(message, buf);
        this.encodePayloads(message, buf);
        if (buf.writerIndex() > this.pduSize) {
            throw new PlcProtocolPayloadTooBigException("s7", (int)this.pduSize, buf.writerIndex(), (Object)message);
        }
        DefaultChannelPromise subPromise = new DefaultChannelPromise(channel);
        this.queue.add((Object)new DataTpdu(true, 0, Collections.emptyList(), buf, (PlcProtocolMessage)message), (ChannelPromise)subPromise);
        promiseCombiner.add((Future)subPromise);
        logger.debug("S7 Message with id {}\u00a0queued", (Object)message.getTpduReference());
    }

    private void encodePayloads(S7Message in, ByteBuf buf) throws PlcProtocolException {
        if (in.getPayloads() != null) {
            Iterator<S7Payload> payloadIterator = in.getPayloads().iterator();
            block4: while (payloadIterator.hasNext()) {
                S7Payload payload = payloadIterator.next();
                switch (payload.getType()) {
                    case WRITE_VAR: {
                        this.encodeWriteVarPayload((VarPayload)payload, buf, !payloadIterator.hasNext());
                        continue block4;
                    }
                    case CPU_SERVICES: {
                        this.encodeCpuServicesPayload((CpuServicesPayload)payload, buf);
                        continue block4;
                    }
                }
                throw new PlcProtocolException("Writing payloads of type " + payload.getType().name() + " not implemented.");
            }
        }
    }

    private void encodeWriteVarPayload(VarPayload varPayload, ByteBuf buf, boolean lastItem) {
        for (VarPayloadItem payloadItem : varPayload.getItems()) {
            buf.writeByte((int)payloadItem.getReturnCode().getCode());
            buf.writeByte((int)payloadItem.getDataTransportSize().getCode());
            buf.writeShort(payloadItem.getData().length);
            buf.writeBytes(payloadItem.getData());
            if (payloadItem.getData().length != 1 || lastItem) continue;
            buf.writeByte(0);
        }
    }

    private void encodeCpuServicesPayload(CpuServicesPayload cpuServicesPayload, ByteBuf buf) throws PlcProtocolException {
        buf.writeByte((int)cpuServicesPayload.getReturnCode().getCode());
        buf.writeByte((int)DataTransportSize.OCTET_STRING.getCode());
        if (!cpuServicesPayload.getSslDataRecords().isEmpty()) {
            throw new PlcProtocolException("Unexpected SZL Data Records");
        }
        buf.writeShort(4);
        buf.writeShort((int)cpuServicesPayload.getSslId().getCode());
        buf.writeShort((int)cpuServicesPayload.getSslIndex());
    }

    private void encodeParameters(S7Message in, ByteBuf buf) throws PlcProtocolException {
        block5: for (S7Parameter s7Parameter : in.getParameters()) {
            buf.writeByte((int)s7Parameter.getType().getCode());
            switch (s7Parameter.getType()) {
                case WRITE_VAR: 
                case READ_VAR: {
                    this.encodeParameterReadWriteVar(buf, (VarParameter)s7Parameter);
                    continue block5;
                }
                case SETUP_COMMUNICATION: {
                    this.encodeParameterSetupCommunication(buf, (SetupCommunicationParameter)s7Parameter);
                    continue block5;
                }
                case CPU_SERVICES: {
                    this.encodeCpuServicesParameter(buf, (CpuServicesParameter)s7Parameter);
                    continue block5;
                }
            }
            throw new PlcProtocolException("Writing parameters of type " + s7Parameter.getType().name() + " not implemented.");
        }
    }

    private void encodeHeader(S7Message in, ByteBuf buf) {
        buf.writeByte(50);
        buf.writeByte((int)in.getMessageType().getCode());
        buf.writeShort(0);
        buf.writeShort((int)in.getTpduReference());
        buf.writeShort((int)S7SizeHelper.getParametersLength(in.getParameters()));
        buf.writeShort((int)S7SizeHelper.getPayloadsLength(in.getPayloads()));
    }

    private void encodeParameterSetupCommunication(ByteBuf buf, SetupCommunicationParameter s7Parameter) {
        buf.writeByte(0);
        buf.writeShort((int)s7Parameter.getMaxAmqCaller());
        buf.writeShort((int)s7Parameter.getMaxAmqCallee());
        buf.writeShort((int)s7Parameter.getPduLength());
    }

    private void encodeParameterReadWriteVar(ByteBuf buf, VarParameter s7Parameter) throws PlcProtocolException {
        List<VarParameterItem> items = s7Parameter.getItems();
        buf.writeByte((int)((byte)items.size()));
        for (VarParameterItem item : items) {
            VariableAddressingMode addressMode = item.getAddressingMode();
            if (addressMode == VariableAddressingMode.S7ANY) {
                this.encodeS7AnyParameterItem(buf, (S7AnyVarParameterItem)item);
                continue;
            }
            throw new PlcProtocolException("Writing VarParameterItems with addressing mode " + addressMode.name() + " not implemented");
        }
    }

    private void encodeCpuServicesParameter(ByteBuf buf, CpuServicesParameter parameter) {
        buf.writeByte(1);
        buf.writeByte(18);
        buf.writeByte(parameter instanceof CpuServicesRequestParameter ? 4 : 8);
        buf.writeByte(parameter instanceof CpuServicesRequestParameter ? 17 : 18);
        byte nextByte = (byte)((parameter instanceof CpuServicesRequestParameter ? 64 : -128) | parameter.getFunctionGroup().getCode());
        buf.writeByte((int)nextByte);
        buf.writeByte((int)parameter.getSubFunctionGroup().getCode());
        buf.writeByte((int)parameter.getSequenceNumber());
    }

    private void encodeS7AnyParameterItem(ByteBuf buf, S7AnyVarParameterItem s7AnyRequestItem) {
        buf.writeByte((int)s7AnyRequestItem.getSpecificationType().getCode());
        buf.writeByte(10);
        buf.writeByte((int)s7AnyRequestItem.getAddressingMode().getCode());
        buf.writeByte((int)s7AnyRequestItem.getDataType().getTypeCode());
        buf.writeShort(s7AnyRequestItem.getNumElements());
        buf.writeShort(s7AnyRequestItem.getDataBlockNumber());
        buf.writeByte((int)s7AnyRequestItem.getMemoryArea().getCode());
        buf.writeShort((int)((short)(s7AnyRequestItem.getByteOffset() >> 5)));
        buf.writeByte((int)((byte)((s7AnyRequestItem.getByteOffset() & 0x1F) << 3 | s7AnyRequestItem.getBitOffset() & 7)));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.decoder.channelRead(ctx, msg);
        super.channelRead(ctx, msg);
    }

    protected void decode(ChannelHandlerContext ctx, IsoTPMessage in, List<Object> out) {
        S7Parameter parameter;
        ByteBuf userData;
        if (logger.isTraceEnabled()) {
            logger.trace("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in.getUserData()));
        }
        if ((userData = in.getUserData()).readableBytes() == 0) {
            return;
        }
        if (userData.readByte() != 50) {
            logger.warn("Expecting S7 protocol magic number.");
            if (logger.isDebugEnabled()) {
                logger.debug("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)userData));
            }
            return;
        }
        MessageType messageType = MessageType.valueOf(userData.readByte());
        boolean isResponse = messageType == MessageType.ACK_DATA;
        userData.readShort();
        short tpduReference = userData.readShort();
        int headerParametersLength = userData.readShort();
        short userDataLength = userData.readShort();
        byte errorClass = 0;
        byte errorCode = 0;
        if (isResponse) {
            errorClass = userData.readByte();
            errorCode = userData.readByte();
        }
        LinkedList<S7Parameter> s7Parameters = new LinkedList<S7Parameter>();
        for (int i = 0; i < headerParametersLength; i += S7SizeHelper.getParameterLength(parameter)) {
            parameter = this.decodeParameter(userData, isResponse);
            s7Parameters.add(parameter);
            if (!(parameter instanceof SetupCommunicationParameter)) continue;
            this.handleSetupCommunications(ctx, (SetupCommunicationParameter)parameter);
        }
        List<S7Payload> s7Payloads = this.decodePayloads(userData, isResponse, userDataLength, s7Parameters);
        logger.debug("S7 Message with id {}\u00a0received", (Object)tpduReference);
        if (isResponse) {
            S7RequestMessage requestMessage;
            S7ResponseMessage responseMessage = new S7ResponseMessage(messageType, tpduReference, s7Parameters, s7Payloads, errorClass, errorCode);
            DataTpdu requestTpdu = this.sentButUnacknowledgedTpdus.remove(tpduReference);
            S7RequestMessage s7RequestMessage = requestMessage = requestTpdu != null ? (S7RequestMessage)requestTpdu.getParent() : null;
            if (requestMessage != null) {
                requestMessage.setAcknowledged(true);
                if (this.messageProcessor != null) {
                    try {
                        responseMessage = this.messageProcessor.processResponse(requestMessage, responseMessage);
                    }
                    catch (Exception e) {
                        logger.error("Error processing message", (Throwable)e);
                        ctx.fireExceptionCaught((Throwable)e);
                        return;
                    }
                }
                if (responseMessage != null) {
                    out.add((Object)responseMessage);
                    if (responseMessage.getMessageType() == MessageType.USER_DATA) {
                        for (S7Payload payload : responseMessage.getPayloads()) {
                            if (!(payload instanceof CpuServicesPayload)) continue;
                            this.handleIdentifyRemote(ctx, (CpuServicesPayload)payload);
                        }
                    }
                }
                this.trySendingMessages(ctx);
            }
        } else {
            for (S7Parameter s7Parameter : s7Parameters) {
                if (!(s7Parameter instanceof CpuServicesResponseParameter)) continue;
                for (S7Payload s7Payload : s7Payloads) {
                    if (!(s7Payload instanceof CpuServicesPayload)) continue;
                    CpuServicesPayload cpuServicesPayload = (CpuServicesPayload)s7Payload;
                    this.handleIdentifyRemote(ctx, cpuServicesPayload);
                }
            }
            out.add((Object)new S7RequestMessage(messageType, tpduReference, s7Parameters, s7Payloads, null));
        }
    }

    private void handleSetupCommunications(ChannelHandlerContext ctx, SetupCommunicationParameter setupCommunicationParameter) {
        this.maxAmqCaller = setupCommunicationParameter.getMaxAmqCaller();
        this.maxAmqCallee = setupCommunicationParameter.getMaxAmqCallee();
        this.pduSize = setupCommunicationParameter.getPduLength();
        logger.info("S7Connection established pdu-size {}, max-amq-caller {}, max-amq-callee {}", new Object[]{this.pduSize, this.maxAmqCaller, this.maxAmqCallee});
        if (this.controllerType == S7ControllerType.ANY) {
            S7RequestMessage identifyRemoteMessage = new S7RequestMessage(MessageType.USER_DATA, 2, Collections.singletonList(new CpuServicesRequestParameter(CpuServicesParameterFunctionGroup.CPU_FUNCTIONS, CpuServicesParameterSubFunctionGroup.READ_SSL, 0)), Collections.singletonList(new CpuServicesPayload(DataTransportErrorCode.OK, SslId.MODULE_IDENTIFICATION, 0)), null);
            ctx.channel().writeAndFlush((Object)identifyRemoteMessage);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Successfully connected to S7: %s", this.controllerType.name()));
                logger.info(String.format("- max amq caller: %s", this.maxAmqCaller));
                logger.info(String.format("- max amq callee: %s", this.maxAmqCallee));
                logger.info(String.format("- pdu size: %s", this.pduSize));
            }
            ctx.channel().pipeline().fireUserEventTriggered((Object)new S7ConnectedEvent());
        }
    }

    private void handleIdentifyRemote(ChannelHandlerContext ctx, CpuServicesPayload cpuServicesPayload) {
        this.controllerType = S7ControllerType.ANY;
        for (SslDataRecord sslDataRecord : cpuServicesPayload.getSslDataRecords()) {
            SslModuleIdentificationDataRecord sslModuleIdentificationDataRecord;
            if (!(sslDataRecord instanceof SslModuleIdentificationDataRecord) || (sslModuleIdentificationDataRecord = (SslModuleIdentificationDataRecord)sslDataRecord).getIndex() != 1) continue;
            this.controllerType = this.lookupControllerType(sslModuleIdentificationDataRecord.getArticleNumber());
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Successfully connected to S7: %s", this.controllerType.name()));
            logger.info(String.format("- max amq caller: %s", this.maxAmqCaller));
            logger.info(String.format("- max amq callee: %s", this.maxAmqCallee));
            logger.info(String.format("- pdu size: %s", this.pduSize));
        }
        ctx.channel().pipeline().fireUserEventTriggered((Object)new S7ConnectedEvent());
    }

    private List<S7Payload> decodePayloads(ByteBuf userData, boolean isResponse, short userDataLength, List<S7Parameter> s7Parameters) {
        LinkedList<S7Payload> s7Payloads = new LinkedList<S7Payload>();
        for (S7Parameter s7Parameter : s7Parameters) {
            if (s7Parameter instanceof VarParameter) {
                VarParameter readWriteVarParameter = (VarParameter)s7Parameter;
                VarPayload varPayload = this.decodeVarPayload(userData, isResponse, userDataLength, readWriteVarParameter);
                s7Payloads.add(varPayload);
                continue;
            }
            if (!(s7Parameter instanceof CpuServicesParameter)) continue;
            CpuServicesPayload cpuServicesPayload = this.decodeCpuServicesPayload(userData);
            s7Payloads.add(cpuServicesPayload);
        }
        return s7Payloads;
    }

    private VarPayload decodeVarPayload(ByteBuf userData, boolean isResponse, short userDataLength, VarParameter readWriteVarParameter) {
        LinkedList<VarPayloadItem> payloadItems = new LinkedList<VarPayloadItem>();
        int i = 0;
        while (i < userDataLength) {
            DataTransportErrorCode dataTransportErrorCode = DataTransportErrorCode.valueOf(userData.readByte());
            if (readWriteVarParameter.getType() == ParameterType.WRITE_VAR && isResponse) {
                VarPayloadItem payload = new VarPayloadItem(dataTransportErrorCode, null, null);
                payloadItems.add(payload);
                ++i;
                continue;
            }
            if (readWriteVarParameter.getType() != ParameterType.READ_VAR || !isResponse) continue;
            DataTransportSize dataTransportSize = DataTransportSize.valueOf(userData.readByte());
            short length = dataTransportSize.isSizeInBits() ? (short)Math.ceil((double)userData.readShort() / 8.0) : userData.readShort();
            byte[] data = new byte[length];
            userData.readBytes(data);
            VarPayloadItem payload = new VarPayloadItem(dataTransportErrorCode, dataTransportSize, data);
            payloadItems.add(payload);
            i += S7SizeHelper.getPayloadLength(payload);
            if (length % 2 != 1 || userData.readableBytes() <= 0) continue;
            userData.readByte();
            ++i;
        }
        return new VarPayload(readWriteVarParameter.getType(), payloadItems);
    }

    private CpuServicesPayload decodeCpuServicesPayload(ByteBuf userData) {
        DataTransportErrorCode returnCode = DataTransportErrorCode.valueOf(userData.readByte());
        DataTransportSize dataTransportSize = DataTransportSize.valueOf(userData.readByte());
        if (dataTransportSize != DataTransportSize.OCTET_STRING) {
            // empty if block
        }
        short length = userData.readShort();
        SslId sslId = SslId.valueOf(userData.readShort());
        short sslIndex = userData.readShort();
        if (length == 4) {
            return new CpuServicesPayload(returnCode, sslId, sslIndex);
        }
        if (length >= 8) {
            userData.skipBytes(2);
            int partialListCount = userData.readShort();
            LinkedList<SslDataRecord> sslDataRecords = new LinkedList<SslDataRecord>();
            for (int i = 0; i < partialListCount; ++i) {
                short index = userData.readShort();
                byte[] articleNumberBytes = new byte[20];
                userData.readBytes(articleNumberBytes);
                String articleNumber = new String(articleNumberBytes, StandardCharsets.UTF_8).trim();
                short bgType = userData.readShort();
                short moduleOrOsVersion = userData.readShort();
                short pgDescriptionFileVersion = userData.readShort();
                sslDataRecords.add(new SslModuleIdentificationDataRecord(index, articleNumber, bgType, moduleOrOsVersion, pgDescriptionFileVersion));
            }
            return new CpuServicesPayload(returnCode, sslId, sslIndex, sslDataRecords);
        }
        return null;
    }

    private S7Parameter decodeParameter(ByteBuf in, boolean isResponse) {
        ParameterType parameterType = ParameterType.valueOf(in.readByte());
        if (parameterType == null) {
            logger.error("Could not find parameter type");
            return null;
        }
        switch (parameterType) {
            case CPU_SERVICES: {
                return this.decodeCpuServicesParameter(in);
            }
            case WRITE_VAR: 
            case READ_VAR: {
                byte numItems = in.readByte();
                List<VarParameterItem> varParameterItems = !isResponse ? this.decodeReadWriteVarParameter(in, numItems) : Collections.singletonList(new S7AnyVarParameterItem(null, null, null, numItems, 0, 0, 0));
                return new VarParameter(parameterType, varParameterItems);
            }
            case SETUP_COMMUNICATION: {
                in.readByte();
                short callingMaxAmq = in.readShort();
                short calledMaxAmq = in.readShort();
                short pduLength = in.readShort();
                return new SetupCommunicationParameter(callingMaxAmq, calledMaxAmq, pduLength);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error("Unimplemented parameter type: {}", (Object)parameterType.name());
        }
        return null;
    }

    private CpuServicesParameter decodeCpuServicesParameter(ByteBuf in) {
        if (in.readShort() != 274) {
            if (logger.isErrorEnabled()) {
                logger.error("Expecting 0x0112 for CPU_SERVICES parameter");
            }
            return null;
        }
        byte parameterLength = in.readByte();
        if (parameterLength != 4 && parameterLength != 8) {
            if (logger.isErrorEnabled()) {
                logger.error("Parameter length should be 4 or 8, but was {}", (Object)parameterLength);
            }
            return null;
        }
        in.readByte();
        byte typeAndFunctionGroup = in.readByte();
        boolean requestParameter = (typeAndFunctionGroup & 0x64) != 0;
        typeAndFunctionGroup = (byte)(typeAndFunctionGroup & 0xF);
        CpuServicesParameterFunctionGroup functionGroup = CpuServicesParameterFunctionGroup.valueOf(typeAndFunctionGroup);
        CpuServicesParameterSubFunctionGroup subFunctionGroup = CpuServicesParameterSubFunctionGroup.valueOf(in.readByte());
        byte sequenceNumber = in.readByte();
        if (!requestParameter) {
            return new CpuServicesRequestParameter(functionGroup, subFunctionGroup, sequenceNumber);
        }
        byte dataUnitReferenceNumber = in.readByte();
        boolean lastDataUnit = in.readByte() == 0;
        ParameterError error = ParameterError.valueOf(in.readShort());
        return new CpuServicesResponseParameter(functionGroup, subFunctionGroup, sequenceNumber, dataUnitReferenceNumber, lastDataUnit, error);
    }

    private List<VarParameterItem> decodeReadWriteVarParameter(ByteBuf in, byte numItems) {
        LinkedList<VarParameterItem> items = new LinkedList<VarParameterItem>();
        for (int i = 0; i < numItems; ++i) {
            MemoryArea memoryArea;
            short dbNumber;
            short length;
            TransportSize dataType;
            SpecificationType specificationType = SpecificationType.valueOf(in.readByte());
            byte itemLength = in.readByte();
            if (itemLength != 10) {
                logger.warn("Expecting a length of 10 here.");
                return items;
            }
            VariableAddressingMode variableAddressingMode = VariableAddressingMode.valueOf(in.readByte());
            if (variableAddressingMode == VariableAddressingMode.S7ANY) {
                dataType = TransportSize.valueOf(in.readByte());
                length = in.readShort();
                dbNumber = in.readShort();
                byte memoryAreaCode = in.readByte();
                memoryArea = MemoryArea.valueOf(memoryAreaCode);
                if (memoryArea == null) {
                    throw new PlcRuntimeException("Unknown memory area '" + memoryAreaCode + "'");
                }
            } else {
                logger.error("Error parsing item type");
                return items;
            }
            short byteAddress = (short)(in.readShort() << 5);
            byte tmp = in.readByte();
            byte bitAddress = (byte)(tmp & 7);
            byteAddress = (short)(byteAddress | tmp >> 3);
            S7AnyVarParameterItem item = new S7AnyVarParameterItem(specificationType, memoryArea, dataType, length, dbNumber, byteAddress, bitAddress);
            items.add(item);
        }
        return items;
    }

    private synchronized void trySendingMessages(ChannelHandlerContext ctx) {
        block5: {
            DataTpdu curTpdu;
            if (this.sentButUnacknowledgedTpdus.size() < this.maxAmqCaller && (curTpdu = (DataTpdu)this.queue.current()) != null) {
                block4: {
                    try {
                        ChannelFuture channelFuture = this.queue.removeAndWrite();
                        ctx.flush();
                        if (channelFuture != null) break block4;
                        break block5;
                    }
                    catch (Exception e) {
                        logger.error("Error sending more queues messages", (Throwable)e);
                        ctx.fireExceptionCaught((Throwable)e);
                    }
                }
                if (curTpdu.getParent() != null) {
                    S7RequestMessage s7RequestMessage = (S7RequestMessage)curTpdu.getParent();
                    this.sentButUnacknowledgedTpdus.put(s7RequestMessage.getTpduReference(), curTpdu);
                    logger.debug("S7 Message with id {}\u00a0sent", (Object)s7RequestMessage.getTpduReference());
                }
            }
        }
        ctx.flush();
    }

    private S7ControllerType lookupControllerType(String articleNumber) {
        String model;
        if (!articleNumber.startsWith("6ES7 ")) {
            return S7ControllerType.ANY;
        }
        switch (model = articleNumber.substring(articleNumber.indexOf(32) + 1, articleNumber.indexOf(32) + 2)) {
            case "2": {
                return S7ControllerType.S7_1200;
            }
            case "5": {
                return S7ControllerType.S7_1500;
            }
            case "3": {
                return S7ControllerType.S7_300;
            }
            case "4": {
                return S7ControllerType.S7_400;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Looking up unknown article number %s", articleNumber));
        }
        return S7ControllerType.ANY;
    }
}

