/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.s7.netty.model.types.MemoryArea;
import org.apache.plc4x.java.s7.netty.model.types.TransportSize;

public class S7Field
implements PlcField {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^%(?<memoryArea>.)(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final String DATA_TYPE = "dataType";
    private static final String TRANSFER_SIZE_CODE = "transferSizeCode";
    private static final String BLOCK_NUMBER = "blockNumber";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final String BIT_OFFSET = "bitOffset";
    private static final String NUM_ELEMENTS = "numElements";
    private static final String MEMORY_AREA = "memoryArea";
    private final TransportSize dataType;
    private final MemoryArea memoryArea;
    private final int blockNumber;
    private final int byteOffset;
    private final short bitOffset;
    private final int numElements;

    private S7Field(TransportSize dataType, MemoryArea memoryArea, int blockNumber, int byteOffset, short bitOffset, int numElements) {
        this.dataType = dataType;
        this.memoryArea = memoryArea;
        this.blockNumber = blockNumber;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.numElements = numElements;
    }

    public TransportSize getDataType() {
        return this.dataType;
    }

    public MemoryArea getMemoryArea() {
        return this.memoryArea;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public static boolean matches(String fieldString) {
        return DATA_BLOCK_ADDRESS_PATTERN.matcher(fieldString).matches() || ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public Class<?> getDefaultJavaType() {
        switch (this.dataType) {
            case STRING: {
                return String.class;
            }
            case USINT: 
            case SINT: 
            case UINT: 
            case INT: 
            case DINT: {
                return Integer.class;
            }
            case UDINT: 
            case ULINT: 
            case LINT: {
                return Long.class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case REAL: 
            case LREAL: {
                return Double.class;
            }
        }
        throw new NotImplementedException("The response type for datatype " + (Object)((Object)this.dataType) + " is not yet implemented");
    }

    public static S7Field of(String fieldString) {
        Matcher matcher = DATA_BLOCK_ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            String transferSizeCode = matcher.group(TRANSFER_SIZE_CODE);
            int blockNumber = S7Field.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            short bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Short.parseShort(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            numElements = S7Field.calcNumberOfElementsForStringTypes(numElements, dataType);
            if (!transferSizeCode.isEmpty() && !dataType.getSizeCode().equals(transferSizeCode)) {
                throw new PlcInvalidFieldException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7Field(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        }
        matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.valueOfShortName(matcher.group(MEMORY_AREA));
            String transferSizeCode = matcher.group(TRANSFER_SIZE_CODE);
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            short bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Short.parseShort(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            numElements = S7Field.calcNumberOfElementsForStringTypes(numElements, dataType);
            if (!transferSizeCode.isEmpty() && !dataType.getSizeCode().equals(transferSizeCode)) {
                throw new PlcInvalidFieldException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7Field(dataType, memoryArea, 0, byteOffset, bitOffset, numElements);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    private static int checkDatablockNumber(int blockNumber) {
        if (blockNumber > 64000 || blockNumber < 1) {
            throw new PlcInvalidFieldException("Datablock numbers larger than 64000 or smaller than 1 are not supported.");
        }
        return blockNumber;
    }

    private static int checkByteOffset(int byteOffset) {
        if (byteOffset > 0x1FFFFF || byteOffset < 0) {
            throw new PlcInvalidFieldException("ByteOffset must be smaller than 2097151 and positive.");
        }
        return byteOffset;
    }

    private static int calcNumberOfElementsForStringTypes(int numElements, TransportSize dataType) {
        if (!dataType.equals((Object)TransportSize.STRING)) {
            return numElements;
        }
        if (numElements > 1 && numElements <= 254) {
            return numElements + 2;
        }
        return 256;
    }
}

