/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isotp.protocol.model.types;

import java.util.HashMap;
import java.util.Map;

public enum TpduSize {
    SIZE_128(7, 128),
    SIZE_256(8, 256),
    SIZE_512(9, 512),
    SIZE_1024(10, 1024),
    SIZE_2048(11, 2048),
    SIZE_4096(12, 4096),
    SIZE_8192(13, 8192);

    private static final Map<Byte, TpduSize> map;
    private final byte code;
    private final int value;

    private TpduSize(byte code, int value) {
        this.code = code;
        this.value = value;
    }

    public byte getCode() {
        return this.code;
    }

    public int getValue() {
        return this.value;
    }

    public static TpduSize valueForGivenSize(int pduSize) {
        if (pduSize <= 0) {
            throw new IllegalArgumentException("PduSize has to be greater than 0");
        }
        for (TpduSize tpduSize : TpduSize.values()) {
            if (tpduSize.getValue() < pduSize) continue;
            return tpduSize;
        }
        return SIZE_8192;
    }

    public static TpduSize valueOf(byte code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Byte, TpduSize>();
        for (TpduSize tpduSize : TpduSize.values()) {
            map.put(tpduSize.code, tpduSize);
        }
    }
}

