/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isotp.protocol.model.types;

import java.util.HashMap;
import java.util.Map;

public enum TpduCode {
    DATA(-16),
    DATA_ACKNOWLEDGEMENT(96),
    CONNECTION_REQUEST(-32),
    CONNECTION_CONFIRM(-48),
    DISCONNECT_REQUEST(-128),
    DISCONNECT_CONFIRM(-64),
    EXPEDITED_DATA(16),
    EXPEDITED_DATA_ACKNOWLEDGEMENT(32),
    REJECT(80),
    TPDU_ERROR(112),
    TPDU_UNKNOWN(-1);

    private static final Map<Byte, TpduCode> map;
    private final byte code;

    private TpduCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static TpduCode valueOf(byte code) {
        if (map.containsKey(code)) {
            return map.get(code);
        }
        return TPDU_UNKNOWN;
    }

    static {
        map = new HashMap<Byte, TpduCode>();
        for (TpduCode tpduCode : TpduCode.values()) {
            map.put(tpduCode.code, tpduCode);
        }
    }
}

