/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultIntegerFieldItem
extends BaseDefaultFieldItem<Integer> {
    public DefaultIntegerFieldItem(Integer ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return (long)((Integer)this.getValue(index)).intValue() != 0L;
    }

    @Override
    public boolean isValidByte(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && value <= 127 && value >= -128;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return ((Integer)this.getValue(index)).byteValue();
    }

    @Override
    public boolean isValidShort(int index) {
        Integer value = (Integer)this.getValue(index);
        return value != null && value <= Short.MAX_VALUE && value >= Short.MIN_VALUE;
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((Integer)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return (Integer)this.getValue(index);
    }

    @Override
    public boolean isValidLong(int index) {
        return this.isValidInteger(index);
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return ((Integer)this.getValue(index)).longValue();
    }

    @Override
    public boolean isValidBigInteger(int index) {
        return this.isValidInteger(index);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return BigInteger.valueOf(((Integer)this.getValue(index)).intValue());
    }

    @Override
    public boolean isValidFloat(int index) {
        return this.isValidInteger(index);
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((Integer)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.isValidInteger(index);
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return ((Integer)this.getValue(index)).doubleValue();
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.isValidInteger(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return new BigDecimal((Integer)this.getValue(index));
    }
}

