/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultByteFieldItem
extends BaseDefaultFieldItem<Byte> {
    public DefaultByteFieldItem(Byte ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return (long)((Byte)this.getValue(index)).byteValue() != 0L;
    }

    @Override
    public boolean isValidByte(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Byte)this.getValue(index);
    }

    @Override
    public boolean isValidShort(int index) {
        return this.isValidByte(index);
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((Byte)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        return this.isValidByte(index);
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return ((Byte)this.getValue(index)).intValue();
    }

    @Override
    public boolean isValidLong(int index) {
        return this.isValidByte(index);
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return ((Byte)this.getValue(index)).longValue();
    }

    @Override
    public boolean isValidBigInteger(int index) {
        return this.isValidByte(index);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return BigInteger.valueOf(((Byte)this.getValue(index)).byteValue());
    }

    @Override
    public boolean isValidFloat(int index) {
        return this.isValidByte(index);
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((Byte)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.isValidByte(index);
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return ((Byte)this.getValue(index)).doubleValue();
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.isValidByte(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return new BigDecimal(((Byte)this.getValue(index)).byteValue());
    }
}

