/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultBooleanFieldItem
extends BaseDefaultFieldItem<Boolean> {
    public DefaultBooleanFieldItem(Boolean ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return (Boolean)this.getValue(index);
    }

    @Override
    public boolean isValidByte(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? (byte)1 : 0;
    }

    @Override
    public boolean isValidShort(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? (short)1 : 0;
    }

    @Override
    public boolean isValidInteger(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? 1 : 0;
    }

    @Override
    public boolean isValidLong(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? 1L : 0L;
    }

    @Override
    public boolean isValidBigInteger(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public boolean isValidFloat(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return Float.valueOf((Boolean)this.getValue(index) != false ? 1.0f : 0.0f);
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? 1.0 : 0.0;
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.isValidBoolean(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return (Boolean)this.getValue(index) != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    public Byte getCompleteByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        BitSet bitSet = new BitSet();
        int i = 0;
        if (this.getValues() != null) {
            for (Boolean value : (Boolean[])this.getValues()) {
                bitSet.set(i, value);
                ++i;
            }
        }
        int numBytes = i / 8 + (i % 8 == 0 ? 0 : 1);
        byte[] bytes = bitSet.toByteArray();
        if (numBytes - 1 < index) {
            return null;
        }
        if (bytes.length < numBytes && bytes.length <= index) {
            return (byte)0;
        }
        return bytes[index];
    }
}

