/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultBigDecimalFieldItem
extends BaseDefaultFieldItem<BigDecimal> {
    public DefaultBigDecimalFieldItem(BigDecimal ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return ((BigDecimal)this.getValue(index)).compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public boolean isValidByte(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-128L);
        BigDecimal max = BigDecimal.valueOf(127L);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return ((BigDecimal)this.getValue(index)).byteValue();
    }

    @Override
    public boolean isValidShort(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-32768L);
        BigDecimal max = BigDecimal.valueOf(32767L);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((BigDecimal)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(Integer.MIN_VALUE);
        BigDecimal max = BigDecimal.valueOf(Integer.MAX_VALUE);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return ((BigDecimal)this.getValue(index)).intValue();
    }

    @Override
    public boolean isValidLong(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(Long.MIN_VALUE);
        BigDecimal max = BigDecimal.valueOf(Long.MAX_VALUE);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return ((BigDecimal)this.getValue(index)).longValue();
    }

    @Override
    public boolean isValidBigInteger(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return ((BigDecimal)this.getValue(index)).toBigInteger();
    }

    @Override
    public boolean isValidFloat(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-3.4028234663852886E38);
        BigDecimal max = BigDecimal.valueOf(3.4028234663852886E38);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((BigDecimal)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        BigDecimal value = (BigDecimal)this.getValue(index);
        BigDecimal min = BigDecimal.valueOf(-1.7976931348623157E308);
        BigDecimal max = BigDecimal.valueOf(Double.MAX_VALUE);
        return value != null && value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return ((BigDecimal)this.getValue(index)).doubleValue();
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return (BigDecimal)this.getValue(index);
    }
}

