/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcFieldRangeException;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;

public abstract class BaseDefaultFieldItem<T> {
    private final T[] values;

    protected BaseDefaultFieldItem(T[] values) {
        this.values = Objects.requireNonNull(values);
    }

    public int getNumberOfValues() {
        return this.values.length;
    }

    public abstract Object getObject(int var1);

    public boolean isValidBoolean(int index) {
        return false;
    }

    public Boolean getBoolean(int index) {
        throw new PlcIncompatibleDatatypeException(Boolean.class, index);
    }

    public boolean isValidByte(int index) {
        return false;
    }

    public Byte getByte(int index) {
        throw new PlcIncompatibleDatatypeException(Byte.class, index);
    }

    public boolean isValidShort(int index) {
        return false;
    }

    public Short getShort(int index) {
        throw new PlcIncompatibleDatatypeException(Short.class, index);
    }

    public boolean isValidInteger(int index) {
        return false;
    }

    public Integer getInteger(int index) {
        throw new PlcIncompatibleDatatypeException(Integer.class, index);
    }

    public boolean isValidLong(int index) {
        return false;
    }

    public Long getLong(int index) {
        throw new PlcIncompatibleDatatypeException(Long.class, index);
    }

    public boolean isValidBigInteger(int index) {
        return false;
    }

    public BigInteger getBigInteger(int index) {
        throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
    }

    public boolean isValidFloat(int index) {
        return false;
    }

    public Float getFloat(int index) {
        throw new PlcIncompatibleDatatypeException(Float.class, index);
    }

    public boolean isValidDouble(int index) {
        return false;
    }

    public Double getDouble(int index) {
        throw new PlcIncompatibleDatatypeException(Double.class, index);
    }

    public boolean isValidBigDecimal(int index) {
        return false;
    }

    public BigDecimal getBigDecimal(int index) {
        throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
    }

    public boolean isValidString(int index) {
        return false;
    }

    public String getString(int index) {
        throw new PlcIncompatibleDatatypeException(String.class, index);
    }

    public boolean isValidTime(int index) {
        return false;
    }

    public LocalTime getTime(int index) {
        throw new PlcIncompatibleDatatypeException(LocalTime.class, index);
    }

    public boolean isValidDate(int index) {
        return false;
    }

    public LocalDate getDate(int index) {
        throw new PlcIncompatibleDatatypeException(LocalDate.class, index);
    }

    public boolean isValidDateTime(int index) {
        return false;
    }

    public LocalDateTime getDateTime(int index) {
        throw new PlcIncompatibleDatatypeException(LocalDateTime.class, index);
    }

    public boolean isValidByteArray(int index) {
        return false;
    }

    public Byte[] getByteArray(int index) {
        throw new PlcIncompatibleDatatypeException(Byte[].class, index);
    }

    public T[] getValues() {
        return this.values;
    }

    protected T getValue(int index) {
        if (this.values == null || index < 0 || index >= this.values.length) {
            throw new PlcFieldRangeException(this.values == null ? -1 : this.values.length - 1, index);
        }
        return this.values[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseDefaultFieldItem)) {
            return false;
        }
        BaseDefaultFieldItem fieldItem = (BaseDefaultFieldItem)o;
        return Arrays.equals(this.values, fieldItem.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{values=" + Arrays.toString(this.values) + '}';
    }
}

