/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionResponse;

public class DefaultPlcSubscriptionResponse
implements InternalPlcSubscriptionResponse {
    private final InternalPlcSubscriptionRequest request;
    private final Map<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> values;

    public DefaultPlcSubscriptionResponse(InternalPlcSubscriptionRequest request, Map<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> values) {
        this.request = request;
        this.values = values;
    }

    public PlcSubscriptionHandle getSubscriptionHandle(String name) {
        Pair<PlcResponseCode, PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        if (response.getKey() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Item " + name + " failed to subscribe: " + response.getKey());
        }
        return (PlcSubscriptionHandle)response.getValue();
    }

    public Collection<String> getFieldNames() {
        return this.values.keySet();
    }

    public PlcField getField(String name) {
        throw new PlcNotImplementedException("field access not possible as these come async");
    }

    public PlcResponseCode getResponseCode(String name) {
        Pair<PlcResponseCode, PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        return (PlcResponseCode)response.getKey();
    }

    public PlcSubscriptionRequest getRequest() {
        return this.request;
    }

    public Collection<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.values.values().stream().map(Pair::getValue).collect(Collectors.toList());
    }

    @Override
    public Map<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> getValues() {
        return this.values;
    }
}

