/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadResponse;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultPlcReadResponse
implements InternalPlcReadResponse {
    private final InternalPlcReadRequest request;
    private final Map<String, Pair<PlcResponseCode, BaseDefaultFieldItem>> values;

    public DefaultPlcReadResponse(InternalPlcReadRequest request, Map<String, Pair<PlcResponseCode, BaseDefaultFieldItem>> fields) {
        this.request = request;
        this.values = fields;
    }

    public InternalPlcReadRequest getRequest() {
        return this.request;
    }

    public int getNumberOfValues(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getNumberOfValues();
    }

    public Collection<String> getFieldNames() {
        return this.request.getFieldNames();
    }

    public PlcField getField(String name) {
        return this.request.getField(name);
    }

    public PlcResponseCode getResponseCode(String name) {
        if (this.values.get(name) == null) {
            throw new PlcInvalidFieldException(name);
        }
        return (PlcResponseCode)this.values.get(name).getKey();
    }

    @Override
    public Map<String, Pair<PlcResponseCode, BaseDefaultFieldItem>> getValues() {
        return this.values;
    }

    public Object getObject(String name) {
        if (this.getFieldInternal(name).getNumberOfValues() > 1) {
            return this.getAllObjects(name);
        }
        return this.getObject(name, 0);
    }

    public Object getObject(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getObject(index);
    }

    public Collection<Object> getAllObjects(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Object> objectList = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            objectList.add(fieldInternal.getObject(i));
        }
        return objectList;
    }

    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    public boolean isValidBoolean(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidBoolean(index);
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    public Boolean getBoolean(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getBoolean(index);
    }

    public Collection<Boolean> getAllBooleans(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Boolean> values = new ArrayList<Boolean>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getBoolean(i));
        }
        return values;
    }

    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    public boolean isValidByte(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidByte(index);
    }

    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    public Byte getByte(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getByte(index);
    }

    public Collection<Byte> getAllBytes(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Byte> values = new ArrayList<Byte>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getByte(i));
        }
        return values;
    }

    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    public boolean isValidShort(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidShort(index);
    }

    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    public Short getShort(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getShort(index);
    }

    public Collection<Short> getAllShorts(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Short> values = new ArrayList<Short>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getShort(i));
        }
        return values;
    }

    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    public boolean isValidInteger(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidInteger(index);
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public Integer getInteger(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getInteger(index);
    }

    public Collection<Integer> getAllIntegers(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Integer> values = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getInteger(i));
        }
        return values;
    }

    public boolean isValidBigInteger(String name) {
        return this.isValidBigInteger(name, 0);
    }

    public boolean isValidBigInteger(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidInteger(index);
    }

    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(name, 0);
    }

    public BigInteger getBigInteger(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getBigInteger(index);
    }

    public Collection<BigInteger> getAllBigIntegers(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getBigInteger(i));
        }
        return values;
    }

    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    public boolean isValidLong(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidLong(index);
    }

    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    public Long getLong(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getLong(index);
    }

    public Collection<Long> getAllLongs(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Long> values = new ArrayList<Long>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getLong(i));
        }
        return values;
    }

    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    public boolean isValidFloat(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidFloat(index);
    }

    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    public Float getFloat(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getFloat(index);
    }

    public Collection<Float> getAllFloats(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Float> values = new ArrayList<Float>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getFloat(i));
        }
        return values;
    }

    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    public boolean isValidDouble(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidDouble(index);
    }

    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    public Double getDouble(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getDouble(index);
    }

    public Collection<Double> getAllDoubles(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Double> values = new ArrayList<Double>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getDouble(i));
        }
        return values;
    }

    public boolean isValidBigDecimal(String name) {
        return this.isValidBigDecimal(name, 0);
    }

    public boolean isValidBigDecimal(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidBigDecimal(index);
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, 0);
    }

    public BigDecimal getBigDecimal(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getBigDecimal(index);
    }

    public Collection<BigDecimal> getAllBigDecimals(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getBigDecimal(i));
        }
        return values;
    }

    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    public boolean isValidString(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidString(index);
    }

    public String getString(String name) {
        return this.getString(name, 0);
    }

    public String getString(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getString(index);
    }

    public Collection<String> getAllStrings(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<String> values = new ArrayList<String>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getString(i));
        }
        return values;
    }

    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    public boolean isValidTime(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidTime(index);
    }

    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    public LocalTime getTime(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getTime(index);
    }

    public Collection<LocalTime> getAllTimes(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<LocalTime> values = new ArrayList<LocalTime>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getTime(i));
        }
        return values;
    }

    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    public boolean isValidDate(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidDate(index);
    }

    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    public LocalDate getDate(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getDate(index);
    }

    public Collection<LocalDate> getAllDates(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<LocalDate> values = new ArrayList<LocalDate>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getDate(i));
        }
        return values;
    }

    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    public boolean isValidDateTime(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidDateTime(index);
    }

    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    public LocalDateTime getDateTime(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getDateTime(index);
    }

    public Collection<LocalDateTime> getAllDateTimes(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<LocalDateTime> values = new ArrayList<LocalDateTime>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getDateTime(i));
        }
        return values;
    }

    public boolean isValidByteArray(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidByteArray(0);
    }

    public boolean isValidByteArray(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.isValidByteArray(index);
    }

    public Byte[] getByteArray(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getByteArray(0);
    }

    public Byte[] getByteArray(String name, int index) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        return fieldInternal.getByteArray(index);
    }

    public Collection<Byte[]> getAllByteArrays(String name) {
        BaseDefaultFieldItem fieldInternal = this.getFieldInternal(name);
        int num = fieldInternal.getNumberOfValues();
        ArrayList<Byte[]> values = new ArrayList<Byte[]>(num);
        for (int i = 0; i < num; ++i) {
            values.add(fieldInternal.getByteArray(i));
        }
        return values;
    }

    protected BaseDefaultFieldItem getFieldInternal(String name) {
        Objects.requireNonNull(name, "Name argument required");
        if (this.values.get(name) == null) {
            throw new PlcInvalidFieldException(name);
        }
        if (this.values.get(name).getKey() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Field '" + name + "' could not be fetched, response was " + this.values.get(name).getKey());
        }
        return (BaseDefaultFieldItem)this.values.get(name).getValue();
    }
}

