/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.base.connection.ChannelFactory;

public class TcpSocketChannelFactory
implements ChannelFactory {
    private static final int PING_TIMEOUT_MS = 1000;
    private final InetAddress address;
    private final int port;

    public TcpSocketChannelFactory(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public Channel createChannel(ChannelHandler channelHandler) throws PlcConnectionException {
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.handler(channelHandler);
            ChannelFuture f = bootstrap.connect(this.address, this.port).sync();
            f.awaitUninterruptibly();
            return f.channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("Error creating channel.", (Throwable)e);
        }
        catch (Exception e) {
            throw new PlcConnectionException("Error creating channel.", (Throwable)e);
        }
    }

    public void ping() throws PlcException {
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), this.getPort());
        try (Socket s = new Socket();){
            s.connect(address, 1000);
            s.setReuseAddress(true);
        }
        catch (Exception e) {
            throw new PlcConnectionException("Unable to ping remote host");
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }
}

