/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.spi.PlcDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlcDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlcDriverManager.class);
    protected ClassLoader classLoader;
    private Map<String, PlcDriver> driverMap;

    public PlcDriverManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public PlcDriverManager(ClassLoader classLoader) {
        LOGGER.info("Instantiating new PLC Driver Manager with class loader {}", (Object)classLoader);
        this.classLoader = classLoader;
        this.driverMap = new HashMap<String, PlcDriver>();
        ServiceLoader<PlcDriver> plcDriverLoader = ServiceLoader.load(PlcDriver.class, classLoader);
        LOGGER.info("Registering available drivers...");
        for (PlcDriver driver : plcDriverLoader) {
            if (this.driverMap.containsKey(driver.getProtocolCode())) {
                throw new IllegalStateException("Multiple driver implementations available for protocol code '" + driver.getProtocolCode() + "'");
            }
            LOGGER.info("Registering driver for Protocol {} ({})", (Object)driver.getProtocolCode(), (Object)driver.getProtocolName());
            this.driverMap.put(driver.getProtocolCode(), driver);
        }
    }

    public PlcConnection getConnection(String url) throws PlcConnectionException {
        PlcDriver driver = this.getDriver(url);
        PlcConnection connection = driver.connect(url);
        connection.connect();
        return connection;
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        PlcDriver driver = this.getDriver(url);
        PlcConnection connection = driver.connect(url, authentication);
        connection.connect();
        return connection;
    }

    private PlcDriver getDriver(String url) throws PlcConnectionException {
        try {
            URI connectionUri = new URI(url);
            String protocol = connectionUri.getScheme();
            PlcDriver driver = this.driverMap.get(protocol);
            if (driver == null) {
                throw new PlcConnectionException("Unable to find driver for protocol '" + protocol + "'");
            }
            return driver;
        }
        catch (URISyntaxException e) {
            throw new PlcConnectionException("Invalid plc4j connection string '" + url + "'", e);
        }
    }
}

