/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.skin.ComponentSkin;

public abstract class ContainerSkin
extends ComponentSkin
implements ContainerListener,
ContainerMouseListener {
    private Paint backgroundPaint = null;
    private static FocusTraversalPolicy DEFAULT_FOCUS_TRAVERSAL_POLICY = new IndexFocusTraversalPolicy();

    @Override
    public void install(Component component) {
        super.install(component);
        Container container = (Container)component;
        container.getContainerListeners().add((Object)this);
        container.getContainerMouseListeners().add((Object)this);
        container.setFocusTraversalPolicy(DEFAULT_FOCUS_TRAVERSAL_POLICY);
    }

    @Override
    public int getPreferredWidth(int height) {
        return 0;
    }

    @Override
    public int getPreferredHeight(int width) {
        return 0;
    }

    @Override
    public void paint(Graphics2D graphics) {
        if (this.backgroundPaint != null) {
            graphics.setPaint(this.backgroundPaint);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundPaint != null && this.backgroundPaint.getTransparency() == 1;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
        this.repaintComponent();
    }

    public final void setBackgroundPaint(String backgroundPaint) {
        if (backgroundPaint == null) {
            throw new IllegalArgumentException("backgroundPaint is null");
        }
        this.setBackgroundPaint(GraphicsUtilities.decodePaint(backgroundPaint));
    }

    public final void setBackgroundPaint(Dictionary<String, ?> backgroundPaint) {
        if (backgroundPaint == null) {
            throw new IllegalArgumentException("backgroundPaint is null");
        }
        this.setBackgroundPaint(GraphicsUtilities.decodePaint(backgroundPaint));
    }

    public Color getBackgroundColor() {
        return this.backgroundPaint instanceof Color ? (Color)this.backgroundPaint : null;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.setBackgroundPaint(backgroundColor);
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    @Override
    public void componentInserted(Container container, int index) {
    }

    @Override
    public void componentsRemoved(Container container, int index, Sequence<Component> removed) {
    }

    @Override
    public void componentMoved(Container container, int from, int to) {
    }

    @Override
    public void focusTraversalPolicyChanged(Container container, FocusTraversalPolicy previousFocusTraversalPolicy) {
    }

    @Override
    public boolean mouseMove(Container container, int x, int y) {
        return false;
    }

    @Override
    public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
        return false;
    }

    @Override
    public boolean mouseUp(Container container, Mouse.Button button, int x, int y) {
        return false;
    }

    @Override
    public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        return false;
    }

    public static class IndexFocusTraversalPolicy
    implements FocusTraversalPolicy {
        private boolean wrap;

        public IndexFocusTraversalPolicy() {
            this(false);
        }

        public IndexFocusTraversalPolicy(boolean wrap) {
            this.wrap = wrap;
        }

        @Override
        public Component getNextComponent(Container container, Component component, FocusTraversalDirection direction) {
            if (container == null) {
                throw new IllegalArgumentException("container is null.");
            }
            if (direction == null) {
                throw new IllegalArgumentException("direction is null.");
            }
            Component nextComponent = null;
            int n = container.getLength();
            if (n > 0) {
                switch (direction) {
                    case FORWARD: {
                        if (component == null) {
                            nextComponent = container.get(0);
                            break;
                        }
                        int index = container.indexOf(component);
                        if (index == -1) {
                            throw new IllegalArgumentException();
                        }
                        if (index < n - 1) {
                            nextComponent = container.get(index + 1);
                            break;
                        }
                        if (!this.wrap) break;
                        nextComponent = container.get(0);
                        break;
                    }
                    case BACKWARD: {
                        if (component == null) {
                            nextComponent = container.get(n - 1);
                            break;
                        }
                        int index = container.indexOf(component);
                        if (index == -1) {
                            throw new IllegalArgumentException();
                        }
                        if (index > 0) {
                            nextComponent = container.get(index - 1);
                            break;
                        }
                        if (!this.wrap) break;
                        nextComponent = container.get(n - 1);
                        break;
                    }
                }
            }
            return nextComponent;
        }
    }
}

