/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Font;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.ComponentTooltipListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;

public abstract class ComponentSkin
implements Skin,
ComponentListener,
ComponentStateListener,
ComponentMouseListener,
ComponentMouseButtonListener,
ComponentMouseWheelListener,
ComponentKeyListener,
ComponentTooltipListener {
    private Component component = null;
    private int width = 0;
    private int height = 0;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public final int getBaseline() {
        return this.getBaseline(this.width, this.height);
    }

    @Override
    public int getBaseline(int widthArgument, int heightArgument) {
        return -1;
    }

    @Override
    public void install(Component componentArgument) {
        assert (this.component == null) : "Skin is already installed on a component.";
        componentArgument.getComponentListeners().add((Object)this);
        componentArgument.getComponentStateListeners().add((Object)this);
        componentArgument.getComponentMouseListeners().add((Object)this);
        componentArgument.getComponentMouseButtonListeners().add((Object)this);
        componentArgument.getComponentMouseWheelListeners().add((Object)this);
        componentArgument.getComponentKeyListeners().add((Object)this);
        componentArgument.getComponentTooltipListeners().add((Object)this);
        this.component = componentArgument;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void parentChanged(Component componentArgument, Container previousParent) {
    }

    @Override
    public void sizeChanged(Component componentArgument, int previousWidth, int previousHeight) {
    }

    @Override
    public void preferredSizeChanged(Component componentArgument, int previousPreferredWidth, int previousPreferredHeight) {
    }

    @Override
    public void widthLimitsChanged(Component componentArgument, int previousMinimumWidth, int previousMaximumWidth) {
    }

    @Override
    public void heightLimitsChanged(Component componentArgument, int previousMinimumHeight, int previousMaximumHeight) {
    }

    @Override
    public void locationChanged(Component componentArgument, int previousX, int previousY) {
    }

    @Override
    public void visibleChanged(Component componentArgument) {
    }

    @Override
    public void cursorChanged(Component componentArgument, Cursor previousCursor) {
    }

    @Override
    public void tooltipTextChanged(Component componentArgument, String previousTooltipText) {
    }

    @Override
    public void tooltipDelayChanged(Component componentArgument, int previousTooltipDelay) {
    }

    @Override
    public void dragSourceChanged(Component componentArgument, DragSource previousDragSource) {
    }

    @Override
    public void dropTargetChanged(Component componentArgument, DropTarget previousDropTarget) {
    }

    @Override
    public void menuHandlerChanged(Component componentArgument, MenuHandler previousMenuHandler) {
    }

    @Override
    public void nameChanged(Component componentArgument, String previousName) {
    }

    @Override
    public void enabledChanged(Component componentArgument) {
    }

    @Override
    public void focusedChanged(Component componentArgument, Component obverseComponent) {
    }

    @Override
    public boolean mouseMove(Component componentArgument, int x, int y) {
        return false;
    }

    @Override
    public void mouseOver(Component componentArgument) {
    }

    @Override
    public void mouseOut(Component componentArgument) {
    }

    @Override
    public boolean mouseDown(Component componentArgument, Mouse.Button button, int x, int y) {
        return false;
    }

    @Override
    public boolean mouseUp(Component componentArgument, Mouse.Button button, int x, int y) {
        return false;
    }

    @Override
    public boolean mouseClick(Component componentArgument, Mouse.Button button, int x, int y, int count) {
        return false;
    }

    @Override
    public boolean mouseWheel(Component componentArgument, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        return false;
    }

    @Override
    public boolean keyTyped(Component componentArgument, char character) {
        return false;
    }

    @Override
    public boolean keyPressed(Component componentArgument, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 9 && this.getComponent().isFocused()) {
            FocusTraversalDirection direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
            Component focusedComponent = this.component.transferFocus(direction);
            if (this.component != focusedComponent && focusedComponent != null) {
                focusedComponent.scrollAreaToVisible(0, 0, focusedComponent.getWidth(), focusedComponent.getHeight());
            }
            consumed = true;
        }
        return consumed;
    }

    @Override
    public boolean keyReleased(Component componentArgument, int keyCode, Keyboard.KeyLocation keyLocation) {
        return false;
    }

    @Override
    public void tooltipTriggered(Component componentArgument, int x, int y) {
        String tooltipText = this.component.getTooltipText();
        if (tooltipText != null) {
            Label tooltipLabel = new Label(tooltipText);
            boolean tooltipWrapText = this.component.getTooltipWrapText();
            tooltipLabel.getStyles().put("wrapText", (Object)tooltipWrapText);
            Tooltip tooltip = new Tooltip(tooltipLabel);
            Display display = this.component.getDisplay();
            Point location = this.component.mapPointToAncestor(display, x, y);
            int tooltipX = location.x + 16;
            int tooltipY = location.y;
            int tooltipWidth = tooltip.getPreferredWidth();
            int tooltipHeight = tooltip.getPreferredHeight();
            if (tooltipX + tooltipWidth > display.getWidth()) {
                tooltipX = tooltipY > tooltipHeight ? display.getWidth() - tooltipWidth : location.x - tooltipWidth - 16;
                if (tooltipX < 0) {
                    tooltipX = 0;
                }
                if (tooltipX < location.x && tooltipX + tooltipWidth > location.x && (tooltipY -= tooltipHeight) < 0) {
                    tooltipY = 0;
                }
            }
            if (tooltipY + tooltipHeight > display.getHeight()) {
                tooltipY -= tooltipHeight;
            }
            tooltip.setLocation(tooltipX, tooltipY);
            tooltip.open(this.component.getWindow());
        }
    }

    protected void invalidateComponent() {
        if (this.component != null) {
            this.component.invalidate();
            this.component.repaint();
        }
    }

    protected void repaintComponent() {
        this.repaintComponent(false);
    }

    protected void repaintComponent(boolean immediate) {
        if (this.component != null) {
            this.component.repaint(immediate);
        }
    }

    protected void repaintComponent(Bounds area) {
        assert (area != null) : "area is null.";
        if (this.component != null) {
            this.component.repaint(area.x, area.y, area.width, area.height);
        }
    }

    protected void repaintComponent(int x, int y, int widthArgument, int heightArgument) {
        if (this.component != null) {
            this.component.repaint(x, y, widthArgument, heightArgument);
        }
    }

    protected void repaintComponent(int x, int y, int widthArgument, int heightArgument, boolean immediate) {
        if (this.component != null) {
            this.component.repaint(x, y, widthArgument, heightArgument, immediate);
        }
    }

    public static Font decodeFont(String value) {
        Font font;
        if (value.startsWith("{")) {
            try {
                font = Theme.deriveFont(JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            font = Font.decode(value);
        }
        return font;
    }
}

