/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.effects.Decorator;

public class TranslationDecorator
implements Decorator {
    private int x;
    private int y;
    private boolean clip;

    public TranslationDecorator() {
        this(0, 0, false);
    }

    public TranslationDecorator(boolean clip) {
        this(0, 0, clip);
    }

    public TranslationDecorator(int x, int y, boolean clip) {
        this.setOffset(x, y);
        this.setClip(clip);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Point getOffset() {
        return new Point(this.x, this.y);
    }

    public void setOffset(Point offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset is null.");
        }
        this.setOffset(offset.x, offset.y);
    }

    public void setOffset(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean getClip() {
        return this.clip;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics) {
        if (this.clip) {
            Bounds decoratedBounds = component.getDecoratedBounds();
            graphics.clipRect(decoratedBounds.x - component.getX(), decoratedBounds.y - component.getY(), decoratedBounds.width, decoratedBounds.height);
        }
        graphics.translate(this.x, this.y);
        return graphics;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        Bounds bounds = new Bounds(this.x, this.y, width, height);
        if (this.clip) {
            bounds = bounds.intersect(0, 0, width, height);
        }
        return bounds;
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return AffineTransform.getTranslateInstance(this.x, this.y);
    }
}

