/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.effects.Decorator;

public class ScaleDecorator
implements Decorator {
    private float scaleX;
    private float scaleY;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;

    public ScaleDecorator() {
        this(1.0f, 1.0f);
    }

    public ScaleDecorator(float scaleX, float scaleY) {
        this.setScale(scaleX, scaleY);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.setScale(scaleX, this.scaleY);
    }

    public void setScaleX(Number scaleX) {
        if (scaleX == null) {
            throw new IllegalArgumentException("scaleX is null.");
        }
        this.setScaleX(scaleX.floatValue());
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.setScale(this.scaleX, scaleY);
    }

    public void setScaleY(Number scaleY) {
        if (scaleY == null) {
            throw new IllegalArgumentException("scaleY is null.");
        }
        this.setScaleY(scaleY.floatValue());
    }

    public void setScale(float scaleX, float scaleY) {
        if (scaleX < 0.0f) {
            throw new IllegalArgumentException("scaleX is negative.");
        }
        if (scaleY < 0.0f) {
            throw new IllegalArgumentException("scaleY is negative.");
        }
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
    }

    private int getTranslatedX(Component component) {
        int tx;
        int width = component.getWidth();
        int translatedWidth = (int)Math.ceil((float)width * this.scaleX);
        switch (this.horizontalAlignment) {
            case LEFT: {
                tx = 0;
                break;
            }
            case RIGHT: {
                tx = width - translatedWidth;
                break;
            }
            default: {
                tx = (width - translatedWidth) / 2;
            }
        }
        return tx;
    }

    private int getTranslatedY(Component component) {
        int ty;
        int height = component.getHeight();
        int translatedHeight = (int)Math.ceil((float)height * this.scaleY);
        switch (this.verticalAlignment) {
            case TOP: {
                ty = 0;
                break;
            }
            case BOTTOM: {
                ty = height - translatedHeight;
                break;
            }
            default: {
                ty = (height - translatedHeight) / 2;
            }
        }
        return ty;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.getAntiAliasingHint());
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.getFractionalMetricsHint());
        int tx = this.getTranslatedX(component);
        int ty = this.getTranslatedY(component);
        if (tx != 0 || ty != 0) {
            graphics.translate(tx, ty);
        }
        graphics.scale(Math.max(this.scaleX, Float.MIN_NORMAL), Math.max(this.scaleY, Float.MIN_NORMAL));
        return graphics;
    }

    @Override
    public void update() {
    }

    public void repaint(Component component, int x, int y, int width, int height) {
        Container parent = component.getParent();
        if (parent != null) {
            int tx = this.getTranslatedX(component);
            int ty = this.getTranslatedY(component);
            int xUpdated = (int)((float)x * this.scaleX + (float)component.getX() + (float)tx);
            int yUpdated = (int)((float)y * this.scaleY + (float)component.getY() + (float)ty);
            int widthUpdated = (int)Math.ceil((float)width * this.scaleX);
            int heightUpdated = (int)Math.ceil((float)height * this.scaleY);
            parent.repaint(xUpdated, yUpdated, widthUpdated, heightUpdated);
        }
    }

    @Override
    public Bounds getBounds(Component component) {
        int width = (int)Math.ceil((float)component.getWidth() * this.scaleX);
        int height = (int)Math.ceil((float)component.getHeight() * this.scaleY);
        int tx = this.getTranslatedX(component);
        int ty = this.getTranslatedY(component);
        return new Bounds(tx, ty, width, height);
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }
}

