/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import org.apache.pivot.wtk.GraphicsUtilities;

public class ColorItem {
    private Color color;
    private String name;

    public ColorItem() {
        this(Color.BLACK, null);
    }

    public ColorItem(Color color) {
        this(color, null);
    }

    public ColorItem(Color color, String name) {
        this.setColor(color);
        this.setName(name);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
    }

    public void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? String.format("#%02X%02X%02X", this.color.getRed(), this.color.getGreen(), this.color.getBlue()) : name;
    }

    public boolean equals(Object o) {
        return o instanceof ColorItem && ((ColorItem)o).color.equals(this.color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }
}

