/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Locale;
import org.apache.pivot.wtk.DropAction;
import org.apache.pivot.wtk.Platform;

public final class Keyboard {
    private static int modifiers = 0;

    public static int getModifiers() {
        return modifiers;
    }

    protected static void setModifiers(int modifiers) {
        Keyboard.modifiers = modifiers;
    }

    public static boolean isPressed(Modifier modifier) {
        return (modifiers & modifier.getMask()) > 0;
    }

    public static DropAction getDropAction() {
        DropAction dropAction = null;
        dropAction = Keyboard.isPressed(Modifier.CTRL) && Keyboard.isPressed(Modifier.SHIFT) ? DropAction.LINK : (Keyboard.isPressed(Modifier.CTRL) ? DropAction.COPY : DropAction.MOVE);
        return dropAction;
    }

    public static final class KeyCode {
        public static final int A = 65;
        public static final int B = 66;
        public static final int C = 67;
        public static final int D = 68;
        public static final int E = 69;
        public static final int F = 70;
        public static final int G = 71;
        public static final int H = 72;
        public static final int I = 73;
        public static final int J = 74;
        public static final int K = 75;
        public static final int L = 76;
        public static final int M = 77;
        public static final int N = 78;
        public static final int O = 79;
        public static final int P = 80;
        public static final int Q = 81;
        public static final int R = 82;
        public static final int S = 83;
        public static final int T = 84;
        public static final int U = 85;
        public static final int V = 86;
        public static final int W = 87;
        public static final int X = 88;
        public static final int Y = 89;
        public static final int Z = 90;
        public static final int N0 = 48;
        public static final int N1 = 49;
        public static final int N2 = 50;
        public static final int N3 = 51;
        public static final int N4 = 52;
        public static final int N5 = 53;
        public static final int N6 = 54;
        public static final int N7 = 55;
        public static final int N8 = 56;
        public static final int N9 = 57;
        public static final int TAB = 9;
        public static final int SPACE = 32;
        public static final int ENTER = 10;
        public static final int ESCAPE = 27;
        public static final int BACKSPACE = 8;
        public static final int DELETE = 127;
        public static final int INSERT = 155;
        public static final int UP = 38;
        public static final int DOWN = 40;
        public static final int LEFT = 37;
        public static final int RIGHT = 39;
        public static final int PAGE_UP = 33;
        public static final int PAGE_DOWN = 34;
        public static final int HOME = 36;
        public static final int END = 35;
        public static final int KEYPAD_0 = 96;
        public static final int KEYPAD_1 = 97;
        public static final int KEYPAD_2 = 98;
        public static final int KEYPAD_3 = 99;
        public static final int KEYPAD_4 = 100;
        public static final int KEYPAD_5 = 101;
        public static final int KEYPAD_6 = 102;
        public static final int KEYPAD_7 = 103;
        public static final int KEYPAD_8 = 104;
        public static final int KEYPAD_9 = 105;
        public static final int KEYPAD_UP = 224;
        public static final int KEYPAD_DOWN = 225;
        public static final int KEYPAD_LEFT = 226;
        public static final int KEYPAD_RIGHT = 227;
        public static final int PLUS = 521;
        public static final int MINUS = 45;
        public static final int EQUALS = 61;
        public static final int ADD = 107;
        public static final int SUBTRACT = 109;
        public static final int MULTIPLY = 106;
        public static final int DIVIDE = 111;
        public static final int F1 = 112;
        public static final int F2 = 113;
        public static final int F3 = 114;
        public static final int F4 = 115;
        public static final int F5 = 116;
        public static final int F6 = 117;
        public static final int F7 = 118;
        public static final int F8 = 119;
        public static final int F9 = 120;
        public static final int F10 = 121;
        public static final int F11 = 122;
        public static final int F12 = 123;
        public static final int UNDEFINED = 0;
    }

    public static final class KeyStroke {
        private int keyCode = 0;
        private int modifiersLocal = 0;
        public static final String COMMAND_ABBREVIATION = "CMD";

        public KeyStroke(int keyCode, int modifiers) {
            this.keyCode = keyCode;
            this.modifiersLocal = modifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getModifiers() {
            return this.modifiersLocal;
        }

        public boolean equals(Object object) {
            boolean equals = false;
            if (object instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)object;
                equals = this.keyCode == keyStroke.keyCode && this.modifiersLocal == keyStroke.modifiersLocal;
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = this.keyCode << 4 | this.modifiersLocal;
            return hashCode;
        }

        public String toString() {
            int awtModifiers = 0;
            if ((this.modifiersLocal & Modifier.META.getMask()) > 0) {
                awtModifiers |= 0x100;
            }
            if ((this.modifiersLocal & Modifier.CTRL.getMask()) > 0) {
                awtModifiers |= 0x80;
            }
            if ((this.modifiersLocal & Modifier.ALT.getMask()) > 0) {
                awtModifiers |= 0x200;
            }
            if ((this.modifiersLocal & Modifier.SHIFT.getMask()) > 0) {
                awtModifiers |= 0x40;
            }
            if (awtModifiers != 0) {
                return KeyEvent.getModifiersExText(awtModifiers) + Platform.getKeyStrokeModifierSeparator() + KeyEvent.getKeyText(this.keyCode);
            }
            return KeyEvent.getKeyText(this.keyCode);
        }

        public static KeyStroke decode(String value) {
            if (value == null) {
                throw new IllegalArgumentException("value is null.");
            }
            int keyCode = 0;
            int modifiersLocal = 0;
            String[] keys = value.split("-");
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                if (i < n - 1) {
                    String modifierAbbreviation = keys[i].toUpperCase(Locale.ENGLISH);
                    Modifier modifier = modifierAbbreviation.equals(COMMAND_ABBREVIATION) ? Platform.getCommandModifier() : Modifier.valueOf(modifierAbbreviation);
                    modifiersLocal |= modifier.getMask();
                    continue;
                }
                try {
                    Field keyCodeField = KeyCode.class.getField(keys[i].toUpperCase(Locale.ENGLISH));
                    keyCode = (Integer)keyCodeField.get(null);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            return new KeyStroke(keyCode, modifiersLocal);
        }
    }

    public static enum KeyLocation {
        STANDARD,
        LEFT,
        RIGHT,
        KEYPAD;

    }

    public static enum Modifier {
        SHIFT,
        CTRL,
        ALT,
        META;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

