/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Group;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.WTKListenerList;

public class ButtonGroup
implements Group<Button>,
Iterable<Button> {
    private HashSet<Button> buttons = new HashSet();
    private Button selection = null;
    private ButtonGroupListenerList buttonGroupListeners = new ButtonGroupListenerList();

    public boolean add(Button button) {
        boolean added = false;
        if (!this.contains(button)) {
            this.buttons.add((Object)button);
            added = true;
            if (button.isSelected()) {
                if (this.selection == null) {
                    this.selection = button;
                } else {
                    button.setSelected(false);
                }
            }
            button.setButtonGroup(this);
            this.buttonGroupListeners.buttonAdded(this, button);
        }
        return added;
    }

    public boolean remove(Button button) {
        boolean removed = false;
        if (this.contains(button)) {
            this.buttons.remove((Object)button);
            removed = true;
            if (button.isSelected()) {
                this.selection = null;
            }
            button.setButtonGroup(null);
            this.buttonGroupListeners.buttonRemoved(this, button);
        }
        return removed;
    }

    public boolean contains(Button button) {
        return this.buttons.contains((Object)button);
    }

    public Button getSelection() {
        return this.selection;
    }

    public void setSelection(Button selection) {
        if (selection != null && selection.getButtonGroup() != this) {
            throw new IllegalArgumentException();
        }
        Button previousSelection = this.selection;
        if (previousSelection != selection) {
            this.selection = selection;
            if (previousSelection != null) {
                previousSelection.setSelected(false);
            }
            if (selection != null) {
                selection.setSelected(true);
            }
            this.buttonGroupListeners.selectionChanged(this, previousSelection);
        }
    }

    @Override
    public Iterator<Button> iterator() {
        return new ImmutableIterator(this.buttons.iterator());
    }

    public ListenerList<ButtonGroupListener> getButtonGroupListeners() {
        return this.buttonGroupListeners;
    }

    private static class ButtonGroupListenerList
    extends WTKListenerList<ButtonGroupListener>
    implements ButtonGroupListener {
        private ButtonGroupListenerList() {
        }

        @Override
        public void buttonAdded(ButtonGroup buttonGroup, Button button) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonGroupListener listener = (ButtonGroupListener)i$.next();
                listener.buttonAdded(buttonGroup, button);
            }
        }

        @Override
        public void buttonRemoved(ButtonGroup buttonGroup, Button button) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonGroupListener listener = (ButtonGroupListener)i$.next();
                listener.buttonRemoved(buttonGroup, button);
            }
        }

        @Override
        public void selectionChanged(ButtonGroup buttonGroup, Button previousSelection) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonGroupListener listener = (ButtonGroupListener)i$.next();
                listener.selectionChanged(buttonGroup, previousSelection);
            }
        }
    }
}

