/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.controller.api.resources.ServerTableSizeReader;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSizeReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSizeReader.class);
    public static final long DEFAULT_SIZE_WHEN_MISSING_OR_ERROR = -1L;
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;
    private final PinotHelixResourceManager _helixResourceManager;
    private final ControllerMetrics _controllerMetrics;

    public TableSizeReader(Executor executor, HttpClientConnectionManager connectionManager, ControllerMetrics controllerMetrics, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._controllerMetrics = controllerMetrics;
        this._helixResourceManager = helixResourceManager;
    }

    @Nullable
    public TableSizeDetails getTableSizeDetails(@Nonnull String tableName, @Nonnegative int timeoutMsec) throws InvalidConfigException {
        long largestSegmentSizeOnServer;
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name should not be null");
        Preconditions.checkArgument((timeoutMsec > 0 ? 1 : 0) != 0, (Object)"Timeout value must be greater than 0");
        TableConfig offlineTableConfig = ZKMetadataProvider.getOfflineTableConfig(this._helixResourceManager.getPropertyStore(), (String)tableName);
        TableConfig realtimeTableConfig = ZKMetadataProvider.getRealtimeTableConfig(this._helixResourceManager.getPropertyStore(), (String)tableName);
        boolean hasRealtimeTableConfig = realtimeTableConfig != null;
        boolean hasOfflineTableConfig = offlineTableConfig != null;
        boolean isMissingAllRealtimeSegments = false;
        boolean isMissingAllOfflineSegments = false;
        if (!hasRealtimeTableConfig && !hasOfflineTableConfig) {
            return null;
        }
        TableSizeDetails tableSizeDetails = new TableSizeDetails(tableName);
        if (hasRealtimeTableConfig) {
            String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
            tableSizeDetails._realtimeSegments = this.getTableSubtypeSize(realtimeTableName, timeoutMsec);
            tableSizeDetails._reportedSizeInBytes += Math.max(tableSizeDetails._realtimeSegments._reportedSizeInBytes, 0L);
            tableSizeDetails._estimatedSizeInBytes += Math.max(tableSizeDetails._realtimeSegments._estimatedSizeInBytes, 0L);
            tableSizeDetails._reportedSizePerReplicaInBytes += Math.max(tableSizeDetails._realtimeSegments._reportedSizePerReplicaInBytes, 0L);
            isMissingAllRealtimeSegments = tableSizeDetails._realtimeSegments._missingSegments == tableSizeDetails._realtimeSegments._segments.size();
            this._controllerMetrics.setValueOfTableGauge(realtimeTableName, (AbstractMetrics.Gauge)ControllerGauge.TABLE_TOTAL_SIZE_ON_SERVER, tableSizeDetails._realtimeSegments._estimatedSizeInBytes);
            this._controllerMetrics.setValueOfTableGauge(realtimeTableName, (AbstractMetrics.Gauge)ControllerGauge.TABLE_SIZE_PER_REPLICA_ON_SERVER, tableSizeDetails._realtimeSegments._estimatedSizeInBytes / (long)this._helixResourceManager.getNumReplicas(realtimeTableConfig));
            largestSegmentSizeOnServer = -1L;
            for (SegmentSizeDetails segmentSizeDetail : tableSizeDetails._realtimeSegments._segments.values()) {
                for (SegmentSizeInfo segmentSizeInfo : segmentSizeDetail._serverInfo.values()) {
                    largestSegmentSizeOnServer = Math.max(largestSegmentSizeOnServer, segmentSizeInfo.getDiskSizeInBytes());
                }
            }
            if (largestSegmentSizeOnServer != -1L) {
                this._controllerMetrics.setValueOfTableGauge(realtimeTableName, (AbstractMetrics.Gauge)ControllerGauge.LARGEST_SEGMENT_SIZE_ON_SERVER, largestSegmentSizeOnServer);
            }
        }
        if (hasOfflineTableConfig) {
            String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
            tableSizeDetails._offlineSegments = this.getTableSubtypeSize(offlineTableName, timeoutMsec);
            tableSizeDetails._reportedSizeInBytes += Math.max(tableSizeDetails._offlineSegments._reportedSizeInBytes, 0L);
            tableSizeDetails._estimatedSizeInBytes += Math.max(tableSizeDetails._offlineSegments._estimatedSizeInBytes, 0L);
            tableSizeDetails._reportedSizePerReplicaInBytes += Math.max(tableSizeDetails._offlineSegments._reportedSizePerReplicaInBytes, 0L);
            isMissingAllOfflineSegments = tableSizeDetails._offlineSegments._missingSegments == tableSizeDetails._offlineSegments._segments.size();
            this._controllerMetrics.setValueOfTableGauge(offlineTableName, (AbstractMetrics.Gauge)ControllerGauge.TABLE_TOTAL_SIZE_ON_SERVER, tableSizeDetails._offlineSegments._estimatedSizeInBytes);
            this._controllerMetrics.setValueOfTableGauge(offlineTableName, (AbstractMetrics.Gauge)ControllerGauge.TABLE_SIZE_PER_REPLICA_ON_SERVER, tableSizeDetails._offlineSegments._estimatedSizeInBytes / (long)this._helixResourceManager.getNumReplicas(offlineTableConfig));
            largestSegmentSizeOnServer = -1L;
            for (SegmentSizeDetails segmentSizeDetail : tableSizeDetails._offlineSegments._segments.values()) {
                for (SegmentSizeInfo segmentSizeInfo : segmentSizeDetail._serverInfo.values()) {
                    largestSegmentSizeOnServer = Math.max(largestSegmentSizeOnServer, segmentSizeInfo.getDiskSizeInBytes());
                }
            }
            if (largestSegmentSizeOnServer != -1L) {
                this._controllerMetrics.setValueOfTableGauge(offlineTableName, (AbstractMetrics.Gauge)ControllerGauge.LARGEST_SEGMENT_SIZE_ON_SERVER, largestSegmentSizeOnServer);
            }
        }
        if (hasRealtimeTableConfig && hasOfflineTableConfig && isMissingAllRealtimeSegments && isMissingAllOfflineSegments || hasOfflineTableConfig && !hasRealtimeTableConfig && isMissingAllOfflineSegments || hasRealtimeTableConfig && !hasOfflineTableConfig && isMissingAllRealtimeSegments) {
            tableSizeDetails._reportedSizeInBytes = -1L;
            tableSizeDetails._estimatedSizeInBytes = -1L;
            tableSizeDetails._reportedSizePerReplicaInBytes = -1L;
        }
        return tableSizeDetails;
    }

    public TableSubTypeSizeDetails getTableSubtypeSize(String tableNameWithType, int timeoutMs) throws InvalidConfigException {
        Map<String, List<String>> serverToSegmentsMap = this._helixResourceManager.getServerToSegmentsMap(tableNameWithType);
        ServerTableSizeReader serverTableSizeReader = new ServerTableSizeReader(this._executor, this._connectionManager);
        BiMap<String, String> endpoints = this._helixResourceManager.getDataInstanceAdminEndpoints(serverToSegmentsMap.keySet());
        Map<String, List<SegmentSizeInfo>> serverToSegmentSizeInfoListMap = serverTableSizeReader.getSegmentSizeInfoFromServers(endpoints, tableNameWithType, timeoutMs);
        TableSubTypeSizeDetails subTypeSizeDetails = new TableSubTypeSizeDetails();
        Map<String, SegmentSizeDetails> segmentToSizeDetailsMap = subTypeSizeDetails._segments;
        for (Map.Entry<String, List<String>> entry : serverToSegmentsMap.entrySet()) {
            SegmentSizeInfo segmentSizeInfo22;
            String string = entry.getKey();
            List<SegmentSizeInfo> segmentSizeInfoList = serverToSegmentSizeInfoListMap.get(string);
            if (segmentSizeInfoList != null) {
                for (SegmentSizeInfo segmentSizeInfo22 : segmentSizeInfoList) {
                    SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segmentSizeInfo22.getSegmentName(), k -> new SegmentSizeDetails());
                    segmentSizeDetails._serverInfo.put(string, segmentSizeInfo22);
                }
                continue;
            }
            List segments = (List)entry.getValue();
            segmentSizeInfo22 = segments.iterator();
            while (segmentSizeInfo22.hasNext()) {
                String segment = (String)segmentSizeInfo22.next();
                SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segment, k -> new SegmentSizeDetails());
                segmentSizeDetails._serverInfo.put(string, new SegmentSizeInfo(segment, -1L));
            }
        }
        ArrayList<String> missingSegments = new ArrayList<String>();
        for (Map.Entry entry : segmentToSizeDetailsMap.entrySet()) {
            String segment = (String)entry.getKey();
            SegmentSizeDetails sizeDetails = (SegmentSizeDetails)entry.getValue();
            sizeDetails._maxReportedSizePerReplicaInBytes = -1L;
            int errors = 0;
            for (SegmentSizeInfo sizeInfo : sizeDetails._serverInfo.values()) {
                if (sizeInfo.getDiskSizeInBytes() != -1L) {
                    sizeDetails._reportedSizeInBytes += sizeInfo.getDiskSizeInBytes();
                    sizeDetails._maxReportedSizePerReplicaInBytes = Math.max(sizeDetails._maxReportedSizePerReplicaInBytes, sizeInfo.getDiskSizeInBytes());
                    continue;
                }
                ++errors;
            }
            if (errors != sizeDetails._serverInfo.size()) {
                sizeDetails._estimatedSizeInBytes = sizeDetails._reportedSizeInBytes + (long)errors * sizeDetails._maxReportedSizePerReplicaInBytes;
                subTypeSizeDetails._reportedSizeInBytes += sizeDetails._reportedSizeInBytes;
                subTypeSizeDetails._estimatedSizeInBytes += sizeDetails._estimatedSizeInBytes;
                subTypeSizeDetails._reportedSizePerReplicaInBytes += sizeDetails._maxReportedSizePerReplicaInBytes;
                continue;
            }
            missingSegments.add(segment);
            sizeDetails._maxReportedSizePerReplicaInBytes = -1L;
            sizeDetails._reportedSizeInBytes = -1L;
            sizeDetails._estimatedSizeInBytes = -1L;
            ++subTypeSizeDetails._missingSegments;
        }
        if (subTypeSizeDetails._missingSegments > 0) {
            int numSegments = segmentToSizeDetailsMap.size();
            int n = subTypeSizeDetails._missingSegments * 100 / numSegments;
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, (long)n);
            if (subTypeSizeDetails._missingSegments == numSegments) {
                LOGGER.warn("Failed to get size report for all {} segments of table: {}", (Object)numSegments, (Object)tableNameWithType);
                subTypeSizeDetails._reportedSizeInBytes = -1L;
                subTypeSizeDetails._estimatedSizeInBytes = -1L;
                subTypeSizeDetails._reportedSizePerReplicaInBytes = -1L;
            } else {
                LOGGER.warn("Missing size report for {} out of {} segments for table {}", new Object[]{subTypeSizeDetails._missingSegments, numSegments, tableNameWithType});
            }
        } else {
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, 0L);
        }
        return subTypeSizeDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SegmentSizeDetails {
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="maxReportedSizePerReplicaInBytes")
        public long _maxReportedSizePerReplicaInBytes = 0L;
        @JsonProperty(value="serverInfo")
        public Map<String, SegmentSizeInfo> _serverInfo = new HashMap<String, SegmentSizeInfo>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSubTypeSizeDetails {
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="missingSegments")
        public int _missingSegments = 0;
        @JsonProperty(value="reportedSizePerReplicaInBytes")
        public long _reportedSizePerReplicaInBytes = 0L;
        @JsonProperty(value="segments")
        public Map<String, SegmentSizeDetails> _segments = new HashMap<String, SegmentSizeDetails>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSizeDetails {
        @JsonProperty(value="tableName")
        public String _tableName;
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="reportedSizePerReplicaInBytes")
        public long _reportedSizePerReplicaInBytes = 0L;
        @JsonProperty(value="offlineSegments")
        public TableSubTypeSizeDetails _offlineSegments;
        @JsonProperty(value="realtimeSegments")
        public TableSubTypeSizeDetails _realtimeSegments;

        public TableSizeDetails(String tableName) {
            this._tableName = tableName;
        }
    }
}

