/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.impl.RangeIndexRule;
import org.apache.pinot.controller.recommender.rules.io.configs.IndexConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIndexRule
extends AbstractRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexRule.class);

    public JsonIndexRule(InputManager input, ConfigManager output) {
        super(input, output);
    }

    @Override
    public void run() throws InvalidInputException {
        int numColumns = this._input.getNumCols();
        IndexConfig indexConfig = this._output.getIndexConfig();
        for (int i = 0; i < numColumns; ++i) {
            String columnName = this._input.intToColName(i);
            FieldSpec.DataType columnType = this._input.getFieldType(columnName);
            if (columnType != FieldSpec.DataType.JSON) continue;
            LOGGER.info("Recommending NoDictionary and JsonIndex on JSON column {}.", (Object)columnName);
            indexConfig.getJsonIndexColumns().add(columnName);
            indexConfig.getNoDictionaryColumns().add(columnName);
        }
    }
}

