/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.params.BloomFilterRuleParams;
import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterRule
extends AbstractRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterRule.class);
    private final BloomFilterRuleParams _params;
    private static final Set<FieldSpec.DataType> COMPATIBLE_DATA_TYPES = new HashSet<FieldSpec.DataType>(Arrays.asList(FieldSpec.DataType.INT, FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE, FieldSpec.DataType.STRING, FieldSpec.DataType.BYTES));

    public BloomFilterRule(InputManager input, ConfigManager output) {
        super(input, output);
        this._params = input.getBloomFilterRuleParams();
    }

    @Override
    public void run() {
        int numCols = this._input.getNumCols();
        double[] weights = new double[numCols];
        AtomicDouble totalWeight = new AtomicDouble(0.0);
        this._input.getParsedQueries().forEach(query -> {
            Double weight = this._input.getQueryWeight((String)query);
            totalWeight.addAndGet(weight.doubleValue());
            FixedLenBitset fixedLenBitset = this.parseQuery(this._input.getQueryContext((String)query));
            LOGGER.debug("fixedLenBitset {}", (Object)fixedLenBitset);
            for (Integer i : fixedLenBitset.getOffsets()) {
                int n = i;
                weights[n] = weights[n] + weight;
            }
        });
        LOGGER.debug("Weight: {}, Total {}", (Object)weights, (Object)totalWeight);
        for (int i = 0; i < numCols; ++i) {
            String dimName = this._input.intToColName(i);
            FieldSpec.DataType columnType = this._input.getFieldType(dimName);
            if (!COMPATIBLE_DATA_TYPES.contains(columnType) || !(weights[i] / totalWeight.get() > this._params._thresholdMinPercentEqBloomfilter) || !(this._input.getCardinality(dimName) < (double)this._params._thresholdMaxCardinalityBloomfilter.longValue())) continue;
            this._output.getIndexConfig().getBloomFilterColumns().add(dimName);
        }
    }

    public FixedLenBitset parseQuery(QueryContext queryContext) {
        if (queryContext.getFilter() == null) {
            return FixedLenBitset.IMMUTABLE_EMPTY_SET;
        }
        LOGGER.trace("Parsing Where Clause: {}", (Object)queryContext.getFilter().toString());
        return this.parsePredicateList(queryContext.getFilter());
    }

    private FixedLenBitset parsePredicateList(FilterContext filterContext) {
        FixedLenBitset ret = this.mutableEmptySet();
        List children = filterContext.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                FixedLenBitset childResult = this.parsePredicateList(child);
                ret.union(childResult);
            }
        } else {
            ExpressionContext lhs = filterContext.getPredicate().getLhs();
            String colName = lhs.toString();
            if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                LOGGER.trace("Skipping the function {}", (Object)colName);
            } else if (filterContext.getPredicate().getType() == Predicate.Type.EQ || filterContext.getPredicate().getType() == Predicate.Type.IN) {
                ret.add(this._input.colNameToInt(colName));
            }
        }
        return ret;
    }

    private FixedLenBitset mutableEmptySet() {
        return new FixedLenBitset(this._input.getNumCols());
    }
}

