/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerTimer;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronJobScheduleJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronJobScheduleJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PinotTaskManager pinotTaskManager = (PinotTaskManager)((Object)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"PinotTaskManager"));
        LeadControllerManager leadControllerManager = (LeadControllerManager)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"LeadControllerManager");
        Boolean skipLateCronSchedule = (Boolean)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"SkipLateCronSchedule");
        int maxDelayInSeconds = (Integer)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"MaxCronScheduleDelayInSeconds");
        String table = jobExecutionContext.getJobDetail().getKey().getName();
        String taskType = jobExecutionContext.getJobDetail().getKey().getGroup();
        pinotTaskManager.getControllerMetrics().addMeteredTableValue(PinotTaskManager.getCronJobName(table, taskType), (AbstractMetrics.Meter)ControllerMeter.CRON_SCHEDULER_JOB_TRIGGERED, 1L);
        if (leadControllerManager.isLeaderForTable(table)) {
            Date fireTime = jobExecutionContext.getFireTime();
            LOGGER.info("Execute CronJob: table - {}, task - {} at {}", new Object[]{table, taskType, fireTime});
            Date scheduledFireTime = jobExecutionContext.getScheduledFireTime();
            if (skipLateCronSchedule.booleanValue() && this.isCronScheduleLate(fireTime, scheduledFireTime, maxDelayInSeconds)) {
                LOGGER.warn("Skip late CronJob: table - {}, task - {} fired at {} but expected at {} with allowed delayInSeconds: {}", new Object[]{table, taskType, fireTime, scheduledFireTime, maxDelayInSeconds});
                pinotTaskManager.getControllerMetrics().addMeteredTableValue(PinotTaskManager.getCronJobName(table, taskType), (AbstractMetrics.Meter)ControllerMeter.CRON_SCHEDULER_JOB_SKIPPED, 1L);
                return;
            }
            long jobStartTime = System.currentTimeMillis();
            pinotTaskManager.scheduleTask(taskType, table);
            LOGGER.info("Finished CronJob: table - {}, task - {}, next runtime is {}", new Object[]{table, taskType, jobExecutionContext.getNextFireTime()});
            pinotTaskManager.getControllerMetrics().addTimedTableValue(PinotTaskManager.getCronJobName(table, taskType), (AbstractMetrics.Timer)ControllerTimer.CRON_SCHEDULER_JOB_EXECUTION_TIME_MS, System.currentTimeMillis() - jobStartTime, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.info("Not Lead, skip processing CronJob: table - {}, task - {}", (Object)table, (Object)taskType);
        }
    }

    private boolean isCronScheduleLate(Date fireTime, Date scheduledFireTime, long maxDelayInSeconds) {
        return fireTime.getTime() - scheduledFireTime.getTime() > maxDelayInSeconds * 1000L;
    }
}

