/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.helix.model.IdealState;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.core.periodictask.BasePeriodicTask;
import org.apache.pinot.spi.utils.InstanceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleInstancesCleanupTask
extends BasePeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaleInstancesCleanupTask.class);
    private static final String TASK_NAME = "StaleInstancesCleanupTask";
    protected final PinotHelixResourceManager _pinotHelixResourceManager;
    protected final LeadControllerManager _leadControllerManager;
    protected final ControllerMetrics _controllerMetrics;
    private final long _staleInstancesCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds;

    public StaleInstancesCleanupTask(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        super(TASK_NAME, (long)controllerConf.getStaleInstancesCleanupTaskFrequencyInSeconds(), controllerConf.getStaleInstanceCleanupTaskInitialDelaySeconds());
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._leadControllerManager = leadControllerManager;
        this._controllerMetrics = controllerMetrics;
        this._staleInstancesCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds = (long)controllerConf.getStaleInstancesCleanupTaskInstancesRetentionInSeconds() * 1000L;
    }

    protected void runTask(Properties periodicTaskProperties) {
        if (!this._leadControllerManager.isLeaderForTable(TASK_NAME)) {
            return;
        }
        ArrayList<String> offlineInstances = new ArrayList<String>(this._pinotHelixResourceManager.getAllInstances());
        offlineInstances.removeAll(this._pinotHelixResourceManager.getOnlineInstanceList());
        Set<String> serverInstancesInUse = this.getServerInstancesInUse();
        Set<String> brokerInstancesInUse = this.getBrokerInstancesInUse();
        for (String offlineInstance : offlineInstances) {
            PinotResourceManagerResponse response;
            if (InstanceTypeUtils.isMinion((String)offlineInstance)) {
                if (!this._pinotHelixResourceManager.isInstanceOfflineFor(offlineInstance, this._staleInstancesCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds)) continue;
                LOGGER.info("Dropping minion instance: {}", (Object)offlineInstance);
                response = this._pinotHelixResourceManager.dropInstance(offlineInstance);
                if (!response.isSuccessful()) continue;
                this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.DROPPED_MINION_INSTANCES, 1L);
                continue;
            }
            if (InstanceTypeUtils.isBroker((String)offlineInstance) && !brokerInstancesInUse.contains(offlineInstance)) {
                if (!this._pinotHelixResourceManager.isInstanceOfflineFor(offlineInstance, this._staleInstancesCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds)) continue;
                LOGGER.info("Dropping broker instance: {}", (Object)offlineInstance);
                response = this._pinotHelixResourceManager.dropInstance(offlineInstance);
                if (!response.isSuccessful()) continue;
                this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.DROPPED_BROKER_INSTANCES, 1L);
                continue;
            }
            if (!InstanceTypeUtils.isServer((String)offlineInstance) || serverInstancesInUse.contains(offlineInstance) || !this._pinotHelixResourceManager.isInstanceOfflineFor(offlineInstance, this._staleInstancesCleanupTaskMinOfflineTimeBeforeDeletionInMilliseconds)) continue;
            LOGGER.info("Dropping server instance: {}", (Object)offlineInstance);
            response = this._pinotHelixResourceManager.dropInstance(offlineInstance);
            if (!response.isSuccessful()) continue;
            this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.DROPPED_SERVER_INSTANCES, 1L);
        }
    }

    private Set<String> getBrokerInstancesInUse() {
        HashSet<String> brokerInstancesInUse = new HashSet<String>();
        IdealState brokerResource = this._pinotHelixResourceManager.getHelixAdmin().getResourceIdealState(this._pinotHelixResourceManager.getHelixClusterName(), "brokerResource");
        brokerResource.getPartitionSet().forEach(table -> brokerInstancesInUse.addAll(brokerResource.getInstanceSet(table)));
        return brokerInstancesInUse;
    }

    private Set<String> getServerInstancesInUse() {
        HashSet<String> serverInstancesInUse = new HashSet<String>();
        this._pinotHelixResourceManager.getAllTables().forEach(tableName -> serverInstancesInUse.addAll(Optional.ofNullable(this._pinotHelixResourceManager.getTableIdealState((String)tableName)).map(is -> is.getInstanceSet(tableName)).orElse(Collections.emptySet())));
        return serverInstancesInUse;
    }
}

