/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment.strategy;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancedNumSegmentAssignmentStrategy
implements SegmentAssignmentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(BalancedNumSegmentAssignmentStrategy.class);
    private String _tableNameWithType;
    private int _replication;

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        this._tableNameWithType = tableConfig.getTableName();
        SegmentsValidationAndRetentionConfig validationAndRetentionConfig = tableConfig.getValidationConfig();
        Preconditions.checkState((validationAndRetentionConfig != null ? 1 : 0) != 0, (Object)"Validation Config is null");
        this._replication = tableConfig.getReplication();
        LOGGER.info("Initialized BalancedNumSegmentAssignmentStrategy for table: {} with replication: {}", (Object)this._tableNameWithType, (Object)this._replication);
    }

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        this.validateSegmentAssignmentStrategy(instancePartitions);
        return SegmentAssignmentUtils.assignSegmentWithoutReplicaGroup(currentAssignment, instancePartitions, this._replication);
    }

    @Override
    public Map<String, Map<String, String>> reassignSegments(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        this.validateSegmentAssignmentStrategy(instancePartitions);
        List<String> instances = SegmentAssignmentUtils.getInstancesForNonReplicaGroupBasedAssignment(instancePartitions, this._replication);
        Map<String, Map<String, String>> newAssignment = SegmentAssignmentUtils.rebalanceTableWithHelixAutoRebalanceStrategy(currentAssignment, instances, this._replication);
        return newAssignment;
    }

    private void validateSegmentAssignmentStrategy(InstancePartitions instancePartitions) {
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        int numPartitions = instancePartitions.getNumPartitions();
        Preconditions.checkState((numReplicaGroups == 1 ? 1 : 0) != 0, (Object)"Replica groups should be 1 in order to use BalanceNumSegmentAssignmentStrategy");
        Preconditions.checkState((numPartitions == 1 ? 1 : 0) != 0, (Object)"Replica groups should be 1 in order to use BalanceNumSegmentAssignmentStrategy");
    }
}

