/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.utils.Pairs;

public class SegmentAssignmentUtils {
    private SegmentAssignmentUtils() {
    }

    public static int[] getNumSegmentsAssignedPerInstance(Map<String, Map<String, String>> segmentAssignment, List<String> instances) {
        int[] numSegmentsPerInstance = new int[instances.size()];
        Map<String, Integer> instanceNameToIdMap = SegmentAssignmentUtils.getInstanceNameToIdMap(instances);
        for (Map<String, String> instanceStateMep : segmentAssignment.values()) {
            for (String instanceName : instanceStateMep.keySet()) {
                Integer instanceId = instanceNameToIdMap.get(instanceName);
                if (instanceId == null) continue;
                int n = instanceId;
                numSegmentsPerInstance[n] = numSegmentsPerInstance[n] + 1;
            }
        }
        return numSegmentsPerInstance;
    }

    private static Map<String, Integer> getInstanceNameToIdMap(List<String> instances) {
        int numInstances = instances.size();
        HashMap<String, Integer> instanceNameToIdMap = new HashMap<String, Integer>();
        for (int i = 0; i < numInstances; ++i) {
            instanceNameToIdMap.put(instances.get(i), i);
        }
        return instanceNameToIdMap;
    }

    public static List<String> getInstancesForNonReplicaGroupBasedAssignment(InstancePartitions instancePartitions, int replication) {
        Preconditions.checkState((instancePartitions.getNumReplicaGroups() == 1 && instancePartitions.getNumPartitions() == 1 ? 1 : 0) != 0, (String)"Instance partitions: %s should contain 1 replica and 1 partition for non-replica-group based assignment", (Object)instancePartitions.getInstancePartitionsName());
        List instances = instancePartitions.getInstances(0, 0);
        int numInstances = instances.size();
        Preconditions.checkState((numInstances >= replication ? 1 : 0) != 0, (String)"There are less instances: %s in instance partitions: %s than the table replication: %s", (Object)numInstances, (Object)instancePartitions.getInstancePartitionsName(), (Object)replication);
        return instances;
    }

    public static List<String> assignSegmentWithoutReplicaGroup(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, int replication) {
        List<String> instances = SegmentAssignmentUtils.getInstancesForNonReplicaGroupBasedAssignment(instancePartitions, replication);
        int[] numSegmentsAssignedPerInstance = SegmentAssignmentUtils.getNumSegmentsAssignedPerInstance(currentAssignment, instances);
        int numInstances = numSegmentsAssignedPerInstance.length;
        PriorityQueue<Pairs.IntPair> heap = new PriorityQueue<Pairs.IntPair>(numInstances, Pairs.intPairComparator());
        for (int instanceId = 0; instanceId < numInstances; ++instanceId) {
            heap.add(new Pairs.IntPair(numSegmentsAssignedPerInstance[instanceId], instanceId));
        }
        ArrayList<String> instancesAssigned = new ArrayList<String>(replication);
        for (int i = 0; i < replication; ++i) {
            instancesAssigned.add(instances.get(((Pairs.IntPair)heap.remove()).getRight()));
        }
        return instancesAssigned;
    }

    public static List<String> assignSegmentWithReplicaGroup(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, int partitionId) {
        List instances = instancePartitions.getInstances(partitionId, 0);
        int[] numSegmentsAssignedPerInstance = SegmentAssignmentUtils.getNumSegmentsAssignedPerInstance(currentAssignment, instances);
        int minNumSegmentsAssigned = numSegmentsAssignedPerInstance[0];
        int instanceIdWithLeastSegmentsAssigned = 0;
        int numInstances = numSegmentsAssignedPerInstance.length;
        for (int instanceId = 1; instanceId < numInstances; ++instanceId) {
            if (numSegmentsAssignedPerInstance[instanceId] >= minNumSegmentsAssigned) continue;
            minNumSegmentsAssigned = numSegmentsAssignedPerInstance[instanceId];
            instanceIdWithLeastSegmentsAssigned = instanceId;
        }
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        ArrayList<String> instancesAssigned = new ArrayList<String>(numReplicaGroups);
        for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
            instancesAssigned.add((String)instancePartitions.getInstances(partitionId, replicaGroupId).get(instanceIdWithLeastSegmentsAssigned));
        }
        return instancesAssigned;
    }

    public static Map<String, Map<String, String>> rebalanceTableWithHelixAutoRebalanceStrategy(Map<String, Map<String, String>> currentAssignment, List<String> instances, int replication) {
        LinkedHashMap<String, Integer> states = new LinkedHashMap<String, Integer>();
        states.put("ONLINE", replication);
        AutoRebalanceStrategy autoRebalanceStrategy = new AutoRebalanceStrategy(null, new ArrayList<String>(currentAssignment.keySet()), states);
        TreeMap<String, TreeMap<String, String>> currentAssignmentCopy = new TreeMap<String, TreeMap<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : currentAssignment.entrySet()) {
            String segmentName = entry.getKey();
            Map<String, String> instanceStateMap = entry.getValue();
            currentAssignmentCopy.put(segmentName, new TreeMap<String, String>(instanceStateMap));
        }
        return autoRebalanceStrategy.computePartitionAssignment(instances, instances, currentAssignmentCopy, null).getMapFields();
    }

    public static Map<String, Map<String, String>> rebalanceReplicaGroupBasedTable(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, Map<Integer, List<String>> instancePartitionIdToSegmentsMap) {
        TreeMap<String, Map<String, String>> newAssignment = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<Integer, List<String>> entry : instancePartitionIdToSegmentsMap.entrySet()) {
            int instancePartitionId = entry.getKey();
            List<String> segments = entry.getValue();
            SegmentAssignmentUtils.rebalanceReplicaGroupBasedPartition(currentAssignment, instancePartitions, instancePartitionId, segments, newAssignment);
        }
        return newAssignment;
    }

    public static void rebalanceReplicaGroupBasedPartition(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, int partitionId, List<String> segments, Map<String, Map<String, String>> newAssignment) {
        List instances = instancePartitions.getInstances(partitionId, 0);
        Map<String, Integer> instanceNameToIdMap = SegmentAssignmentUtils.getInstanceNameToIdMap(instances);
        int numInstances = instances.size();
        int numSegments = segments.size();
        int targetNumSegmentsPerInstance = (numSegments + numInstances - 1) / numInstances;
        int[] numSegmentsAssignedPerInstance = new int[numInstances];
        ArrayList<String> segmentsNotAssigned = new ArrayList<String>();
        for (String segmentName : segments) {
            boolean segmentAssigned = false;
            for (String instanceName : currentAssignment.get(segmentName).keySet()) {
                Integer instanceId = instanceNameToIdMap.get(instanceName);
                if (instanceId == null || numSegmentsAssignedPerInstance[instanceId] >= targetNumSegmentsPerInstance) continue;
                newAssignment.put(segmentName, SegmentAssignmentUtils.getReplicaGroupBasedInstanceStateMap(instancePartitions, partitionId, instanceId));
                int n = instanceId;
                numSegmentsAssignedPerInstance[n] = numSegmentsAssignedPerInstance[n] + 1;
                segmentAssigned = true;
                break;
            }
            if (segmentAssigned) continue;
            segmentsNotAssigned.add(segmentName);
        }
        PriorityQueue<Pairs.IntPair> heap = new PriorityQueue<Pairs.IntPair>(numInstances, Pairs.intPairComparator());
        for (int instanceId = 0; instanceId < numInstances; ++instanceId) {
            heap.add(new Pairs.IntPair(numSegmentsAssignedPerInstance[instanceId], instanceId));
        }
        for (String segmentName : segmentsNotAssigned) {
            Pairs.IntPair intPair = (Pairs.IntPair)heap.remove();
            int instanceId = intPair.getRight();
            newAssignment.put(segmentName, SegmentAssignmentUtils.getReplicaGroupBasedInstanceStateMap(instancePartitions, partitionId, instanceId));
            intPair.setLeft(intPair.getLeft() + 1);
            heap.add(intPair);
        }
    }

    private static Map<String, String> getReplicaGroupBasedInstanceStateMap(InstancePartitions instancePartitions, int partitionId, int instanceId) {
        TreeMap<String, String> instanceStateMap = new TreeMap<String, String>();
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
            instanceStateMap.put((String)instancePartitions.getInstances(partitionId, replicaGroupId).get(instanceId), "ONLINE");
        }
        return instanceStateMap;
    }

    public static Map<String, String> getInstanceStateMap(Collection<String> instances, String state) {
        TreeMap<String, String> instanceStateMap = new TreeMap<String, String>();
        for (String instanceName : instances) {
            instanceStateMap.put(instanceName, state);
        }
        return instanceStateMap;
    }

    public static Map<String, Integer> getNumSegmentsToBeMovedPerInstance(Map<String, Map<String, String>> oldAssignment, Map<String, Map<String, String>> newAssignment) {
        TreeMap<String, Integer> numSegmentsToBeMovedPerInstance = new TreeMap<String, Integer>();
        for (Map.Entry<String, Map<String, String>> entry : newAssignment.entrySet()) {
            String segmentName = entry.getKey();
            Set<String> newInstancesAssigned = entry.getValue().keySet();
            Set<String> oldInstancesAssigned = oldAssignment.get(segmentName).keySet();
            for (String instanceName : newInstancesAssigned) {
                if (oldInstancesAssigned.contains(instanceName)) continue;
                numSegmentsToBeMovedPerInstance.merge(instanceName, 1, Integer::sum);
            }
        }
        return numSegmentsToBeMovedPerInstance;
    }

    public static Set<String> getSegmentsToMove(Map<String, Map<String, String>> oldAssignment, Map<String, Map<String, String>> newAssignment) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> entry : newAssignment.entrySet()) {
            String segmentName = entry.getKey();
            if (entry.getValue().equals(oldAssignment.get(segmentName))) continue;
            result.add(segmentName);
        }
        return result;
    }

    public static int getOfflineSegmentPartitionId(String segmentName, String offlineTableName, HelixManager helixManager, @Nullable String partitionColumn) {
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)helixManager.getHelixPropertyStore(), (String)offlineTableName, (String)segmentName);
        Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"Failed to find segment ZK metadata for segment: %s of table: %s", (Object)segmentName, (Object)offlineTableName);
        return SegmentAssignmentUtils.getPartitionId(segmentZKMetadata, offlineTableName, partitionColumn);
    }

    private static int getPartitionId(SegmentZKMetadata segmentZKMetadata, String offlineTableName, @Nullable String partitionColumn) {
        String segmentName = segmentZKMetadata.getSegmentName();
        ColumnPartitionMetadata partitionMetadata = (ColumnPartitionMetadata)segmentZKMetadata.getPartitionMetadata().getColumnPartitionMap().get(partitionColumn);
        Preconditions.checkState((partitionMetadata != null ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s does not contain partition metadata for column: %s", (Object)segmentName, (Object)offlineTableName, (Object)partitionColumn);
        Set partitions = partitionMetadata.getPartitions();
        Preconditions.checkState((partitions.size() == 1 ? 1 : 0) != 0, (String)"Segment ZK metadata for segment: %s of table: %s contains multiple partitions for column: %s", (Object)segmentName, (Object)offlineTableName, (Object)partitionColumn);
        return (Integer)partitions.iterator().next();
    }

    public static Map<Integer, List<String>> getOfflineInstancePartitionIdToSegmentsMap(Set<String> segments, int numInstancePartitions, String offlineTableName, HelixManager helixManager, @Nullable String partitionColumn) {
        List segmentsZKMetadata = ZKMetadataProvider.getSegmentsZKMetadata((ZkHelixPropertyStore)helixManager.getHelixPropertyStore(), (String)offlineTableName);
        HashMap<Integer, List<String>> instancePartitionIdToSegmentsMap = new HashMap<Integer, List<String>>();
        HashSet<String> segmentsWithoutZKMetadata = new HashSet<String>(segments);
        for (SegmentZKMetadata segmentZKMetadata : segmentsZKMetadata) {
            String segmentName = segmentZKMetadata.getSegmentName();
            if (!segmentsWithoutZKMetadata.remove(segmentName)) continue;
            int partitionId = SegmentAssignmentUtils.getPartitionId(segmentZKMetadata, offlineTableName, partitionColumn);
            int instancePartitionId = partitionId % numInstancePartitions;
            instancePartitionIdToSegmentsMap.computeIfAbsent(instancePartitionId, k -> new ArrayList()).add(segmentName);
        }
        Preconditions.checkState((boolean)segmentsWithoutZKMetadata.isEmpty(), (String)"Failed to find ZK metadata for segments: %s", segmentsWithoutZKMetadata);
        return instancePartitionIdToSegmentsMap;
    }

    public static int getRealtimeSegmentPartitionId(String segmentName, String realtimeTableName, HelixManager helixManager, @Nullable String partitionColumn) {
        Integer segmentPartitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)realtimeTableName, (HelixManager)helixManager, (String)partitionColumn);
        if (segmentPartitionId == null) {
            segmentPartitionId = Math.abs(segmentName.hashCode() % 10000);
        }
        return segmentPartitionId;
    }

    public static Map<Integer, List<String>> getRealtimeInstancePartitionIdToSegmentsMap(Set<String> segments, int numInstancePartitions, String realtimeTableName, HelixManager helixManager, @Nullable String partitionColumn) {
        HashMap<Integer, List<String>> instancePartitionIdToSegmentsMap = new HashMap<Integer, List<String>>();
        for (String segmentName : segments) {
            int instancePartitionId = SegmentAssignmentUtils.getRealtimeSegmentPartitionId(segmentName, realtimeTableName, helixManager, partitionColumn) % numInstancePartitions;
            instancePartitionIdToSegmentsMap.computeIfAbsent(instancePartitionId, k -> new ArrayList()).add(segmentName);
        }
        return instancePartitionIdToSegmentsMap;
    }

    static class TierSegmentAssignment {
        private final Map<String, Map<String, Map<String, String>>> _tierNameToSegmentAssignmentMap = new TreeMap<String, Map<String, Map<String, String>>>();
        private final Map<String, Map<String, String>> _nonTierSegmentAssignment = new TreeMap<String, Map<String, String>>();

        TierSegmentAssignment(String tableNameWithType, List<Tier> sortedTiers, Map<String, Map<String, String>> segmentAssignment) {
            sortedTiers.forEach(t -> this._tierNameToSegmentAssignmentMap.put(t.getName(), new TreeMap()));
            for (Map.Entry<String, Map<String, String>> entry : segmentAssignment.entrySet()) {
                String segmentName = entry.getKey();
                Map<String, String> instanceStateMap = entry.getValue();
                boolean selected = false;
                if (instanceStateMap.containsValue("ONLINE")) {
                    for (Tier tier : sortedTiers) {
                        if (!tier.getSegmentSelector().selectSegment(tableNameWithType, segmentName)) continue;
                        this._tierNameToSegmentAssignmentMap.get(tier.getName()).put(segmentName, instanceStateMap);
                        selected = true;
                        break;
                    }
                }
                if (selected) continue;
                this._nonTierSegmentAssignment.put(segmentName, instanceStateMap);
            }
            this._tierNameToSegmentAssignmentMap.entrySet().removeIf(e -> ((Map)e.getValue()).isEmpty());
        }

        public Map<String, Map<String, Map<String, String>>> getTierNameToSegmentAssignmentMap() {
            return this._tierNameToSegmentAssignmentMap;
        }

        public Map<String, Map<String, String>> getNonTierSegmentAssignment() {
            return this._nonTierSegmentAssignment;
        }
    }

    static class CompletedConsumingOfflineSegmentAssignment {
        private final Map<String, Map<String, String>> _completedSegmentAssignment = new TreeMap<String, Map<String, String>>();
        private final Map<String, Map<String, String>> _consumingSegmentAssignment = new TreeMap<String, Map<String, String>>();
        private final Map<String, Map<String, String>> _offlineSegmentAssignment = new TreeMap<String, Map<String, String>>();

        CompletedConsumingOfflineSegmentAssignment(Map<String, Map<String, String>> segmentAssignment) {
            for (Map.Entry<String, Map<String, String>> entry : segmentAssignment.entrySet()) {
                String segmentName = entry.getKey();
                Map<String, String> instanceStateMap = entry.getValue();
                if (instanceStateMap.containsValue("ONLINE")) {
                    this._completedSegmentAssignment.put(segmentName, instanceStateMap);
                    continue;
                }
                if (instanceStateMap.containsValue("CONSUMING")) {
                    this._consumingSegmentAssignment.put(segmentName, instanceStateMap);
                    continue;
                }
                this._offlineSegmentAssignment.put(segmentName, instanceStateMap);
            }
        }

        Map<String, Map<String, String>> getCompletedSegmentAssignment() {
            return this._completedSegmentAssignment;
        }

        Map<String, Map<String, String>> getConsumingSegmentAssignment() {
            return this._consumingSegmentAssignment;
        }

        Map<String, Map<String, String>> getOfflineSegmentAssignment() {
            return this._offlineSegmentAssignment;
        }
    }
}

