/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceReplicaGroupPartitionSelector
extends InstancePartitionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceReplicaGroupPartitionSelector.class);

    public InstanceReplicaGroupPartitionSelector(InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, String tableNameWithType, @Nullable InstancePartitions existingInstancePartitions) {
        super(replicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions);
    }

    @Override
    public void selectInstances(Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap, InstancePartitions instancePartitions) {
        int numPools = poolToInstanceConfigsMap.size();
        Preconditions.checkState((numPools != 0 ? 1 : 0) != 0, (Object)"No pool qualified for selection");
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        ArrayList<Integer> pools = new ArrayList<Integer>(poolToInstanceConfigsMap.keySet());
        pools.sort(null);
        LOGGER.info("Starting instance replica-group/partition selection for table: {} with hash: {} from pools: {}", new Object[]{this._tableNameWithType, tableNameHash, pools});
        if (this._replicaGroupPartitionConfig.isReplicaGroupBased()) {
            int numInstancesPerPartition;
            int pool;
            int numReplicaGroups = this._replicaGroupPartitionConfig.getNumReplicaGroups();
            Preconditions.checkState((numReplicaGroups > 0 ? 1 : 0) != 0, (Object)"Number of replica-groups must be positive");
            TreeMap<Integer, List> poolToReplicaGroupIdsMap = new TreeMap<Integer, List>();
            TreeMap<Integer, Integer> replicaGroupIdToPoolMap = new TreeMap<Integer, Integer>();
            for (int replicaId = 0; replicaId < numReplicaGroups; ++replicaId) {
                int pool2 = (Integer)pools.get((tableNameHash + replicaId) % numPools);
                poolToReplicaGroupIdsMap.computeIfAbsent(pool2, k -> new ArrayList()).add(replicaId);
                replicaGroupIdToPoolMap.put(replicaId, pool2);
            }
            LOGGER.info("Selecting {} replica-groups from pool: {} for table: {}", new Object[]{numReplicaGroups, poolToReplicaGroupIdsMap, this._tableNameWithType});
            int numInstancesPerReplicaGroup = this._replicaGroupPartitionConfig.getNumInstancesPerReplicaGroup();
            if (numInstancesPerReplicaGroup > 0) {
                for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                    pool = (Integer)entry.getKey();
                    int numInstancesInPool = poolToInstanceConfigsMap.get(pool).size();
                    int numInstancesToSelect = numInstancesPerReplicaGroup * ((List)entry.getValue()).size();
                    Preconditions.checkState((numInstancesToSelect <= numInstancesInPool ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)pool, (Object)numInstancesInPool, (Object)numInstancesToSelect);
                }
            } else {
                numInstancesPerReplicaGroup = Integer.MAX_VALUE;
                for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                    int numInstancesInPool;
                    pool = (Integer)entry.getKey();
                    int numReplicaGroupsInPool = ((List)entry.getValue()).size();
                    Preconditions.checkState((numReplicaGroupsInPool <= (numInstancesInPool = poolToInstanceConfigsMap.get(pool).size()) ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s, cannot select %s replica-groups from %s instances", (Object)pool, (Object)numReplicaGroupsInPool, (Object)numInstancesInPool);
                    numInstancesPerReplicaGroup = Math.min(numInstancesPerReplicaGroup, numInstancesInPool / numReplicaGroupsInPool);
                }
            }
            LOGGER.info("Selecting {} instances per replica-group for table: {}", (Object)numInstancesPerReplicaGroup, (Object)this._tableNameWithType);
            int numPartitions = this._replicaGroupPartitionConfig.getNumPartitions();
            if (numPartitions <= 0) {
                numPartitions = 1;
            }
            if ((numInstancesPerPartition = this._replicaGroupPartitionConfig.getNumInstancesPerPartition()) > 0) {
                Preconditions.checkState((numInstancesPerPartition <= numInstancesPerReplicaGroup ? 1 : 0) != 0, (String)"Number of instances per partition: %s must be smaller or equal to number of instances per replica-group: %s", (int)numInstancesPerPartition, (int)numInstancesPerReplicaGroup);
            } else {
                numInstancesPerPartition = numInstancesPerReplicaGroup;
            }
            LOGGER.info("Selecting {} partitions, {} instances per partition within a replica-group for table: {}", new Object[]{numPartitions, numInstancesPerPartition, this._tableNameWithType});
            if (this._replicaGroupPartitionConfig.isMinimizeDataMovement() && this._existingInstancePartitions != null) {
                List<String> instancesToSelect;
                HashSet chosenCandidateInstances;
                List existingInstances;
                int partitionId;
                LinkedHashSet<String> candidateInstances;
                Integer pool3;
                int replicaGroupId;
                int existingNumPartitions = this._existingInstancePartitions.getNumPartitions();
                int existingNumReplicaGroups = this._existingInstancePartitions.getNumReplicaGroups();
                int numCommonReplicaGroups = Math.min(numReplicaGroups, existingNumReplicaGroups);
                TreeMap<Integer, Set> poolToCandidateInstancesMap = new TreeMap<Integer, Set>();
                TreeMap<Integer, Set> replicaGroupIdToExistingInstancesMap = new TreeMap<Integer, Set>();
                for (replicaGroupId = 0; replicaGroupId < numCommonReplicaGroups; ++replicaGroupId) {
                    pool3 = (Integer)replicaGroupIdToPoolMap.get(replicaGroupId);
                    if (pool3 == null) continue;
                    candidateInstances = poolToCandidateInstancesMap.computeIfAbsent(pool3, k -> new LinkedHashSet());
                    List<InstanceConfig> instanceConfigsInPool = poolToInstanceConfigsMap.get(pool3);
                    instanceConfigsInPool.forEach(k -> candidateInstances.add(k.getInstanceName()));
                    for (partitionId = 0; partitionId < existingNumPartitions; ++partitionId) {
                        existingInstances = this._existingInstancePartitions.getInstances(partitionId, replicaGroupId);
                        replicaGroupIdToExistingInstancesMap.computeIfAbsent(replicaGroupId, k -> new HashSet()).addAll(existingInstances);
                    }
                }
                for (replicaGroupId = 0; replicaGroupId < numCommonReplicaGroups; ++replicaGroupId) {
                    pool3 = (Integer)replicaGroupIdToPoolMap.get(replicaGroupId);
                    candidateInstances = new LinkedHashSet<String>((Collection)poolToCandidateInstancesMap.get(pool3));
                    for (int otherReplicaGroupId = 0; otherReplicaGroupId < existingNumReplicaGroups && otherReplicaGroupId < numReplicaGroups; ++otherReplicaGroupId) {
                        if (replicaGroupId == otherReplicaGroupId) continue;
                        candidateInstances.removeAll((Collection)replicaGroupIdToExistingInstancesMap.get(otherReplicaGroupId));
                    }
                    chosenCandidateInstances = new LinkedHashSet();
                    for (partitionId = 0; partitionId < existingNumPartitions; ++partitionId) {
                        existingInstances = this._existingInstancePartitions.getInstances(partitionId, replicaGroupId);
                        instancesToSelect = InstanceReplicaGroupPartitionSelector.getInstancesWithMinimumMovement(numInstancesPerPartition, candidateInstances, existingInstances);
                        chosenCandidateInstances.addAll(instancesToSelect);
                        instancePartitions.setInstances(partitionId, replicaGroupId, instancesToSelect);
                    }
                    ((Set)poolToCandidateInstancesMap.get(pool3)).removeAll(chosenCandidateInstances);
                }
                for (replicaGroupId = existingNumReplicaGroups; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                    int pool4 = (Integer)replicaGroupIdToPoolMap.get(replicaGroupId);
                    candidateInstances = new LinkedHashSet((Collection)poolToCandidateInstancesMap.get(pool4));
                    chosenCandidateInstances = new HashSet();
                    for (partitionId = 0; partitionId < existingNumPartitions; ++partitionId) {
                        existingInstances = Collections.emptyList();
                        instancesToSelect = InstanceReplicaGroupPartitionSelector.getInstancesWithMinimumMovement(numInstancesPerPartition, candidateInstances, existingInstances);
                        chosenCandidateInstances.addAll(instancesToSelect);
                        instancePartitions.setInstances(partitionId, replicaGroupId, instancesToSelect);
                    }
                    ((Set)poolToCandidateInstancesMap.get(pool4)).removeAll(chosenCandidateInstances);
                }
            } else {
                String[][] replicaGroupIdToInstancesMap = new String[numReplicaGroups][numInstancesPerReplicaGroup];
                for (Map.Entry entry : poolToReplicaGroupIdsMap.entrySet()) {
                    List<InstanceConfig> instanceConfigsInPool = poolToInstanceConfigsMap.get(entry.getKey());
                    List replicaGroupIdsInPool = (List)entry.getValue();
                    int instanceIdInPool = 0;
                    for (int instanceIdInReplicaGroup = 0; instanceIdInReplicaGroup < numInstancesPerReplicaGroup; ++instanceIdInReplicaGroup) {
                        Iterator iterator = replicaGroupIdsInPool.iterator();
                        while (iterator.hasNext()) {
                            int replicaGroupId = (Integer)iterator.next();
                            replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup] = instanceConfigsInPool.get(instanceIdInPool++).getInstanceName();
                        }
                    }
                }
                for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                    int instanceIdInReplicaGroup = 0;
                    for (int partitionId = 0; partitionId < numPartitions; ++partitionId) {
                        ArrayList<String> instancesInPartition = new ArrayList<String>(numInstancesPerPartition);
                        for (int instanceIdInPartition = 0; instanceIdInPartition < numInstancesPerPartition; ++instanceIdInPartition) {
                            instancesInPartition.add(replicaGroupIdToInstancesMap[replicaGroupId][instanceIdInReplicaGroup]);
                            instanceIdInReplicaGroup = (instanceIdInReplicaGroup + 1) % numInstancesPerReplicaGroup;
                        }
                        LOGGER.info("Selecting instances: {} for replica-group: {}, partition: {} for table: {}", new Object[]{instancesInPartition, replicaGroupId, partitionId, this._tableNameWithType});
                        instancePartitions.setInstances(partitionId, replicaGroupId, instancesInPartition);
                    }
                }
            }
        } else {
            List<String> instancesToSelect;
            int pool = (Integer)pools.get(tableNameHash % numPools);
            LOGGER.info("Selecting pool: {} for table: {}", (Object)pool, (Object)this._tableNameWithType);
            List<InstanceConfig> instanceConfigs = poolToInstanceConfigsMap.get(pool);
            int numInstanceConfigs = instanceConfigs.size();
            int numInstancesToSelect = this._replicaGroupPartitionConfig.getNumInstances();
            if (numInstancesToSelect > 0) {
                Preconditions.checkState((numInstancesToSelect <= numInstanceConfigs ? 1 : 0) != 0, (String)"Not enough qualified instances from pool: %s (%s in the pool, asked for %s)", (Object)pool, (Object)numInstanceConfigs, (Object)numInstancesToSelect);
            } else {
                numInstancesToSelect = numInstanceConfigs;
            }
            if (this._replicaGroupPartitionConfig.isMinimizeDataMovement() && this._existingInstancePartitions != null) {
                List existingInstances = this._existingInstancePartitions.getInstances(0, 0);
                LinkedHashSet<String> candidateInstances = new LinkedHashSet<String>();
                instanceConfigs.forEach(k -> candidateInstances.add(k.getInstanceName()));
                instancesToSelect = InstanceReplicaGroupPartitionSelector.getInstancesWithMinimumMovement(numInstancesToSelect, candidateInstances, existingInstances);
            } else {
                instancesToSelect = new ArrayList<String>(numInstancesToSelect);
                for (int i = 0; i < numInstancesToSelect; ++i) {
                    instancesToSelect.add(instanceConfigs.get(i).getInstanceName());
                }
            }
            LOGGER.info("Selecting instances: {} for table: {}", instancesToSelect, (Object)this._tableNameWithType);
            instancePartitions.setInstances(0, 0, instancesToSelect);
        }
    }

    private static List<String> getInstancesWithMinimumMovement(int numInstancesToSelect, LinkedHashSet<String> candidateInstances, List<String> existingInstances) {
        int i;
        ArrayList<String> instancesToSelect = new ArrayList<String>(numInstancesToSelect);
        for (int i2 = 0; i2 < numInstancesToSelect; ++i2) {
            instancesToSelect.add(null);
        }
        LinkedList<String> newlyAddedInstances = new LinkedList<String>();
        HashSet<String> existingInstancesStillAlive = new HashSet<String>();
        for (String existingInstance : existingInstances) {
            if (!candidateInstances.contains(existingInstance)) continue;
            existingInstancesStillAlive.add(existingInstance);
        }
        for (String candidateInstance : candidateInstances) {
            if (existingInstancesStillAlive.contains(candidateInstance)) continue;
            newlyAddedInstances.add(candidateInstance);
        }
        int numExistingInstances = existingInstances.size();
        for (i = 0; i < numInstancesToSelect; ++i) {
            String selectedInstance;
            String existingInstance;
            String string = existingInstance = i < numExistingInstances ? existingInstances.get(i) : null;
            if (existingInstance != null && candidateInstances.contains(existingInstance)) {
                selectedInstance = existingInstance;
                existingInstancesStillAlive.remove(selectedInstance);
            } else {
                selectedInstance = (String)newlyAddedInstances.poll();
            }
            instancesToSelect.set(i, selectedInstance);
            if (selectedInstance == null || i >= numExistingInstances && !existingInstances.isEmpty()) continue;
            candidateInstances.remove(selectedInstance);
            candidateInstances.add(selectedInstance);
        }
        for (i = 0; i < instancesToSelect.size(); ++i) {
            if (instancesToSelect.get(i) != null) continue;
            if (!existingInstancesStillAlive.isEmpty()) {
                Iterator iterator = existingInstancesStillAlive.iterator();
                String existingInstanceLeftOver = (String)iterator.next();
                instancesToSelect.set(i, existingInstanceLeftOver);
                iterator.remove();
                continue;
            }
            if (newlyAddedInstances.isEmpty()) continue;
            String newInstance = (String)newlyAddedInstances.pollFirst();
            instancesToSelect.set(i, newInstance);
        }
        return instancesToSelect;
    }
}

