/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import java.util.Arrays;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.instance.FDAwareInstancePartitionSelector;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceReplicaGroupPartitionSelector;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;

public class InstancePartitionSelectorFactory {
    private InstancePartitionSelectorFactory() {
    }

    public static InstancePartitionSelector getInstance(InstanceAssignmentConfig.PartitionSelector partitionSelector, InstanceReplicaGroupPartitionConfig instanceReplicaGroupPartitionConfig, String tableNameWithType, InstancePartitions existingInstancePartitions) {
        switch (partitionSelector) {
            case FD_AWARE_INSTANCE_PARTITION_SELECTOR: {
                return new FDAwareInstancePartitionSelector(instanceReplicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions);
            }
            case INSTANCE_REPLICA_GROUP_PARTITION_SELECTOR: {
                return new InstanceReplicaGroupPartitionSelector(instanceReplicaGroupPartitionConfig, tableNameWithType, existingInstancePartitions);
            }
        }
        throw new IllegalStateException("Unexpected PartitionSelector: " + partitionSelector + ", should be from" + Arrays.toString(InstanceAssignmentConfig.PartitionSelector.values()));
    }
}

