/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceAssignmentDriver;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotInstanceAssignmentRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotInstanceAssignmentRestletResource.class);
    @Inject
    PinotHelixResourceManager _resourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetInstancePartitions")
    @ApiOperation(value="Get the instance partitions")
    public Map<String, InstancePartitions> getInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED|tier name") @QueryParam(value="type") @Nullable String type) {
        InstancePartitions offlineInstancePartitions;
        TreeMap<String, InstancePartitions> instancePartitionsMap = new TreeMap<String, InstancePartitions>();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (InstancePartitionsType.OFFLINE.toString().equals(type) || type == null) && (offlineInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName))) != null) {
            instancePartitionsMap.put(InstancePartitionsType.OFFLINE.toString(), offlineInstancePartitions);
        }
        if (tableType != TableType.OFFLINE) {
            InstancePartitions completedInstancePartitions;
            InstancePartitions consumingInstancePartitions;
            if ((InstancePartitionsType.CONSUMING.toString().equals(type) || type == null) && (consumingInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName))) != null) {
                instancePartitionsMap.put(InstancePartitionsType.CONSUMING.toString(), consumingInstancePartitions);
            }
            if ((InstancePartitionsType.COMPLETED.toString().equals(type) || type == null) && (completedInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName))) != null) {
                instancePartitionsMap.put(InstancePartitionsType.COMPLETED.toString(), completedInstancePartitions);
            }
        }
        List<TableConfig> tableConfigs = Arrays.asList(this._resourceManager.getRealtimeTableConfig(tableName), this._resourceManager.getOfflineTableConfig(tableName));
        for (TableConfig tableConfig : tableConfigs) {
            if (tableConfig == null || !CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList())) continue;
            for (TierConfig tierConfig : tableConfig.getTierConfigsList()) {
                InstancePartitions instancePartitions;
                if (type != null && !type.equals(tierConfig.getName()) || (instancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsUtils.getInstancePartitionsNameForTier((String)tableConfig.getTableName(), (String)tierConfig.getName()))) == null) continue;
                instancePartitionsMap.put(tierConfig.getName(), instancePartitions);
            }
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the instance partitions", Response.Status.NOT_FOUND);
        }
        return instancePartitionsMap;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/assignInstances")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="CreateInstancePartitions")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Assign server instances to a table")
    public Map<String, InstancePartitions> assignInstances(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED|tier name") @QueryParam(value="type") @Nullable String type, @ApiParam(value="Whether to do dry-run") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun) {
        TableConfig offlineTableConfig;
        TableConfig realtimeTableConfig;
        TableConfig offlineTableConfig2;
        TreeMap<String, InstancePartitions> instancePartitionsMap = new TreeMap<String, InstancePartitions>();
        List<InstanceConfig> instanceConfigs = this._resourceManager.getAllHelixInstanceConfigs();
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (InstancePartitionsType.OFFLINE.toString().equals(type) || type == null) && (offlineTableConfig2 = this._resourceManager.getOfflineTableConfig(tableName)) != null) {
            try {
                if (InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)offlineTableConfig2, (InstancePartitionsType)InstancePartitionsType.OFFLINE)) {
                    this.assignInstancesForInstancePartitionsType(instancePartitionsMap, offlineTableConfig2, instanceConfigs, InstancePartitionsType.OFFLINE);
                }
            }
            catch (IllegalStateException e) {
                throw new ControllerApplicationException(LOGGER, "Caught IllegalStateException", Response.Status.BAD_REQUEST, (Throwable)e);
            }
            catch (Exception e) {
                throw new ControllerApplicationException(LOGGER, "Caught exception while calculating the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if (tableType != TableType.OFFLINE && !InstancePartitionsType.OFFLINE.toString().equals(type) && (realtimeTableConfig = this._resourceManager.getRealtimeTableConfig(tableName)) != null) {
            try {
                if ((InstancePartitionsType.CONSUMING.toString().equals(type) || type == null) && InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)realtimeTableConfig, (InstancePartitionsType)InstancePartitionsType.CONSUMING)) {
                    this.assignInstancesForInstancePartitionsType(instancePartitionsMap, realtimeTableConfig, instanceConfigs, InstancePartitionsType.CONSUMING);
                }
                if ((InstancePartitionsType.COMPLETED.toString().equals(type) || type == null) && InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)realtimeTableConfig, (InstancePartitionsType)InstancePartitionsType.COMPLETED)) {
                    this.assignInstancesForInstancePartitionsType(instancePartitionsMap, realtimeTableConfig, instanceConfigs, InstancePartitionsType.COMPLETED);
                }
            }
            catch (IllegalStateException e) {
                throw new ControllerApplicationException(LOGGER, "Caught IllegalStateException", Response.Status.BAD_REQUEST, (Throwable)e);
            }
            catch (Exception e) {
                throw new ControllerApplicationException(LOGGER, "Caught exception while calculating the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if ((realtimeTableConfig = this._resourceManager.getRealtimeTableConfig(tableName)) != null) {
            this.assignInstancesForTier(instancePartitionsMap, realtimeTableConfig, instanceConfigs, type);
        }
        if ((offlineTableConfig = this._resourceManager.getOfflineTableConfig(tableName)) != null) {
            this.assignInstancesForTier(instancePartitionsMap, offlineTableConfig, instanceConfigs, type);
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the instance assignment config", Response.Status.NOT_FOUND);
        }
        if (!dryRun) {
            for (InstancePartitions instancePartitions : instancePartitionsMap.values()) {
                this.persistInstancePartitionsHelper(instancePartitions);
            }
        }
        return instancePartitionsMap;
    }

    private void assignInstancesForInstancePartitionsType(Map<String, InstancePartitions> instancePartitionsMap, TableConfig tableConfig, List<InstanceConfig> instanceConfigs, InstancePartitionsType instancePartitionsType) {
        String tableNameWithType = tableConfig.getTableName();
        if (TableConfigUtils.hasPreConfiguredInstancePartitions((TableConfig)tableConfig, (InstancePartitionsType)instancePartitionsType)) {
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
            instancePartitionsMap.put(instancePartitionsType.toString(), InstancePartitionsUtils.fetchInstancePartitionsWithRename(this._resourceManager.getPropertyStore(), (String)((String)tableConfig.getInstancePartitionsMap().get(instancePartitionsType)), (String)instancePartitionsType.getInstancePartitionsName(rawTableName)));
            return;
        }
        InstancePartitions existingInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions((HelixPropertyStore)this._resourceManager.getHelixZkManager().getHelixPropertyStore(), (String)InstancePartitionsUtils.getInstancePartitionsName((String)tableNameWithType, (String)instancePartitionsType.toString()));
        instancePartitionsMap.put(instancePartitionsType.toString(), new InstanceAssignmentDriver(tableConfig).assignInstances(instancePartitionsType, instanceConfigs, existingInstancePartitions));
    }

    private void assignInstancesForTier(Map<String, InstancePartitions> instancePartitionsMap, TableConfig tableConfig, List<InstanceConfig> instanceConfigs, String tierName) {
        if (CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList()) && tableConfig.getInstanceAssignmentConfigMap() != null) {
            for (TierConfig tierConfig : tableConfig.getTierConfigsList()) {
                if (!tierConfig.getName().equals(tierName) && tierName != null || tableConfig.getInstanceAssignmentConfigMap().get(tierConfig.getName()) == null) continue;
                InstancePartitions existingInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions((HelixPropertyStore)this._resourceManager.getHelixZkManager().getHelixPropertyStore(), (String)InstancePartitionsUtils.getInstancePartitionsNameForTier((String)tableConfig.getTableName(), (String)tierConfig.getName()));
                instancePartitionsMap.put(tierConfig.getName(), new InstanceAssignmentDriver(tableConfig).assignInstances(tierConfig.getName(), instanceConfigs, existingInstancePartitions, (InstanceAssignmentConfig)tableConfig.getInstanceAssignmentConfigMap().get(tierConfig.getName())));
            }
        }
    }

    private void persistInstancePartitionsHelper(InstancePartitions instancePartitions) {
        try {
            LOGGER.info("Persisting instance partitions: {}", (Object)instancePartitions);
            InstancePartitionsUtils.persistInstancePartitions(this._resourceManager.getPropertyStore(), (InstancePartitions)instancePartitions);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught Exception while persisting the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UpdateInstancePartitions")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Create/update the instance partitions")
    public Map<String, InstancePartitions> setInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, String instancePartitionsStr) {
        InstancePartitions instancePartitions;
        try {
            instancePartitions = (InstancePartitions)JsonUtils.stringToObject((String)instancePartitionsStr, InstancePartitions.class);
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to deserialize the instance partitions", Response.Status.BAD_REQUEST);
        }
        String instancePartitionsName = instancePartitions.getInstancePartitionsName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
            this.persistInstancePartitionsHelper(instancePartitions);
            return Collections.singletonMap(InstancePartitionsType.OFFLINE.toString(), instancePartitions);
        }
        if (tableType != TableType.OFFLINE) {
            if (InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
                this.persistInstancePartitionsHelper(instancePartitions);
                return Collections.singletonMap(InstancePartitionsType.CONSUMING.toString(), instancePartitions);
            }
            if (InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
                this.persistInstancePartitionsHelper(instancePartitions);
                return Collections.singletonMap(InstancePartitionsType.COMPLETED.toString(), instancePartitions);
            }
        }
        List<TableConfig> tableConfigs = Arrays.asList(this._resourceManager.getRealtimeTableConfig(tableName), this._resourceManager.getOfflineTableConfig(tableName));
        for (TableConfig tableConfig : tableConfigs) {
            if (tableConfig == null || !CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList())) continue;
            for (TierConfig tierConfig : tableConfig.getTierConfigsList()) {
                if (!InstancePartitionsUtils.getInstancePartitionsNameForTier((String)tableConfig.getTableName(), (String)tierConfig.getName()).equals(instancePartitionsName)) continue;
                this.persistInstancePartitionsHelper(instancePartitions);
                return Collections.singletonMap(tierConfig.getName(), instancePartitions);
            }
        }
        throw new ControllerApplicationException(LOGGER, "Instance partitions cannot be applied to the table", Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteInstancePartitions")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Remove the instance partitions")
    public SuccessResponse removeInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED|tier name") @QueryParam(value="type") @Nullable String instancePartitionsType) {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (InstancePartitionsType.OFFLINE.toString().equals(instancePartitionsType) || instancePartitionsType == null)) {
            this.removeInstancePartitionsHelper(InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName));
        }
        if (tableType != TableType.OFFLINE) {
            if (InstancePartitionsType.CONSUMING.toString().equals(instancePartitionsType) || instancePartitionsType == null) {
                this.removeInstancePartitionsHelper(InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName));
            }
            if (InstancePartitionsType.COMPLETED.toString().equals(instancePartitionsType) || instancePartitionsType == null) {
                this.removeInstancePartitionsHelper(InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName));
            }
        }
        List<TableConfig> tableConfigs = Arrays.asList(this._resourceManager.getRealtimeTableConfig(tableName), this._resourceManager.getOfflineTableConfig(tableName));
        for (TableConfig tableConfig : tableConfigs) {
            if (tableConfig == null || !CollectionUtils.isNotEmpty((Collection)tableConfig.getTierConfigsList())) continue;
            for (TierConfig tierConfig : tableConfig.getTierConfigsList()) {
                if (instancePartitionsType != null && !instancePartitionsType.equals(tierConfig.getName())) continue;
                this.removeInstancePartitionsHelper(InstancePartitionsUtils.getInstancePartitionsNameForTier((String)tableConfig.getTableName(), (String)tierConfig.getName()));
            }
        }
        return new SuccessResponse("Instance partitions removed");
    }

    private void removeInstancePartitionsHelper(String instancePartitionsName) {
        try {
            LOGGER.info("Removing instance partitions: {}", (Object)instancePartitionsName);
            InstancePartitionsUtils.removeInstancePartitions(this._resourceManager.getPropertyStore(), (String)instancePartitionsName);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught Exception while removing the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/replaceInstance")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UpdateInstancePartitions")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Replace an instance in the instance partitions")
    public Map<String, InstancePartitions> replaceInstance(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED|tier name") @QueryParam(value="type") @Nullable String type, @ApiParam(value="Old instance to be replaced", required=true) @QueryParam(value="oldInstanceId") String oldInstanceId, @ApiParam(value="New instance to replace with", required=true) @QueryParam(value="newInstanceId") String newInstanceId) {
        Map<String, InstancePartitions> instancePartitionsMap = this.getInstancePartitions(tableName, type);
        Iterator<InstancePartitions> iterator = instancePartitionsMap.values().iterator();
        while (iterator.hasNext()) {
            InstancePartitions instancePartitions = iterator.next();
            boolean oldInstanceFound = false;
            Map partitionToInstancesMap = instancePartitions.getPartitionToInstancesMap();
            for (List instances : partitionToInstancesMap.values()) {
                oldInstanceFound |= Collections.replaceAll(instances, oldInstanceId, newInstanceId);
            }
            if (oldInstanceFound) {
                this.persistInstancePartitionsHelper(instancePartitions);
                continue;
            }
            iterator.remove();
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the old instance", Response.Status.NOT_FOUND);
        }
        return instancePartitionsMap;
    }
}

