/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.helix.model.InstanceConfig;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.LoggerUtils;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.common.utils.log.DummyLogFileServer;
import org.apache.pinot.common.utils.log.LogFileServer;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;

@Api(tags={"Logger"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotControllerLogger {
    private final FileUploadDownloadClient _fileUploadDownloadClient = new FileUploadDownloadClient();
    @Inject
    private LogFileServer _logFileServer;
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Path(value="/loggers")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogger")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all the loggers", notes="Return all the logger names")
    public List<String> getLoggers() {
        return LoggerUtils.getAllLoggers();
    }

    @GET
    @Path(value="/loggers/{loggerName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogger")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get logger configs", notes="Return logger info")
    public Map<String, String> getLogger(@ApiParam(value="Logger name", required=true) @PathParam(value="loggerName") String loggerName) {
        Map loggerInfo = LoggerUtils.getLoggerInfo((String)loggerName);
        if (loggerInfo == null) {
            throw new WebApplicationException(String.format("Logger %s not found", loggerName), Response.Status.NOT_FOUND);
        }
        return loggerInfo;
    }

    @PUT
    @Path(value="/loggers/{loggerName}")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateLogger")
    @Produces(value={"application/json"})
    @ApiOperation(value="Set logger level", notes="Set logger level for a given logger")
    public Map<String, String> setLoggerLevel(@ApiParam(value="Logger name") @PathParam(value="loggerName") String loggerName, @ApiParam(value="Logger level") @QueryParam(value="level") String level) {
        return LoggerUtils.setLoggerLevel((String)loggerName, (String)level);
    }

    @GET
    @Path(value="/loggers/files")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogFile")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all local log files")
    public Set<String> getLocalLogFiles() {
        try {
            if (this._logFileServer == null || this._logFileServer instanceof DummyLogFileServer) {
                throw new WebApplicationException("Root log directory doesn't exist", Response.Status.INTERNAL_SERVER_ERROR);
            }
            return this._logFileServer.getAllLogFilePaths();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/loggers/download")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogFile")
    @Produces(value={"application/octet-stream"})
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Download a log file")
    public Response downloadLogFile(@ApiParam(value="Log file path", required=true) @QueryParam(value="filePath") String filePath) {
        if (this._logFileServer == null || this._logFileServer instanceof DummyLogFileServer) {
            throw new WebApplicationException("Root log directory is not configured", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return this._logFileServer.downloadLogFile(filePath);
    }

    @GET
    @Path(value="/loggers/instances")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogFile")
    @Produces(value={"application/json"})
    @ApiOperation(value="Collect log files from all the instances")
    public Map<String, Set<String>> getLogFilesFromAllInstances(@HeaderParam(value="Authorization") String authorization) {
        if (this._logFileServer == null || this._logFileServer instanceof DummyLogFileServer) {
            throw new WebApplicationException("Root directory doesn't exist", Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashMap<String, Set<String>> instancesToLogFilesMap = new HashMap<String, Set<String>>();
        List<String> onlineInstanceList = this._pinotHelixResourceManager.getOnlineInstanceList();
        onlineInstanceList.forEach(instance -> {
            try {
                instancesToLogFilesMap.put((String)instance, this.getLogFilesFromInstance(authorization, (String)instance));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return instancesToLogFilesMap;
    }

    @GET
    @Path(value="/loggers/instances/{instanceName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogFile")
    @Produces(value={"application/json"})
    @ApiOperation(value="Collect log files from a given instance")
    public Set<String> getLogFilesFromInstance(@HeaderParam(value="Authorization") String authorization, @ApiParam(value="Instance Name", required=true) @PathParam(value="instanceName") String instanceName) {
        try {
            SimpleHttpResponse simpleHttpResponse;
            URI uri = new URI(this.getInstanceBaseUri(instanceName) + "/loggers/files");
            HashMap<String, String> headers = new HashMap<String, String>();
            if (authorization != null) {
                headers.put("Authorization", authorization);
            }
            if ((simpleHttpResponse = this._fileUploadDownloadClient.getHttpClient().sendGetRequest(uri, headers)).getStatusCode() >= 400) {
                throw new WebApplicationException("Failed to fetch logs from instance name: " + instanceName, Response.Status.fromStatusCode((int)simpleHttpResponse.getStatusCode()));
            }
            String responseString = simpleHttpResponse.getResponse();
            responseString = responseString.substring(1, responseString.length() - 1).replace("\"", "");
            return new HashSet<String>(Arrays.asList(responseString.split(",")));
        }
        catch (IOException | URISyntaxException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/loggers/instances/{instanceName}/download")
    @Authorize(targetType=TargetType.CLUSTER, action="GetLogFile")
    @Produces(value={"application/octet-stream"})
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Download a log file from a given instance")
    public Response downloadLogFileFromInstance(@HeaderParam(value="Authorization") String authorization, @ApiParam(value="Instance Name", required=true) @PathParam(value="instanceName") String instanceName, @ApiParam(value="Log file path", required=true) @QueryParam(value="filePath") String filePath, @Context Map<String, String> headers) {
        try {
            CloseableHttpResponse httpResponse;
            URI uri = UriBuilder.fromUri((String)this.getInstanceBaseUri(instanceName)).path("/loggers/download").queryParam("filePath", new Object[]{filePath}).build(new Object[0]);
            RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    requestBuilder.addHeader(header.getKey(), header.getValue());
                }
            }
            if (authorization != null) {
                requestBuilder.addHeader("Authorization", authorization);
            }
            if ((httpResponse = this._fileUploadDownloadClient.getHttpClient().execute(requestBuilder.build())).getStatusLine().getStatusCode() >= 400) {
                throw new WebApplicationException(IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8"), Response.Status.fromStatusCode((int)httpResponse.getStatusLine().getStatusCode()));
            }
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)httpResponse.getEntity().getContent());
            builder.contentLocation(uri);
            builder.header("Content-Length", (Object)httpResponse.getEntity().getContentLength());
            return builder.build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getInstanceBaseUri(String instanceName) {
        return InstanceUtils.getInstanceBaseUri((InstanceConfig)this._pinotHelixResourceManager.getHelixInstanceConfig(instanceName));
    }
}

