/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.utils.BcryptUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.exception.UserAlreadyExistsException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.user.ComponentType;
import org.apache.pinot.spi.config.user.UserConfig;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"User"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotAccessControlUserRestletResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotAccessControlUserRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users")
    @Authorize(targetType=TargetType.CLUSTER, action="GetUser")
    @ApiOperation(value="List all uses in cluster", notes="List all users in cluster")
    public String listUers() {
        try {
            ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
            Map allUserInfo = ZKMetadataProvider.getAllUserInfo(propertyStore);
            return JsonUtils.newObjectNode().set("users", JsonUtils.objectToJsonNode((Object)allUserInfo)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/{username}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetUser")
    @ApiOperation(value="Get an user in cluster", notes="Get an user in cluster")
    public String getUser(@PathParam(value="username") String username, @QueryParam(value="component") String componentTypeStr) {
        try {
            ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
            ComponentType componentType = Constants.validateComponentType(componentTypeStr);
            String usernameWithType = username + "_" + componentType.name();
            UserConfig userConfig = ZKMetadataProvider.getUserConfig(propertyStore, (String)usernameWithType);
            return JsonUtils.newObjectNode().set(usernameWithType, JsonUtils.objectToJsonNode((Object)userConfig)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/users")
    @Authorize(targetType=TargetType.CLUSTER, action="CreateUser")
    @ApiOperation(value="Add a user", notes="Add a user")
    public SuccessResponse addUser(String userConfigStr) {
        UserConfig userConfig;
        try {
            userConfig = (UserConfig)JsonUtils.stringToObject((String)userConfigStr, UserConfig.class);
            String username = userConfig.getUserName();
            if (username.contains(".") || username.contains(" ")) {
                throw new IllegalStateException("Username: " + username + " containing '.' or space is not allowed");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this._pinotHelixResourceManager.addUser(userConfig);
            return new SuccessResponse(String.format("User %s has been successfully added!", userConfig.getUserName() + "_" + userConfig.getComponentType()));
        }
        catch (Exception e) {
            if (e instanceof UserAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/users/{username}")
    @Authorize(targetType=TargetType.CLUSTER, action="DeleteUser")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a user", notes="Delete a user")
    public SuccessResponse deleteUser(@PathParam(value="username") String username, @QueryParam(value="component") String componentTypeStr) {
        LinkedList<String> usersDeleted = new LinkedList<String>();
        String usernameWithComponentType = username + "_" + componentTypeStr;
        try {
            boolean userExist = false;
            userExist = this._pinotHelixResourceManager.hasUser(username, componentTypeStr);
            this._pinotHelixResourceManager.deleteUser(usernameWithComponentType);
            if (userExist) {
                usersDeleted.add(username);
            }
            if (!usersDeleted.isEmpty()) {
                return new SuccessResponse("User: " + usernameWithComponentType + " has been successfully deleted");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "User " + usernameWithComponentType + " does not exists", Response.Status.NOT_FOUND);
    }

    @PUT
    @Path(value="/users/{username}")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateUser")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update user config for a user", notes="Update user config for user")
    public SuccessResponse updateUserConfig(@PathParam(value="username") String username, @QueryParam(value="component") String componentTypeStr, @QueryParam(value="passwordChanged") boolean passwordChanged, String userConfigString) {
        String usernameWithComponentType = username + "_" + componentTypeStr;
        try {
            String usernameWithComponentTypeFromUserConfig;
            UserConfig userConfig = (UserConfig)JsonUtils.stringToObject((String)userConfigString, UserConfig.class);
            if (passwordChanged) {
                userConfig.setPassword(BcryptUtils.encrypt((String)userConfig.getPassword()));
            }
            if (!usernameWithComponentType.equals(usernameWithComponentTypeFromUserConfig = userConfig.getUsernameWithComponent())) {
                throw new ControllerApplicationException(LOGGER, String.format("Request user %s does not match %s in the Request body", usernameWithComponentType, usernameWithComponentTypeFromUserConfig), Response.Status.BAD_REQUEST);
            }
            if (!this._pinotHelixResourceManager.hasUser(username, componentTypeStr)) {
                throw new ControllerApplicationException(LOGGER, "Request user " + usernameWithComponentType + " does not exist", Response.Status.NOT_FOUND);
            }
            this._pinotHelixResourceManager.updateUserConfig(userConfig);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        return new SuccessResponse("User config update for " + usernameWithComponentType);
    }
}

