/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class OperationValidationResponse {
    private String _instanceName;
    private boolean _safe;
    private final List<ErrorWrapper> _issues = new ArrayList<ErrorWrapper>();

    @JsonProperty(value="instanceName")
    public String getInstanceName() {
        return this._instanceName;
    }

    public OperationValidationResponse setInstanceName(String instanceName) {
        this._instanceName = instanceName;
        return this;
    }

    @JsonProperty(value="isSafe")
    public boolean isSafe() {
        return this._safe;
    }

    public OperationValidationResponse setSafe(boolean safe) {
        this._safe = safe;
        return this;
    }

    @JsonProperty(value="issues")
    public List<ErrorWrapper> getIssues() {
        return this._issues;
    }

    public OperationValidationResponse putIssue(ErrorCode code, String ... args) {
        this._issues.add(new ErrorWrapper(code, args));
        return this;
    }

    public OperationValidationResponse putAllIssues(List<ErrorWrapper> issues) {
        this._issues.addAll(issues);
        return this;
    }

    public String getIssueMessage(int index) {
        return this._issues.get(index).getMessage();
    }

    public static enum ErrorCode {
        IS_ALIVE("Instance %s is still live"),
        CONTAINS_RESOURCE("Instance %s exists in ideal state for %s"),
        MINIMUM_INSTANCE_UNSATISFIED("Tenant '%s' will not satisfy minimum '%s' requirement if tag '%s' is removed from %s instance '%s'."),
        ALREADY_DEFICIENT_TENANT("Tenant '%s' is low on '%s' instances by %s even after allocating instance %s"),
        UNRECOGNISED_TAG_TYPE("The tag '%s' does not follow the suffix convention of either broker or server");

        public final String _description;

        private ErrorCode(String description) {
            this._description = description;
        }
    }

    public static class ErrorWrapper {
        @JsonProperty(value="code")
        ErrorCode _code;
        @JsonProperty(value="message")
        String _message;

        public ErrorWrapper() {
        }

        public ErrorWrapper(ErrorCode code, String ... args) {
            this._code = code;
            this._message = String.format(code._description, args);
        }

        public ErrorCode getCode() {
            return this._code;
        }

        public String getMessage() {
            return this._message;
        }
    }
}

