/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.glassfish.grizzly.http.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ControllerResponseFilter
implements ContainerResponseFilter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ControllerResponseFilter.class);
    @Inject
    private javax.inject.Provider<Request> _request;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String method = requestContext.getMethod();
        String uri = requestContext.getUriInfo().getRequestUri().toString();
        int respStatus = responseContext.getStatus();
        String reasonPhrase = responseContext.getStatusInfo().getReasonPhrase();
        String srcIpAddr = ((Request)this._request.get()).getRemoteAddr();
        String contentType = requestContext.getHeaderString("Content-Type");
        LOGGER.info("Handled request from {} {} {}, content-type {} status code {} {}", new Object[]{srcIpAddr, method, uri, contentType, respStatus, reasonPhrase});
    }
}

