/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.realtime.segment.CommittingSegmentDescriptor;
import org.apache.pinot.controller.helix.core.realtime.segment.FlushThresholdUpdater;
import org.apache.pinot.controller.helix.core.realtime.segment.SegmentFlushThresholdComputer;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentSizeBasedFlushThresholdUpdater
implements FlushThresholdUpdater {
    public static final Logger LOGGER = LoggerFactory.getLogger(SegmentSizeBasedFlushThresholdUpdater.class);
    private final SegmentFlushThresholdComputer _flushThresholdComputer = new SegmentFlushThresholdComputer();

    @VisibleForTesting
    double getLatestSegmentRowsToSizeRatio() {
        return this._flushThresholdComputer.getLatestSegmentRowsToSizeRatio();
    }

    @Override
    public synchronized void updateFlushThreshold(PartitionLevelStreamConfig streamConfig, SegmentZKMetadata newSegmentZKMetadata, CommittingSegmentDescriptor committingSegmentDescriptor, @Nullable SegmentZKMetadata committingSegmentZKMetadata, int maxNumPartitionsPerInstance, List<PartitionGroupMetadata> partitionGroupMetadataList) {
        int threshold = this._flushThresholdComputer.computeThreshold(streamConfig, committingSegmentDescriptor, committingSegmentZKMetadata, partitionGroupMetadataList, newSegmentZKMetadata.getSegmentName());
        newSegmentZKMetadata.setSizeThresholdToFlushSegment(threshold);
    }
}

